/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.ProjectComponent;
import com.mathworks.project.api.WritableConfiguration;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.project.impl.desktop.BasicProjectClient;
import com.mathworks.project.impl.desktop.ProjectSettingsAction;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.settingsui.ParamWidgetBinder;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.toolbox.coder.plugin.inputtypes.IDPAttributes;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.HyperlinkTextLabel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;

public final class BuildSettingsSection
implements ProjectComponent {
    private final Configuration fConfiguration;
    private final MJPanel fComponent;
    private final PropertyChangeListener fPropertyChangeListener;
    private final ParamWidgetBinder fWidgetBinder;
    private final Param fTargetParam;
    private boolean fMex;
    private boolean fExe;
    private Param fOutputNameParam;
    private Param fGenerateCodeOnlyParam;
    private Param fGenerateMainParam;

    public BuildSettingsSection(WritableConfiguration writableConfiguration) {
        this.fConfiguration = (Configuration)writableConfiguration;
        this.fWidgetBinder = new ParamWidgetBinder(this.fConfiguration.getProject(), true);
        this.fComponent = new MJPanel();
        this.fComponent.setOpaque(false);
        Param param = this.fConfiguration.getTarget().getParam("param.artifact");
        if (!IDPAttributes.supportsFixedPoint()) {
            param = BuildSettingsSection.createNonFixedPointTargetParam(param);
        }
        this.fTargetParam = param;
        this.fPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Param param = BuildSettingsSection.this.fConfiguration.getChangedParam(propertyChangeEvent);
                if (param != null && param.getKey().equals(BuildSettingsSection.this.fTargetParam.getKey())) {
                    BuildSettingsSection.this.rebuild();
                }
            }
        };
        this.fConfiguration.addPropertyChangeListener(this.fPropertyChangeListener);
        this.rebuild();
    }

    private static Param createNonFixedPointTargetParam(Param param) {
        LinkedHashMap linkedHashMap = param.getOptions();
        Iterator iterator = linkedHashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            if (!((String)iterator.next().getKey()).equals("option.target.artifact.mex.instrumented")) continue;
            iterator.remove();
        }
        return new Param(param.getType(), param.getResourceProvider(), param.getKey(), param.getName(), param.getDescription(), param.getDetailedDescriptionHtml(), param.getMoreInfoLinkText(), param.getMoreInfoLinkCallback(), param.getMoreInfoLinkVisible(), param.getInstanceKey(), param.getInstanceName(), null, param.getDefaultValueExpression(), param.getDefaultValueAttribute(), (Map)linkedHashMap, null, param.getCustomWidgetClassName(), param.shouldSaveUnsetValue(), param.getVisibleAttribute(), param.getEnabledAttribute(), param.getSyntax(), param.getValidationRule(), false, param.getProfileKeys(), param.getInfrastructureAttributes(), param.getExtraAttributes(), param.getDependentKeys());
    }

    private void rebuild() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                BuildSettingsSection.this.fComponent.removeAll();
                BuildSettingsSection.this.fComponent.setLayout((LayoutManager)new GridBagLayout());
                BuildSettingsSection.this.fWidgetBinder.disposeWidgets();
                String string = BuildSettingsSection.this.fConfiguration.getParamAsString(BuildSettingsSection.this.fTargetParam.getKey());
                BuildSettingsSection.this.fMex = string.equals("option.target.artifact.mex") || string.equals("option.target.artifact.mex.instrumented");
                BuildSettingsSection.this.fExe = string.equals("option.target.artifact.exe");
                if (BuildSettingsSection.this.fMex) {
                    BuildSettingsSection.this.fOutputNameParam = BuildSettingsSection.this.fConfiguration.getTarget().getParam("param.mex.outputfile");
                    BuildSettingsSection.this.fGenerateCodeOnlyParam = null;
                } else {
                    BuildSettingsSection.this.fOutputNameParam = BuildSettingsSection.this.fConfiguration.getTarget().getParam("param.grt.outputfile");
                    BuildSettingsSection.this.fGenerateCodeOnlyParam = BuildSettingsSection.this.fConfiguration.getTarget().getParam("param.grt.GenCodeOnly");
                }
                if (BuildSettingsSection.this.fExe) {
                    BuildSettingsSection.this.fGenerateMainParam = BuildSettingsSection.this.fConfiguration.getTarget().getParam("param.buildtool.GenerateMain");
                } else {
                    BuildSettingsSection.this.fGenerateMainParam = null;
                }
                Component component = BuildSettingsSection.this.fWidgetBinder.createAndRegister(BuildSettingsSection.this.fTargetParam);
                GridBagConstraints gridBagConstraints = BuildSettingsSection.createConstraints();
                BuildSettingsSection.add((JComponent)BuildSettingsSection.this.fComponent, BuildSettingsSection.this.fOutputNameParam, BuildSettingsSection.this.fWidgetBinder.createAndRegister(BuildSettingsSection.this.fOutputNameParam), gridBagConstraints);
                ++gridBagConstraints.gridy;
                gridBagConstraints.gridx = 0;
                BuildSettingsSection.add((JComponent)BuildSettingsSection.this.fComponent, BuildSettingsSection.this.fTargetParam, component, gridBagConstraints);
                ++gridBagConstraints.gridy;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 1.0;
                BuildSettingsSection.this.fComponent.add(BuildSettingsSection.this.buildMinorOptions(), (Object)gridBagConstraints);
                BuildSettingsSection.this.fComponent.revalidate();
                BuildSettingsSection.this.fComponent.repaint();
            }
        });
    }

    private HyperlinkTextLabel createViewSettingsLink() {
        String string = CoderResources.getString("link.viewSettings");
        return Utilities.createLink(string, "link.viewSettings", new Runnable(){

            @Override
            public void run() {
                new ProjectSettingsAction().actionPerformed(new ActionEvent(BuildSettingsSection.this.fComponent, 0, null));
            }
        });
    }

    private static void add(JComponent jComponent, Param param, Component component, GridBagConstraints gridBagConstraints) {
        jComponent.add((Component)new MJLabel(param.getName() + ":"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jComponent.add(component, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
    }

    private Component buildMinorOptions() {
        Object object;
        String string;
        BasicProjectClient basicProjectClient = (BasicProjectClient)ProjectGUI.getInstance().getCurrentClient();
        MJButton mJButton = new MJButton((Action)basicProjectClient.getAction("BUILD"));
        MJPanel mJPanel = new MJPanel((LayoutManager)new GridBagLayout());
        mJPanel.setOpaque(false);
        GridBagConstraints gridBagConstraints = BuildSettingsSection.createConstraints();
        if (!PlatformInfo.isMacintosh()) {
            gridBagConstraints.insets.right = 0;
        }
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        ArrayList<Component> arrayList = new ArrayList<Component>();
        if (this.fExe) {
            if (this.fConfiguration.isParamVisible(this.fGenerateMainParam.getKey())) {
                arrayList.add(this.fWidgetBinder.createAndRegister(this.fGenerateMainParam));
            } else {
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.fill = 1;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.insets.bottom = 12;
                string = "fill:d:grow, fill:d";
                object = "p";
                FormLayout formLayout = new FormLayout(string, (String)object);
                PanelBuilder panelBuilder = new PanelBuilder(formLayout);
                String string2 = CoderResources.getString("param.exe.MainFunction");
                HyperlinkTextLabel hyperlinkTextLabel = new HyperlinkTextLabel(string2, new HyperlinkTextLabel.HyperlinkHandler(){

                    public void processHyperlink(String string) {
                        Utilities.help("specify_main_function");
                    }
                }, false, "link.MainFunction.innerComponent", string2);
                CellConstraints cellConstraints = new CellConstraints();
                JPanel jPanel = panelBuilder.getPanel();
                jPanel.setOpaque(false);
                panelBuilder.add((Component)hyperlinkTextLabel.getComponent(), cellConstraints.xy(1, 1));
                mJPanel.add((Component)jPanel, (Object)gridBagConstraints);
                gridBagConstraints.insets.bottom = 3;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.gridwidth = 1;
                ++gridBagConstraints.gridy;
            }
        }
        if (this.fGenerateCodeOnlyParam != null) {
            arrayList.add(this.fWidgetBinder.createAndRegister(this.fGenerateCodeOnlyParam));
        }
        if ((string = this.fConfiguration.getParamAsString(this.fTargetParam.getKey())).equals("option.target.artifact.mex.instrumented")) {
            object = Utilities.createDescriptionComponent("warning.instrumented.mex");
            gridBagConstraints.gridwidth = 2;
            mJPanel.add((Component)object, (Object)gridBagConstraints);
            gridBagConstraints.gridwidth = 1;
            ++gridBagConstraints.gridy;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            mJPanel.add((Component)arrayList.get(i), (Object)gridBagConstraints);
            if (i == 0) {
                ++gridBagConstraints.gridx;
                gridBagConstraints.fill = 0;
                gridBagConstraints.weightx = 0.0;
                mJPanel.add((Component)mJButton, (Object)gridBagConstraints);
            }
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
        }
        gridBagConstraints.insets.top = 6;
        ++gridBagConstraints.gridy;
        mJPanel.add((Component)this.createViewSettingsLink().getComponent(), (Object)gridBagConstraints);
        if (arrayList.isEmpty()) {
            ++gridBagConstraints.gridx;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            mJPanel.add((Component)mJButton, (Object)gridBagConstraints);
        }
        return mJPanel;
    }

    private static GridBagConstraints createConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 0, 3, PlatformInfo.isMacintosh() ? 3 : 6);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        return gridBagConstraints;
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    public void dispose() {
        this.fWidgetBinder.dispose();
        this.fConfiguration.removePropertyChangeListener(this.fPropertyChangeListener);
    }
}

