/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin.workflow;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.toolbox.coder.plugin.workflow.ProposedTypesModel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public final class ProposedTypesTableModel
implements TableModel {
    private static final Matlab MATLAB = new Matlab();
    private final String fFunctionName;
    private final ProposedTypesModel fModel;
    private final List<TableModelListener> fListeners;
    private Configuration fConfiguration;

    public ProposedTypesTableModel(ProposedTypesModel proposedTypesModel, String string, Configuration configuration) {
        this.fModel = proposedTypesModel;
        this.fFunctionName = string;
        this.fListeners = new LinkedList<TableModelListener>();
        this.fConfiguration = configuration;
    }

    @Override
    public int getRowCount() {
        return this.fModel.getVariableNames(this.fFunctionName).size();
    }

    @Override
    public int getColumnCount() {
        return this.fModel.getFieldCount();
    }

    @Override
    public String getColumnName(int n) {
        return this.fConfiguration.getResourceString("fxp.proposedtypes.column." + this.getVariableFieldName(n));
    }

    public String getVariableFieldName(int n) {
        return this.fModel.getVariableFieldName(n);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return this.fModel.getFieldType(this.fFunctionName, this.getVariableFieldName(n));
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.fModel.isEditable(n2);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        String string = this.fModel.getVariableName(this.fFunctionName, n);
        Object object = this.fModel.getAnnotationData(this.fFunctionName, string, this.getVariableFieldName(n2));
        return object != null ? object : this.fModel.getProposedData(this.fFunctionName, string, this.getVariableFieldName(n2));
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        String string = this.fModel.getVariableName(this.fFunctionName, n);
        this.fModel.setAnnotationData(this.fFunctionName, string, this.getVariableFieldName(n2), object);
        this.updateProposedType(this.fFunctionName, string, n, n2);
    }

    private void updateProposedType(final String string, final String string2, final int n, final int n2) {
        if (!this.fModel.hasProposedData(string, string2)) {
            for (TableModelListener tableModelListener : new ArrayList<TableModelListener>(this.fListeners)) {
                tableModelListener.tableChanged(new TableModelEvent(this, n, n2));
            }
            return;
        }
        String string3 = "emlhdlcoder.WorkFlow.Manager.instance.proposeType(" + this.fModel.getValue(string, string2, "DesignMin") + ", " + this.fModel.getValue(string, string2, "DesignMax") + ", " + this.fModel.getValue(string, string2, "IsInteger") + " )";
        final ProposedTypesTableModel proposedTypesTableModel = this;
        MATLAB.feval("eval", new Object[]{string3}, 1, new MatlabListener(){

            public void matlabEvent(MatlabEvent matlabEvent) {
                Iterator iterator;
                if (Matlab.getExecutionStatus((int)matlabEvent.getStatus()) == 0 && (iterator = matlabEvent.getResult()) instanceof String) {
                    ProposedTypesTableModel.this.fModel.setProposedTypeData(string, string2, "ProposedType", iterator);
                }
                for (TableModelListener tableModelListener : new ArrayList(ProposedTypesTableModel.this.fListeners)) {
                    tableModelListener.tableChanged(new TableModelEvent(proposedTypesTableModel, n, n2));
                }
            }
        });
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
        this.fListeners.add(tableModelListener);
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.fListeners.remove(tableModelListener);
    }
}

