/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.screener;

import com.mathworks.toolbox.coder.screener.ScreenerProblemType;
import com.mathworks.widgets.text.mcode.MTree;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class FileImpactModel {
    private final int fNodeCount;
    private final int fLineCount;
    private Set<MTree.Node> fBadNodes;
    private Set<Integer> fBadLines;
    private Map<ScreenerProblemType, Set<Integer>> fOffenseLines;
    private Map<String, Set<Integer>> fFunctionOffenseLines;
    private Map<ScreenerProblemType, Integer> fProblemImpact;
    private Map<String, Integer> fMathworksFunctionImpact;

    public FileImpactModel(MTree mTree) {
        this.fNodeCount = mTree.size();
        this.fLineCount = FileImpactModel.computeLineCount(mTree);
        this.fBadNodes = new HashSet<MTree.Node>();
        this.fBadLines = new HashSet<Integer>();
        this.fProblemImpact = new EnumMap<ScreenerProblemType, Integer>(ScreenerProblemType.class);
        this.fMathworksFunctionImpact = new HashMap<String, Integer>();
        this.fOffenseLines = new EnumMap<ScreenerProblemType, Set<Integer>>(ScreenerProblemType.class);
        this.fFunctionOffenseLines = new HashMap<String, Set<Integer>>();
    }

    public void add(ScreenerProblemType screenerProblemType, List<MTree.Node> ... listArray) {
        for (List<MTree.Node> list : listArray) {
            int n = this.addBadNodes(screenerProblemType, null, list);
            FileImpactModel.add(this.fProblemImpact, screenerProblemType, n);
        }
    }

    public void add(String string, List<MTree.Node> list) {
        int n = this.addBadNodes(ScreenerProblemType.UNSUPPORTED_FUNCTION, string, list);
        FileImpactModel.add(this.fMathworksFunctionImpact, string, n);
        FileImpactModel.add(this.fProblemImpact, ScreenerProblemType.UNSUPPORTED_FUNCTION, n);
    }

    public int getNodeCount() {
        return this.fNodeCount;
    }

    public int getBadNodeCount() {
        return this.fBadNodes.size();
    }

    public int getLineCount() {
        return this.fLineCount;
    }

    public int getBadLineCount() {
        return this.fBadLines.size();
    }

    public Set<ScreenerProblemType> getProblems() {
        return EnumSet.copyOf(this.fProblemImpact.keySet());
    }

    public Set<Integer> getLines(ScreenerProblemType screenerProblemType) {
        Set<Integer> set = this.fOffenseLines.get((Object)screenerProblemType);
        if (set == null) {
            return new TreeSet<Integer>();
        }
        return new TreeSet<Integer>(set);
    }

    public Set<Integer> getInvocationLines(String string) {
        Set<Integer> set = this.fFunctionOffenseLines.get(string);
        if (set == null) {
            return new TreeSet<Integer>();
        }
        return new TreeSet<Integer>(set);
    }

    public int getNodeCount(ScreenerProblemType screenerProblemType) {
        Integer n = this.fProblemImpact.get((Object)screenerProblemType);
        return n == null ? 0 : n;
    }

    public Set<String> getInvalidMathworksFunctions() {
        return new HashSet<String>(this.fMathworksFunctionImpact.keySet());
    }

    public int getInvocationNodeCount(String string) {
        Integer n = this.fMathworksFunctionImpact.get(string);
        return n == null ? 0 : n;
    }

    private int addBadNodes(ScreenerProblemType screenerProblemType, String string, List<MTree.Node> list) {
        if (list.size() == 1 && list.get(0) == null) {
            return 0;
        }
        int n = this.fBadNodes.size();
        Set<Integer> set = this.fOffenseLines.get((Object)screenerProblemType);
        Set<Integer> set2 = null;
        if (string != null && (set2 = this.fFunctionOffenseLines.get(string)) == null) {
            set2 = new TreeSet<Integer>();
            this.fFunctionOffenseLines.put(string, set2);
        }
        if (set == null) {
            set = new TreeSet<Integer>();
            this.fOffenseLines.put(screenerProblemType, set);
        }
        this.fBadNodes.addAll(list);
        for (MTree.Node node : list) {
            set.add(node.getStartLine());
            if (set2 != null) {
                set2.add(node.getStartLine());
            }
            for (int i = node.getStartLine(); i <= node.getEndLine(); ++i) {
                this.fBadLines.add(i);
            }
        }
        return this.fBadNodes.size() - n;
    }

    private static <T> void add(Map<T, Integer> map, T t, int n) {
        if (n != 0) {
            Integer n2 = map.get(t);
            map.put(t, n2 == null ? n : n2 + n);
        }
    }

    private static int computeLineCount(MTree mTree) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        LinkedList<MTree.Node> linkedList = new LinkedList<MTree.Node>();
        linkedList.offer(mTree.getRoot());
        HashSet<MTree.Node> hashSet2 = new HashSet<MTree.Node>();
        while (!linkedList.isEmpty()) {
            MTree.Node node = (MTree.Node)linkedList.poll();
            if (node.getType() != MTree.NodeType.COMMENT && node.getType() != MTree.NodeType.FUNCTION && node.getStartLine() > 0) {
                for (int i = node.getStartLine(); i <= node.getEndLine(); ++i) {
                    hashSet.add(i);
                }
            }
            if (node.getNext() != null && hashSet2.add(node.getNext())) {
                linkedList.offer(node.getNext());
            }
            if (node.getLeft() != null && hashSet2.add(node.getLeft())) {
                linkedList.offer(node.getLeft());
            }
            if (node.getRight() != null && hashSet2.add(node.getRight())) {
                linkedList.offer(node.getRight());
            }
            if (node.getBody() == null || !hashSet2.add(node.getBody())) continue;
            linkedList.offer(node.getBody());
        }
        return hashSet.size();
    }
}

