/*
 * Decompiled with CFR 0.152.
 */
package ice.storm;

import ice.debug.Debug;
import ice.storm.CallbackAdapter;
import ice.storm.ContentLoader;
import ice.storm.DefaultFactory;
import ice.storm.HistoryManager;
import ice.storm.Pilot;
import ice.storm.PilotFactory;
import ice.storm.PilotInfo;
import ice.storm.PseudoHistoryManager;
import ice.storm.Scripter;
import ice.storm.ScripterCallback;
import ice.storm.ScripterFactory;
import ice.storm.ScripterInfo;
import ice.storm.StormCallback;
import ice.storm.URLClassLoaderFactory;
import ice.storm.UrlMaster;
import ice.storm.Viewport;
import ice.storm.ViewportCallback;
import ice.storm.ViewportLayoutManager;
import ice.storm.ViewportVisitor;
import ice.util.Defs;
import ice.util.Emulation;
import ice.util.alg.IThread;
import ice.util.alg.Listeners;
import ice.util.alg.Session;
import ice.util.awt.TimedAWTExecutor;
import ice.util.memory.MemoryManager;
import ice.util.security.BoxedCode;
import ice.util.security.SecurityKit;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class StormBase {
    public static final String VERSION = "v6_0_2";
    public static final String EXPIRES_STRING = "EXPIRY_DATE_TEXT";
    public static final String EXPIRES_LONG = "988668001910L";
    private static final boolean OEAB;
    private final Object Z = new Object();
    private HistoryManager add;
    private PilotFactory addElement;
    private URLClassLoaderFactory addPropertyChangeListener;
    private String append = "awt";
    private Container badArg;
    private ViewportCallback base;
    private ScripterCallback booleanProperty;
    private Hashtable box_createTopLevelContainer = new Hashtable();
    private Vector bug = new Vector();
    String initialViewportName;
    private Viewport canGoBack;
    private Object canGoForward;
    private Hashtable clear = new Hashtable();
    private TimedAWTExecutor clearContent;
    private UrlMaster clearViewportContent;
    private final long[] clearWindowObj = new long[1];
    private MemoryCheck configureViewport;
    private final boolean containsKey = Debug.trace && Defs.booleanProperty((String)"ice.storm.trace_viewport_messages");
    private Session createPilot;

    public StormBase() {
        this(new Session());
    }

    public StormBase(Session session) {
        this.createPilot = session;
        this.OEAB();
        DefaultFactory defaultFactory = new DefaultFactory();
        defaultFactory.loadDefaultResources();
        this.addElement = defaultFactory;
        this.addPropertyChangeListener = defaultFactory;
        this.setHistoryManager(new PseudoHistoryManager(this));
        this.addPropertyChangeListener(this.getHistoryManager(), null);
    }

    public final Session getSession() {
        return this.createPilot;
    }

    private void OEAB() {
        String string = Defs.sysProperty((String)"ice.browser.memoryCheck.period");
        if (string != null) {
            long l;
            block4: {
                l = 0L;
                try {
                    l = Long.parseLong(string);
                }
                catch (RuntimeException runtimeException) {
                    if (!Debug.ex) break block4;
                    Debug.ex((Throwable)runtimeException);
                }
            }
            if (l > 0L) {
                this.configureViewport = new MemoryCheck(this, l);
            }
        }
    }

    void onLowMemory() {
        Vector vector = this.bug;
        int n = vector.size();
        while (n-- != 0) {
            Viewport viewport = (Viewport)vector.elementAt(n);
            this.Z(viewport);
        }
    }

    private void Z(Viewport viewport) {
        Viewport viewport2 = viewport.getFirstChild();
        while (viewport2 != null) {
            this.Z(viewport2);
            viewport2 = viewport2.getNextSibling();
        }
        Pilot pilot = viewport.getPilot();
        if (pilot != null) {
            pilot.onLowMemory();
        }
    }

    public final void setHistoryManager(HistoryManager historyManager) {
        this.add = historyManager;
    }

    public final HistoryManager getHistoryManager() {
        return this.add;
    }

    public final ScripterFactory getScripterFactory() {
        return this.getPilotFactory();
    }

    public final void setPilotFactory(PilotFactory pilotFactory) {
        this.addElement = pilotFactory;
    }

    public final PilotFactory getPilotFactory() {
        return this.addElement;
    }

    public final void setURLClassLoaderFactory(URLClassLoaderFactory uRLClassLoaderFactory) {
        this.addPropertyChangeListener = uRLClassLoaderFactory;
    }

    public final URLClassLoaderFactory getURLClassLoaderFactory() {
        return this.addPropertyChangeListener;
    }

    public final void setComponentToolkitName(String string) {
        this.append = string;
    }

    public final String getComponentToolkitName() {
        return this.append;
    }

    public final void setContainer(Container container, String string) {
        if (this.base != null || this.badArg != null) {
            return;
        }
        this.badArg = container;
        this.configureViewport(new Viewport(this, string));
    }

    public final Container getContainer(Container container) {
        return this.badArg;
    }

    public final void setCallback(StormCallback stormCallback) {
        CallbackAdapter.OldCallbackWrap oldCallbackWrap = new CallbackAdapter.OldCallbackWrap(stormCallback);
        oldCallbackWrap.registerWith(this);
    }

    public final StormCallback getCallback() {
        if (this.base instanceof CallbackAdapter) {
            return ((CallbackAdapter.OldCallbackWrap)this.base).oldCallback;
        }
        return null;
    }

    public final ViewportCallback getViewportCallback() {
        return this.base;
    }

    public final void setViewportCallback(ViewportCallback viewportCallback) {
        if (this.badArg != null) {
            return;
        }
        this.base = viewportCallback;
        this.base.init(this);
    }

    public final ScripterCallback getScripterCallback() {
        return this.booleanProperty;
    }

    public final void setScripterCallback(ScripterCallback scripterCallback) {
        this.booleanProperty = scripterCallback;
    }

    public void setActiveViewport(Viewport viewport) {
        this.canGoBack = viewport;
    }

    public Viewport getActiveViewport() {
        return this.canGoBack;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener, String string) {
        if (string == null) {
            Object object = this.Z;
            synchronized (object) {
                this.canGoForward = Listeners.add((Object)this.canGoForward, (Object)propertyChangeListener);
            }
        } else {
            Viewport viewport = this.findViewportByName(string);
            if (viewport != null) {
                viewport.addPropertyChangeListener(propertyChangeListener);
            }
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener, String string) {
        if (string == null) {
            Object object = this.Z;
            synchronized (object) {
                this.canGoForward = Listeners.remove((Object)this.canGoForward, (Object)propertyChangeListener);
            }
        } else {
            Viewport viewport = this.findViewportByName(string);
            if (viewport != null) {
                viewport.removePropertyChangeListener(propertyChangeListener);
            }
        }
    }

    boolean sendViewportMessage(Viewport viewport, String string, Object object, Object object2) {
        if (viewport == null) {
            Debug.bug();
        }
        if (this.containsKey && Debug.trace) {
            Debug.trace((String)(viewport + ", " + string + ", " + object + ", " + object2));
        }
        if (this.base != null) {
            try {
                this.base.processViewportMessage(viewport, string, object, object2);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (Debug.ex) {
                    Debug.ex((Throwable)outOfMemoryError);
                }
                return false;
            }
            catch (RuntimeException runtimeException) {
                if (Debug.ex) {
                    Debug.ex((Throwable)runtimeException);
                }
                return false;
            }
        }
        boolean bl = true;
        PropertyChangeEvent propertyChangeEvent = null;
        Viewport viewport2 = viewport;
        while (true) {
            Object object3;
            if ((object3 = viewport2 == null ? this.canGoForward : viewport2.getPropertyListeners()) != null) {
                if (propertyChangeEvent == null) {
                    propertyChangeEvent = new PropertyChangeEvent(viewport, string, object, object2);
                }
                bl &= StormBase.add(object3, propertyChangeEvent);
            }
            if (viewport2 == null) break;
            viewport2 = viewport2.getParent();
        }
        return bl;
    }

    private static boolean add(Object object, PropertyChangeEvent propertyChangeEvent) {
        PropertyChangeListener propertyChangeListener;
        if (object == null) {
            Defs.badArg();
        }
        boolean bl = true;
        int n = 0;
        while ((propertyChangeListener = (PropertyChangeListener)Listeners.get((Object)object, (int)n)) != null) {
            try {
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (Debug.ex) {
                    Debug.ex((Throwable)outOfMemoryError);
                }
                return false;
            }
            catch (RuntimeException runtimeException) {
                if (Debug.ex) {
                    Debug.ex((Throwable)runtimeException);
                }
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    public boolean isMimeTypeEnabled(String string) {
        Enumeration enumeration;
        PilotFactory pilotFactory;
        boolean bl = false;
        if (!this.clear.containsKey(string) && (pilotFactory = this.getPilotFactory()) != null && (enumeration = pilotFactory.getAllPilotInfos()) != null) {
            while (enumeration.hasMoreElements()) {
                PilotInfo pilotInfo = (PilotInfo)enumeration.nextElement();
                if (!pilotInfo.isSupportedContentType(string)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void setMimeTypeEnabled(String string, boolean bl) {
        Object v = this.clear.get(string);
        if (v != null && bl) {
            this.clear.remove(string);
        } else if (v == null && !bl) {
            this.clear.put(string, string);
        }
    }

    public UrlMaster getUrlMaster() {
        UrlMaster urlMaster = this.clearViewportContent;
        if (urlMaster == null) {
            this.clearViewportContent = urlMaster = UrlMaster.get(this.createPilot);
        }
        return urlMaster;
    }

    public void renderContent(String string, String string2, String string3) {
        this.renderContent(string, string2, this.addPropertyChangeListener(string3));
    }

    public void renderContent(String string, String string2, Viewport viewport) {
        if (viewport == null) {
            Debug.bug();
        }
        string = this.getUrlMaster().resolve(viewport.getBaseUrl(), string);
        Debug.trace((String)(string + " in " + viewport));
        Scripter scripter = this.getScripterForCodeLocation(string);
        if (scripter != null) {
            scripter.evalCodeLocation(viewport, string);
            return;
        }
        Object object = this.Z;
        synchronized (object) {
            ContentLoader contentLoader = new ContentLoader(string, string2);
            contentLoader.setReferer(viewport.getBaseUrl());
            if (this.addElement(contentLoader, viewport) && contentLoader.getPostData() == null) {
                return;
            }
            try {
                this.stopLoading(viewport.getName());
            }
            catch (RuntimeException runtimeException) {
                Debug.ex((Throwable)runtimeException);
            }
            viewport.queueRenderContent(contentLoader);
        }
        this.sendViewportMessage(viewport, "viewport", null, "ready");
    }

    private boolean addElement(ContentLoader contentLoader, Viewport viewport) {
        String string;
        String string2;
        boolean bl = false;
        URL uRL = contentLoader.getURL();
        if (uRL != null && (string2 = uRL.getRef()) != null && (string = viewport.getLocation()) != null) {
            Pilot pilot;
            String string3;
            int n = string.lastIndexOf(35);
            if (n >= 0) {
                string = string.substring(0, n);
            }
            if ((n = (string3 = uRL.toExternalForm()).lastIndexOf(35)) >= 0) {
                string3 = string3.substring(0, n);
            }
            if (string.equals(string3) && (pilot = viewport.getPilot()) != null) {
                bl = true;
                if (pilot.refExists(string2)) {
                    try {
                        this.getHistoryManager().goingSomewhere(contentLoader, viewport.getId());
                        pilot.gotoRef(string2);
                    }
                    catch (RuntimeException runtimeException) {
                        Debug.ex((Throwable)runtimeException);
                    }
                }
            }
        }
        return bl;
    }

    public void renderContent(ContentLoader contentLoader, String string) {
        Viewport viewport = this.addPropertyChangeListener(string);
        if (viewport == null) {
            if (Debug.trace) {
                Debug.trace((String)("Failed: no view for " + string));
            }
            return;
        }
        this.renderViewportContent(contentLoader, viewport);
    }

    public void renderViewportContent(ContentLoader contentLoader, Viewport viewport) {
        Debug.trace((String)("loader=" + contentLoader + " view=" + viewport));
        Object object = this.Z;
        synchronized (object) {
            if (this.addElement(contentLoader, viewport) && contentLoader.getPostData() == null) {
                return;
            }
            this.stopViewportLoading(viewport);
            viewport.queueRenderContent(contentLoader);
        }
        this.sendViewportMessage(viewport, "viewport", null, "ready");
    }

    public void renderContentFully(ContentLoader contentLoader, String string) {
        Viewport viewport = this.addPropertyChangeListener(string);
        if (viewport == null) {
            Debug.trace((String)("Failed: no viewport for " + string + " to render " + contentLoader));
            return;
        }
        this.renderViewportContentFully(contentLoader, viewport);
    }

    public void renderVieportContentFully(ContentLoader contentLoader, Viewport viewport) {
        this.renderViewportContentFully(contentLoader, viewport);
    }

    public void renderViewportContentFully(ContentLoader contentLoader, Viewport viewport) {
        Debug.trace((String)("contentLoader=" + contentLoader + ", viewport=" + viewport));
        Object object = this.Z;
        synchronized (object) {
            if (this.addElement(contentLoader, viewport) && contentLoader.getPostData() == null) {
                return;
            }
            this.stopViewportLoading(viewport);
            this.do_render_content(contentLoader, viewport);
        }
        this.sendViewportMessage(viewport, "viewport", null, "ready");
    }

    public void clearContent(String string, String string2) {
        Viewport viewport = this.addPropertyChangeListener(string2);
        if (viewport == null) {
            return;
        }
        if (Debug.trace) {
            Debug.trace((String)("contentType=" + string + " viewport=" + viewport));
        }
        this.stopViewportLoading(viewport);
        this.do_clear_content(null, string, viewport);
        this.sendViewportMessage(viewport, "viewport", null, "ready");
    }

    public void clearVieportContent(String string, Viewport viewport) {
        this.clearViewportContent(string, viewport);
    }

    public void clearViewportContent(String string, Viewport viewport) {
        Debug.trace((String)("contentType=" + string + ", viewport=" + viewport));
        this.stopViewportLoading(viewport);
        this.do_clear_content(null, string, viewport);
        this.sendViewportMessage(viewport, "viewport", null, "ready");
    }

    public Viewport newTopLevelViewport(String string) {
        Viewport viewport = new Viewport(this, string);
        if (!this.configureViewport(viewport)) {
            viewport = null;
        }
        return viewport;
    }

    private Viewport addPropertyChangeListener(String string) {
        if ("_blank".equals(string)) {
            string = null;
        }
        Viewport viewport = null;
        Object object = this.Z;
        synchronized (object) {
            if (string != null) {
                if (this.bug.size() == 0) {
                    this.initialViewportName = string = new String(string);
                } else {
                    viewport = this.findViewportByName(string);
                }
            } else if (this.badArg != null && this.bug.size() == 1) {
                viewport = (Viewport)this.bug.elementAt(0);
            }
        }
        if (viewport == null) {
            viewport = this.newTopLevelViewport(string);
        }
        return viewport;
    }

    void do_clear_content(ContentLoader contentLoader, String string, Viewport viewport) {
        Object object;
        if (viewport.isStopRequested()) {
            return;
        }
        Object object2 = this.Z;
        synchronized (object2) {
            object = new ViewportUnloader(this);
            viewport.iterate((ViewportVisitor)object);
        }
        if (OEAB) {
            object = this.Z;
            synchronized (object) {
                viewport.clearContent();
            }
            Pilot pilot = viewport.getPilot();
            if (pilot != null) {
                viewport.removePilot();
            }
            Object object3 = this.Z;
            synchronized (object3) {
                viewport.removeWindowVariables();
            }
            this.append(contentLoader, string, viewport);
        } else {
            object = this.Z;
            synchronized (object) {
                viewport.clearContent();
            }
            Pilot pilot = viewport.getPilot();
            if (pilot != null) {
                boolean bl = this.getPilotFactory().isContentTypeSupported(pilot, contentLoader, string);
                if (!bl) {
                    if (viewport.isStopRequested()) {
                        return;
                    }
                    viewport.removePilot();
                    pilot = null;
                } else {
                    if (contentLoader != null) {
                        string = contentLoader.getContentType();
                    }
                    viewport.setLocationUrl(null);
                    pilot.clear(string);
                }
            }
            Object object4 = this.Z;
            synchronized (object4) {
                viewport.removeWindowVariables();
            }
            if (pilot == null) {
                this.append(contentLoader, string, viewport);
            }
        }
    }

    private void append(ContentLoader contentLoader, String string, Viewport viewport) {
        Pilot pilot;
        this.sendViewportMessage(viewport, "pilotLoading", null, "begin");
        if (this.clear.containsKey(string)) {
            pilot = this.getPilotFactory().createPilot("application/disabled");
        } else if (contentLoader != null) {
            pilot = this.getPilotFactory().createPilot(contentLoader);
            string = contentLoader.getContentType();
        } else {
            pilot = this.getPilotFactory().createPilot(string);
        }
        if (pilot == null) {
            this.sendViewportMessage(viewport, "pilotLoading", null, "error");
            return;
        }
        if (viewport.isStopRequested()) {
            return;
        }
        pilot.base = this;
        pilot.viewport = viewport;
        pilot.init(this.append);
        viewport.setPilot(pilot);
        viewport.setLocationUrl(null);
        pilot.clear(string);
        this.sendViewportMessage(viewport, "pilotLoading", null, "end");
    }

    void do_render_content(ContentLoader contentLoader, Viewport viewport) {
        IOException iOException;
        if (!this.sendViewportMessage(viewport, "contentLoading", contentLoader, "request")) {
            return;
        }
        this.sendViewportMessage(viewport, "contentLoading", contentLoader, "connect");
        if (!contentLoader.hasReply() && contentLoader.getContentType() == null) {
            contentLoader.make();
        }
        if ((iOException = contentLoader.getException()) == null) {
            if (contentLoader.getContentType().equals("application/external")) {
                return;
            }
            if (viewport.isStopRequested()) {
                return;
            }
            this.do_clear_content(contentLoader, contentLoader.getContentType(), viewport);
            viewport.setLocationUrl(contentLoader.getLocation());
            if (viewport.isStopRequested()) {
                return;
            }
            Pilot pilot = viewport.getPilot();
            this.getHistoryManager().goingSomewhere(contentLoader, viewport.getId());
            if (viewport.isStopRequested()) {
                return;
            }
            this.sendViewportMessage(viewport, "contentLoading", contentLoader, "begin");
            if (!this.badArg(viewport, contentLoader)) {
                try {
                    pilot.parse(contentLoader);
                }
                catch (IOException iOException2) {
                    if (Debug.ex) {
                        Debug.ex((Throwable)iOException2);
                    }
                    iOException = iOException2;
                    contentLoader.setException(iOException);
                }
            }
            if (viewport.isStopRequested()) {
                return;
            }
            if (iOException == null) {
                this.sendViewportMessage(viewport, "contentLoading", contentLoader, "end");
                pilot.parsingDone();
            }
        }
        if (iOException != null) {
            if (Debug.trace) {
                Debug.trace((String)("Failed to load: " + contentLoader));
            }
            this.sendViewportMessage(viewport, "contentLoading", contentLoader, "error");
        }
    }

    private final boolean badArg(Viewport viewport, ContentLoader contentLoader) {
        int n = 0;
        String string = contentLoader.getLocation();
        if (string == null) {
            return false;
        }
        viewport = viewport.getParent();
        while (viewport != null) {
            String string2 = viewport.getLocation();
            if (string2 != null && string.equals(string2) && ++n > 1) {
                long[] lArray = this.clearWindowObj;
                synchronized (lArray) {
                    if (this.clearWindowObj[0] == 0L) {
                        this.clearWindowObj[0] = System.currentTimeMillis();
                        boolean bl = false;
                        return bl;
                    }
                    if (System.currentTimeMillis() - this.clearWindowObj[0] > 2000L) {
                        this.clearWindowObj[0] = System.currentTimeMillis();
                        boolean bl = false;
                        return bl;
                    }
                    this.clearWindowObj[0] = System.currentTimeMillis();
                }
                return true;
            }
            viewport = viewport.getParent();
        }
        return false;
    }

    public void reload(String string) {
        this.getHistoryManager().reload(string);
    }

    public void goBack(String string) {
        this.getHistoryManager().goBack(string);
    }

    public boolean canGoBack(String string) {
        return this.getHistoryManager().canGoBack(string);
    }

    public void goForward(String string) {
        this.getHistoryManager().goForward(string);
    }

    public boolean canGoForward(String string) {
        return this.getHistoryManager().canGoForward(string);
    }

    public boolean configureViewport(Viewport viewport, String string) {
        return this.configureViewport(viewport);
    }

    public boolean configureViewport(Viewport viewport) {
        Object object = this.Z;
        synchronized (object) {
            this.canGoBack = null;
        }
        if (this.base != null) {
            Object object2 = this.Z;
            synchronized (object2) {
                this.bug.addElement(viewport);
            }
            Container container = (Container)SecurityKit.doPrivileged((BoxedCode)CallbackAdapter.box_createTopLevelContainer(this.base, viewport));
            if (container == null && !"none".equalsIgnoreCase(this.append)) {
                if (Debug.trace) {
                    Debug.trace((String)("Failed to create AWT container for " + viewport));
                }
                Object object3 = this.Z;
                synchronized (object3) {
                    this.bug.removeElement(viewport);
                }
                return false;
            }
            if (Debug.trace) {
                Viewport viewport2 = null;
                Object object4 = this.Z;
                synchronized (object4) {
                    Vector vector = this.bug;
                    int n = vector.size();
                    while (n-- != 0) {
                        Viewport viewport3 = (Viewport)vector.elementAt(n);
                        if (viewport == viewport3 || viewport3.getContainer() != container) continue;
                        viewport2 = viewport3;
                        break;
                    }
                }
                if (viewport2 != null) {
                    Debug.trace((String)("ERROR: got same AWT container for " + viewport2 + " and " + viewport));
                }
            }
            viewport.setContainer(container);
            if (container != null) {
                container.setLayout(new ViewportLayoutManager(viewport));
            }
        } else if (this.badArg != null) {
            if (this.bug.size() > 0) {
                return false;
            }
            viewport.setContainer(this.badArg);
            if (this.badArg != null) {
                this.badArg.setLayout(new ViewportLayoutManager(viewport));
            }
            Object object5 = this.Z;
            synchronized (object5) {
                this.bug.addElement(viewport);
            }
        }
        return true;
    }

    public Viewport findViewportByName(String string) {
        Object object = this.Z;
        synchronized (object) {
            Viewport viewport = null;
            int n = 0;
            while (n < this.bug.size() && viewport == null) {
                viewport = (Viewport)this.bug.elementAt(n);
                viewport = viewport.findViewportByName(string);
                ++n;
            }
            Viewport viewport2 = viewport;
            return viewport2;
        }
    }

    void getAllPilotInstances(Class clazz, Vector vector) {
        Object object = this.Z;
        synchronized (object) {
            int n = 0;
            while (n != this.bug.size()) {
                Viewport viewport = (Viewport)this.bug.elementAt(n);
                this.base(viewport, clazz, vector);
                ++n;
            }
        }
    }

    private void base(Viewport viewport, Class clazz, Vector vector) {
        Pilot pilot = viewport.getPilot();
        if (clazz.isInstance(pilot)) {
            vector.addElement(pilot);
        }
        Viewport viewport2 = viewport.getFirstChild();
        while (viewport2 != null) {
            this.base(viewport2, clazz, vector);
            viewport2 = viewport2.getNextSibling();
        }
    }

    private boolean booleanProperty(Viewport viewport) {
        Object object = this.Z;
        synchronized (object) {
            int n = 0;
            int n2 = this.bug.size();
            while (n != n2) {
                if (viewport == this.bug.elementAt(n)) {
                    boolean bl = true;
                    return bl;
                }
                ++n;
            }
        }
        return false;
    }

    boolean isKnownViewport(Viewport viewport) {
        viewport = viewport.getTopParent();
        return this.booleanProperty(viewport);
    }

    Viewport findViewportByHistoryId(String string) {
        Object object = this.Z;
        synchronized (object) {
            Viewport viewport = null;
            int n = 0;
            while (n < this.bug.size() && viewport == null) {
                viewport = (Viewport)this.bug.elementAt(n);
                viewport = viewport.findViewportByHistoryId(string);
                ++n;
            }
            Viewport viewport2 = viewport;
            return viewport2;
        }
    }

    public void getAllViewports(Vector vector) {
        Object object = this.Z;
        synchronized (object) {
            int n = 0;
            int n2 = this.bug.size();
            while (n != n2) {
                Viewport viewport = (Viewport)this.bug.elementAt(n);
                viewport.getViewAndAllChildren(vector);
                ++n;
            }
        }
    }

    public void closeViewport(String string) {
        Viewport viewport = null;
        Object object = this.Z;
        synchronized (object) {
            this.canGoBack = null;
            int n = 0;
            while (n < this.bug.size()) {
                Viewport viewport2 = (Viewport)this.bug.elementAt(n);
                if (viewport2.getId().equals(string) || viewport2.getName().equals(string)) {
                    viewport = viewport2;
                    break;
                }
                ++n;
            }
            if (viewport == null) {
                if (Debug.trace) {
                    Debug.trace((String)("No top view: " + string));
                }
                return;
            }
            this.bug.removeElementAt(n);
        }
        if (Debug.trace) {
            Debug.trace((String)("view=" + viewport));
        }
        viewport.stopLoading();
        viewport.dispose();
        if (this.base != null) {
            this.base.disposeTopLevelContainer(viewport);
        }
    }

    public String getViewportState(String string) {
        Viewport viewport = this.findViewportByName(string);
        if (viewport == null) {
            return null;
        }
        return viewport.stateString;
    }

    public void stopLoading(String string) {
        Viewport viewport = this.findViewportByName(string);
        if (viewport != null) {
            this.stopViewportLoading(viewport);
        }
    }

    public void stopViewportLoading(Viewport viewport) {
        this.sendViewportMessage(viewport, "contentLoading", null, "stop");
        Object object = this.Z;
        synchronized (object) {
            this.process_stop_loading(viewport);
        }
    }

    void process_stop_loading(Viewport viewport) {
        viewport.stopLoading();
        Viewport viewport2 = viewport.getFirstChild();
        while (viewport2 != null) {
            this.process_stop_loading(viewport2);
            viewport2 = viewport2.getNextSibling();
        }
    }

    public void dispose() {
        Object object;
        Enumeration<Object> enumeration = this.box_createTopLevelContainer.elements();
        while (enumeration.hasMoreElements()) {
            object = (Scripter)enumeration.nextElement();
            ((Scripter)object).dispose();
        }
        this.box_createTopLevelContainer.clear();
        object = this.Z;
        synchronized (object) {
            this.canGoBack = null;
            enumeration = this.bug.elements();
            while (enumeration.hasMoreElements()) {
                Viewport viewport = (Viewport)enumeration.nextElement();
                viewport.dispose();
            }
            this.bug.removeAllElements();
            this.initialViewportName = null;
        }
        if (this.clearContent != null) {
            this.clearContent.shutdown();
        }
        this.createPilot.disposeResources();
    }

    public static void unload() {
    }

    public void suspend() {
        Object object;
        Enumeration<Object> enumeration = this.box_createTopLevelContainer.elements();
        while (enumeration.hasMoreElements()) {
            object = (Scripter)enumeration.nextElement();
            ((Scripter)object).suspend();
        }
        enumeration = this.bug.elements();
        while (enumeration.hasMoreElements()) {
            object = (Viewport)enumeration.nextElement();
            Pilot pilot = ((Viewport)object).getPilot();
            if (pilot == null) continue;
            pilot.suspend();
        }
    }

    public void resume() {
        Object object;
        Enumeration<Object> enumeration = this.box_createTopLevelContainer.elements();
        while (enumeration.hasMoreElements()) {
            object = (Scripter)enumeration.nextElement();
            ((Scripter)object).resume();
        }
        enumeration = this.bug.elements();
        while (enumeration.hasMoreElements()) {
            object = (Viewport)enumeration.nextElement();
            Pilot pilot = ((Viewport)object).getPilot();
            if (pilot == null) continue;
            pilot.resume();
        }
    }

    public Scripter getScripterForCodeLocation(String string) {
        int n = string.indexOf(58);
        if (n > 0) {
            String string2 = string.substring(0, n);
            return this.getScripter(string2);
        }
        return null;
    }

    public Scripter getScripter(String string) {
        Object object = this.Z;
        synchronized (object) {
            ScripterInfo scripterInfo = this.getPilotFactory().getScripterInfo(string);
            if (scripterInfo == null) {
                Scripter scripter = null;
                return scripter;
            }
            Scripter scripter = (Scripter)this.box_createTopLevelContainer.get(scripterInfo);
            if (scripter != null) {
                Scripter scripter2 = scripter;
                return scripter2;
            }
            scripter = this.getPilotFactory().createScripter(string);
            if (scripter == null) {
                Scripter scripter3 = null;
                return scripter3;
            }
            this.box_createTopLevelContainer.put(scripterInfo, scripter);
            scripter.init(this);
            Scripter scripter4 = scripter;
            return scripter4;
        }
    }

    public void unloadAllScripters() {
        Object object = this.Z;
        synchronized (object) {
            Object object2;
            Enumeration enumeration = this.getPilotFactory().getAllScripterInfos();
            while (enumeration.hasMoreElements()) {
                object2 = (ScripterInfo)enumeration.nextElement();
                ((ScripterInfo)object2).setEnabled(false);
            }
            enumeration = this.box_createTopLevelContainer.elements();
            while (enumeration.hasMoreElements()) {
                object2 = (Scripter)enumeration.nextElement();
                ((Scripter)object2).dispose();
            }
            this.box_createTopLevelContainer.clear();
            object2 = this.bug;
            int n = ((Vector)object2).size();
            while (n-- != 0) {
                Viewport viewport = (Viewport)((Vector)object2).elementAt(n);
                this.box_createTopLevelContainer(viewport);
            }
        }
    }

    private void box_createTopLevelContainer(Viewport viewport) {
        viewport.clearWindowObj();
        viewport = viewport.getFirstChild();
        while (viewport != null) {
            this.box_createTopLevelContainer(viewport);
            viewport = viewport.getNextSibling();
        }
    }

    private TimedAWTExecutor bug() {
        TimedAWTExecutor timedAWTExecutor = this.clearContent;
        if (timedAWTExecutor == null) {
            StormBase stormBase = this;
            synchronized (stormBase) {
                timedAWTExecutor = this.clearContent;
                if (timedAWTExecutor == null) {
                    this.clearContent = timedAWTExecutor = new TimedAWTExecutor();
                }
            }
        }
        return timedAWTExecutor;
    }

    public void runOnEventThreadAndWait(Runnable runnable, long l) {
        try {
            this.bug().invokeAndWait(runnable, l);
        }
        catch (InterruptedException interruptedException) {
            Debug.ex((Throwable)interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Debug.ex((Throwable)invocationTargetException);
        }
    }

    public void runOnEventThreadLater(Runnable runnable, long l) {
        this.bug().invokeLater(runnable, l);
    }

    public boolean isEventThread() {
        return this.bug().isEventThread();
    }

    static {
        if (Debug.trace) {
            Debug.traceAsIs((String)"ICEbrowser v6_0_2");
        } else if (Defs.booleanProperty((String)"ice.browser.verbose", (boolean)true)) {
            System.out.println("ICEbrowser v6_0_2");
            System.out.println("(c) ICEsoft Technologies, Inc.");
        }
        String string = Defs.property((String)"http.agent");
        if (string == null) {
            string = Emulation.getEmulatedUserAgent();
            Defs.setSystemProperty((String)"http.agent", (String)string);
        }
        OEAB = Defs.booleanProperty((String)"ice.storm.disable_pilot_reuse");
    }

    final class ViewportUnloader
    implements ViewportVisitor {
        private final StormBase this$0;

        ViewportUnloader(StormBase stormBase) {
            this.this$0 = stormBase;
        }

        public final void visit(Viewport viewport) {
            Pilot pilot = viewport.getPilot();
            if (pilot != null) {
                pilot.beforeUnload();
            }
        }
    }

    class MemoryCheck
    implements Runnable {
        boolean shouldStop;
        long check_interval;
        MemoryManager memory_manager;
        private final StormBase this$0;

        MemoryCheck(StormBase stormBase, long l) {
            IThread iThread;
            block3: {
                this.this$0 = stormBase;
                this.memory_manager = MemoryManager.getInstance();
                this.check_interval = l;
                iThread = new IThread((Runnable)this, "Memory Check");
                iThread.setDaemon(true);
                int n = iThread.getPriority();
                if (n > 1) {
                    try {
                        iThread.setPriority(n - 1);
                    }
                    catch (RuntimeException runtimeException) {
                        if (!Debug.ex) break block3;
                        Debug.ex((Throwable)runtimeException);
                    }
                }
            }
            iThread.start();
        }

        public void run() {
            while (!this.shouldStop) {
                block3: {
                    try {
                        Thread.sleep(this.check_interval);
                    }
                    catch (InterruptedException interruptedException) {
                        if (!Debug.ex) break block3;
                        Debug.ex((Throwable)interruptedException);
                    }
                }
                this.OEAB();
            }
        }

        private void OEAB() {
            if (this.memory_manager.isLowMemory()) {
                this.this$0.onLowMemory();
            }
        }
    }
}

