/*
 * Decompiled with CFR 0.152.
 */
package ice.storm.print;

import ice.storm.StormPrinter;
import ice.storm.print.StormPageFormat;
import ice.util.unit.PointUnit;
import ice.util.unit.Unit;
import java.awt.Dimension;
import java.awt.Graphics;

public abstract class AbstractStormPrinter
implements StormPrinter {
    protected StormPageFormat pageFormat;
    protected int numberOfPages = 0;
    protected int currentPageIndex = -1;

    public AbstractStormPrinter() {
        this.pageFormat = new StormPageFormat();
    }

    public AbstractStormPrinter(StormPageFormat stormPageFormat) {
        this.pageFormat = stormPageFormat;
    }

    public void setStormPageFormat(StormPageFormat stormPageFormat) throws IllegalArgumentException {
        if (stormPageFormat == null) {
            throw new IllegalArgumentException();
        }
        if (!this.pageFormat.equals(stormPageFormat) || this.pageFormat.hasImageableAreaChanged()) {
            this.pageFormat = stormPageFormat;
            this.pageFormat.setImageableAreaChangedFlag(true);
            this.getPageCount();
        } else {
            this.pageFormat.setImageableAreaChangedFlag(false);
        }
    }

    public abstract int getZoom();

    public StormPageFormat getStormPageFormat() {
        return this.pageFormat;
    }

    public abstract int getPageCount();

    public abstract void dispose();

    public void printPage(Graphics graphics) {
        if (this.currentPageIndex < 0) {
            this.currentPageIndex = 0;
        }
        this.printPage(graphics, this.currentPageIndex);
    }

    public abstract void printPage(Graphics var1, int var2);

    public abstract void print(Graphics var1);

    public abstract Dimension getDimension();

    public boolean layoutNextPage() {
        boolean bl = false;
        ++this.currentPageIndex;
        if (this.currentPageIndex < this.numberOfPages) {
            bl = true;
        } else {
            --this.currentPageIndex;
            bl = false;
        }
        return bl;
    }

    public void setPageSize(int n, int n2) {
        this.pageFormat.setPageSize((Unit)new PointUnit((double)n), (Unit)new PointUnit((double)n2));
        this.getPageCount();
    }

    public void setPageIndex(int n) {
        this.currentPageIndex = n < 0 ? 0 : (n > this.numberOfPages - 1 ? this.numberOfPages - 1 : n);
    }

    public int getPageIndex() {
        if (this.currentPageIndex < 0) {
            return 0;
        }
        return this.currentPageIndex;
    }

    public abstract void setZoom(int var1);
}

