/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.widgets.desk.DTCloseTransaction;
import com.mathworks.widgets.desk.DTDocumentContainer;
import com.mathworks.widgets.desk.DTDocumentsFrame;
import com.mathworks.widgets.desk.DTInternalFrame;
import com.mathworks.widgets.desk.DTMultipleClientFrame;
import com.mathworks.widgets.desk.DTOccupant;
import com.mathworks.widgets.desk.Desktop;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;

class DTDocuments
extends DTOccupant {
    private DTDocumentContainer fDocumentContainer;
    private DropTargetListener fDropTargetListener;
    private Object fSavedDocumentState;

    DTDocuments(Desktop desktop, Object object) {
        super(desktop);
        this.fSavedDocumentState = object;
    }

    @Override
    public String getTitle() {
        return this.getDesktop().getString("title.Documents");
    }

    @Override
    public DTInternalFrame getInternalFrame() {
        return this.getDocumentsFrame();
    }

    DTDocumentsFrame getDocumentsFrame() {
        if (this.fInternalFrame == null) {
            this.fInternalFrame = new DTDocumentsFrame(this);
        }
        return (DTDocumentsFrame)this.fInternalFrame;
    }

    boolean hasDocumentContainer() {
        return this.fDocumentContainer != null;
    }

    DTDocumentContainer getDocumentContainer() {
        if (this.fDocumentContainer == null) {
            this.fDocumentContainer = this.fSavedDocumentState != null ? new DTDocumentContainer(this.fDesktop, this.fDesktop.getMainFrame(), null, this.fSavedDocumentState) : new DTDocumentContainer(this.fDesktop, this.fDesktop.getMainFrame(), null);
            if (this.fDropTargetListener != null) {
                this.fDocumentContainer.addDropTargetListener(this.fDropTargetListener);
            }
        }
        return this.fDocumentContainer;
    }

    public void addDropTargetListener(DropTargetListener dropTargetListener) {
        if (this.fDropTargetListener == null) {
            if (this.fDocumentContainer != null) {
                this.fDocumentContainer.addDropTargetListener(dropTargetListener);
            }
            this.fDropTargetListener = dropTargetListener;
        }
    }

    public void removeDropTargetListener(DropTargetListener dropTargetListener) {
        if (this.fDropTargetListener == dropTargetListener) {
            if (this.fDocumentContainer != null) {
                this.fDocumentContainer.removeDropTargetListener(dropTargetListener);
            }
            this.fDropTargetListener = null;
        }
    }

    @Override
    public boolean isSelected() {
        return this.fInternalFrame != null && this.fInternalFrame.isSelected();
    }

    @Override
    void setSelected(boolean bl, boolean bl2, boolean bl3) {
        this.fSelectionOrder = this.fDesktop.getSelectionManager().getNextSelectionOrder();
        if (this.fDocumentContainer != null) {
            this.fDocumentContainer.setSelected(bl, bl2);
        }
        if (this.fInternalFrame != null) {
            this.fInternalFrame.setSelected(bl);
        }
    }

    @Override
    void requestFocus() {
        if (this.fDocumentContainer != null) {
            this.fDocumentContainer.requestFocus();
        }
    }

    @Override
    public void close() {
        DTMultipleClientFrame dTMultipleClientFrame;
        if (this.fLocation != null && (dTMultipleClientFrame = (DTMultipleClientFrame)this.fLocation.getFrame()) != null) {
            dTMultipleClientFrame.removeDocuments(this);
        }
    }

    @Override
    protected DTOccupant.OccupantAction createOpenAction() {
        return null;
    }

    @Override
    protected DTOccupant.OccupantAction createCloseAction() {
        return new DocumentsCloseAction();
    }

    @Override
    protected DTOccupant.OccupantAction createDockAction() {
        return null;
    }

    @Override
    protected DTOccupant.OccupantAction createUndockAction() {
        return new DocumentsUndockAction();
    }

    @Override
    protected DTOccupant.OccupantAction createMinimizeAction() {
        return null;
    }

    @Override
    protected DTOccupant.OccupantAction createMaximizeAction() {
        return null;
    }

    @Override
    protected DTOccupant.OccupantAction createSelectAction() {
        return new DocumentsSelectAction();
    }

    @Override
    protected DTOccupant.OccupantAction createToggleAction() {
        return null;
    }

    class DocumentsSelectAction
    extends DTOccupant.SelectAction {
        public DocumentsSelectAction() {
            super(DTDocuments.this);
            this.setName("&9 " + DTDocuments.this.getDesktop().getString("title.Documents"));
            this.setAccelerator(KeyStroke.getKeyStroke(57, MENU_SHORTCUT_KEY_MASK));
            this.setComponentName("SelectDocuments");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTDocuments.this.getDocumentContainer().setSelected(true);
        }
    }

    class DocumentsUndockAction
    extends DTOccupant.UndockAction {
        public DocumentsUndockAction() {
            super(DTDocuments.this);
            this.setName(DTDocuments.this.getDesktop().getString("action.UndockAll"));
            this.setComponentName("UndockAll");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTDocuments.this.getDocumentContainer().undockAll();
            DTDocuments.this.close();
        }
    }

    class DocumentsCloseAction
    extends DTOccupant.CloseAction {
        public DocumentsCloseAction() {
            super(DTDocuments.this);
            this.setName(DTDocuments.this.getDesktop().getString("action.CloseDocuments"));
            this.setComponentName("CloseDocuments");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTCloseTransaction dTCloseTransaction = DTDocuments.this.getDocumentContainer().getCloseAllTransaction();
            dTCloseTransaction.setDoneListener(new DTCloseTransaction.DoneListener(){

                @Override
                public void closeTransactionDone(boolean bl) {
                    if (bl) {
                        DTDocuments.this.close();
                    }
                }
            });
            dTCloseTransaction.start();
        }
    }
}

