/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.widgets.desk.DTOrganizeLayoutsDialog;
import com.mathworks.widgets.desk.DTSaveLayoutDialog;
import com.mathworks.widgets.desk.Desktop;
import java.awt.Cursor;
import java.awt.event.ActionEvent;

public class DTLayoutActions {
    private DTLayoutActions() {
    }

    static class DeleteAction
    extends MJAbstractAction {
        private final Desktop fDesktop;
        private final String fLayoutName;

        DeleteAction(Desktop desktop, String string) {
            super(desktop.getString("button.Delete"));
            this.fDesktop = desktop;
            this.fLayoutName = string;
            this.setComponentName("DeleteLayout" + string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.fDesktop.getLayoutLibrary().removeUserLayout(this.fLayoutName);
        }
    }

    static class RestoreAction
    extends MJAbstractAction {
        private final Desktop fDesktop;
        private final int fLayoutIndex;
        private final String fReferenceName;

        RestoreAction(Desktop desktop, int n) {
            this.fDesktop = desktop;
            this.fLayoutIndex = this.fDesktop.getLayoutLibrary().isFactoryLayout(n) ? n : -1;
            this.fReferenceName = this.fDesktop.getLayoutLibrary().getLayoutReferenceName(n);
            this.setName(this.fDesktop.getLayoutLibrary().getLayoutDisplayName(n));
            this.setComponentName("RestoreLayout" + this.fReferenceName);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Cursor cursor = this.fDesktop.getMainFrame().getCursor();
            this.fDesktop.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            if (this.fLayoutIndex != -1) {
                this.fDesktop.restoreLayout(this.fLayoutIndex);
            } else {
                this.fDesktop.restoreLayout(this.fReferenceName);
            }
            this.fDesktop.getMainFrame().setCursor(cursor);
        }
    }

    static class OrganizeAction
    extends MJAbstractAction {
        private final Desktop fDesktop;

        OrganizeAction(Desktop desktop) {
            super(desktop.getString("menuitem.OrganizeLayouts"));
            this.fDesktop = desktop;
            this.setComponentName("OrganizeLayouts");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new DTOrganizeLayoutsDialog(this.fDesktop.getLayoutLibrary(), this.fDesktop, OrganizeAction.getFrame((ActionEvent)actionEvent)).setVisible(true);
        }
    }

    static class SaveAction
    extends MJAbstractAction {
        private final Desktop fDesktop;

        SaveAction(Desktop desktop) {
            super(desktop.getString("menuitem.SaveLayout"));
            this.fDesktop = desktop;
            this.setComponentName("SaveLayout");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new DTSaveLayoutDialog(this.fDesktop.getLayoutLibrary(), this.fDesktop, SaveAction.getFrame((ActionEvent)actionEvent)).show();
        }
    }
}

