/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.desktop.attr.Attribute;
import com.mathworks.desktop.attr.AttributeChangeEvent;
import com.mathworks.desktop.attr.AttributeChangeListener;
import com.mathworks.desktop.client.Client;
import com.mathworks.desktop.client.ClientCollection;
import com.mathworks.mwswing.MJMenuBar;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJStatusBar;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.toolstrip.Toolstrip;
import com.mathworks.toolstrip.ToolstripTab;
import com.mathworks.toolstrip.factory.TSFactory;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTBorderFactory;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTClientFrame;
import com.mathworks.widgets.desk.DTClientProperty;
import com.mathworks.widgets.desk.DTCloseTransaction;
import com.mathworks.widgets.desk.DTDesktopMenu;
import com.mathworks.widgets.desk.DTFloatingLocation;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTGroup;
import com.mathworks.widgets.desk.DTLocation;
import com.mathworks.widgets.desk.DTMenuBar;
import com.mathworks.widgets.desk.DTProperty;
import com.mathworks.widgets.desk.DTTitleButton;
import com.mathworks.widgets.desk.DTToolBarContainer;
import com.mathworks.widgets.desk.DTToolstripFactory;
import com.mathworks.widgets.desk.Desktop;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuBar;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class DTSingleClientFrame
extends DTFrame {
    protected DTClient fClient;
    private DTTitleButton fDockButton;
    private Box fDockButtonBox;
    private boolean fFocusRequestPending;
    private Border fSavedMenuBarBorder;
    private boolean fOtherClosingWhenThisOpened;
    protected int fToolstripUpdateDepth;
    private AttributeChangeListener fToolstripAttributeListener;

    public DTSingleClientFrame(Desktop desktop, String string) {
        super(desktop, string);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new LocalWindowListener());
        this.fOtherClosingWhenThisOpened = this.fDesktop != null && this.fDesktop.isAnyFrameClosing();
    }

    public DTSingleClientFrame() {
    }

    @Override
    public DTDesktopMenu getDesktopMenu() {
        if (this.fDesktopMenu == null && this.fClient != null) {
            this.fDesktopMenu = new DTDesktopMenu(this.fDesktop, this, this.fClient, null);
        }
        return this.fDesktopMenu;
    }

    private void addClientHelper(DTClient dTClient) {
        this.getContentPane().add((Component)((Object)dTClient.getInternalFrame()), "Center");
        dTClient.prepareToShow();
        dTClient.getInternalFrame().setTitleBarVisible(false);
        dTClient.getInternalFrame().setBorderVisible(false);
    }

    @Override
    public void addClientHidden(DTClient dTClient, DTLocation dTLocation) {
        if (this.fClient != null) {
            throw new IllegalStateException("Attempting to add a second client");
        }
        super.addClientHidden(dTClient, dTLocation);
        this.fClient = dTClient;
        this.setName(dTClient.getComponentName() + "Frame");
        DTFloatingLocation dTFloatingLocation = this.refineLocation(dTLocation);
        dTClient.setLocationHidden(dTFloatingLocation);
        this.addClientHelper(dTClient);
    }

    @Override
    public void addClient(DTClient dTClient, DTLocation dTLocation) {
        Object object;
        boolean bl = false;
        if (this.fClient == null) {
            super.addClient(dTClient, dTLocation);
            if (this.fClient != null) {
                throw new IllegalStateException("Attempting to add a second client");
            }
            this.fClient = dTClient;
            this.setName(dTClient.getComponentName() + "Frame");
        } else {
            bl = true;
        }
        assert (dTClient == this.fClient);
        DTFloatingLocation dTFloatingLocation = this.refineLocation(dTLocation);
        dTFloatingLocation.setFrame(this);
        dTClient.setLocation(dTFloatingLocation);
        if (!bl) {
            this.addClientHelper(dTClient);
        }
        final DTGroup dTGroup = dTClient.getGroup();
        Icon icon = dTClient.getIcon();
        Icon icon2 = dTClient.getSmallIcon();
        if (icon == null && dTGroup != null) {
            icon = dTGroup.getIcon();
            icon2 = dTGroup.getSmallIcon();
        }
        this.setIcon(icon);
        this.setSmallIcon(icon2);
        boolean bl2 = dTClient.isDockable() && (this.fDesktop.hasMainFrame() || dTGroup != null);
        this.fDockButtonBox = null;
        this.fDockButton = new DTTitleButton(0, dTClient.getName(), dTClient.getShortTitle());
        this.fDockButton.addActionListener((ActionListener)dTClient.getDockAction());
        this.fDockButtonBox = Box.createVerticalBox();
        this.fDockButtonBox.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 0));
        this.fDockButtonBox.add(Box.createVerticalGlue());
        this.fDockButtonBox.add((Component)((Object)this.fDockButton));
        this.fDockButtonBox.add(Box.createVerticalGlue());
        this.fDockButtonBox.setVisible(bl2);
        if (this.fDesktop.useToolstrip() && dTClient.getToolstripTabs().length > 0) {
            this.fToolstrip = this.fDesktop.getToolstripFactory().createToolstrip(this);
            object = dTGroup == null ? null : dTGroup.getLastSelectedToolstripTab();
            ToolstripTab[] toolstripTabArray = dTClient.getToolstripTabs();
            boolean bl3 = false;
            ArrayList arrayList = new ArrayList();
            for (ToolstripTab toolstripTab : toolstripTabArray) {
                this.fToolstrip.getModel().add((Client)toolstripTab);
                if (object == null) {
                    object = toolstripTab.getName();
                    bl3 = true;
                } else if (!bl3 && ((String)object).equals(toolstripTab.getName())) {
                    bl3 = true;
                }
                arrayList.addAll(TSFactory.getToolSetsFromTab((ToolstripTab)toolstripTab));
            }
            if (!bl3 && toolstripTabArray.length > 0) {
                object = toolstripTabArray[0].getName();
            }
            if (object != null) {
                this.fToolstrip.setCurrentTab((String)object);
            }
            this.addToolstrip(this.fToolstrip, this.fDesktop.createQuickAccessBar(this));
            this.fTargetingManager.inject(dTClient.getContextActions());
            this.fTargetingManager.setContextToolSets(arrayList);
            this.fToolstrip.addTabNeighbor((JComponent)this.fDockButtonBox, 4);
            this.fDockButton.setActive(true);
            if (dTGroup != null) {
                DTClient dTClient2 = this.fDesktop.getSelectionManager().getSelectedClient();
                boolean bl4 = dTClient2 != null && dTClient2 != dTClient && dTClient2.getGroup() == dTGroup && dTClient2.getLocation() != null && !dTClient2.getLocation().isDocked() ? dTClient2.getLocation().getFrame().isToolstripCollapsed() : (dTGroup.isShowing() ? dTGroup.getContainingFrame().isToolstripCollapsed() : dTGroup.getCollapseDocumentToolstrips());
                this.setToolstripCollapsed(bl4);
                this.fToolstripAttributeListener = new AttributeChangeListener(){

                    public void attributeChange(AttributeChangeEvent attributeChangeEvent) {
                        if (attributeChangeEvent.getAttribute() == Toolstrip.STATE) {
                            if (attributeChangeEvent.getNewValue() == Toolstrip.State.COLLAPSED) {
                                DTSingleClientFrame.this.fClient.getGroup().setCollapseDocumentToolstrips(true);
                            } else if (attributeChangeEvent.getNewValue() == Toolstrip.State.EXPANDED) {
                                DTSingleClientFrame.this.fClient.getGroup().setCollapseDocumentToolstrips(false);
                            }
                        } else if (attributeChangeEvent.getAttribute() == Toolstrip.SELECTED_TAB && DTSingleClientFrame.this.fToolstripUpdateDepth == 0) {
                            dTGroup.setLastSelectedToolstripTab(DTSingleClientFrame.this.fToolstrip.getCurrentTab());
                        }
                    }
                };
                this.fToolstrip.addAttributeChangeListener(this.fToolstripAttributeListener);
            }
        } else {
            if (this.fDesktopMenu != null) {
                this.fDesktopMenu.setClient(dTClient);
            }
            if (dTClient.isSingleton() && this.fDesktop.useToolstrip() && dTClient.getMenuBar() == null && dTClient.getToolBars().length == 0) {
                ((DTClientFrame)dTClient.getInternalFrame()).showUndockedControls();
            } else {
                object = null;
                if (dTClient.isMenuMergeEnabled()) {
                    object = this.createMenuBar(dTClient, null);
                } else {
                    object = dTClient.getMenuBar();
                    this.setMenuBarBorder((JMenuBar)object);
                }
                if (PlatformInfo.isMacintosh()) {
                    MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
                    mJPanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
                    mJPanel.add((Component)new JSeparator(1), "Center");
                    Box box = Box.createHorizontalBox();
                    box.add(this.fDockButtonBox);
                    box.add((Component)mJPanel);
                    this.fDockButtonBox = box;
                }
                if (!dTClient.isSingleton() && dTGroup != null) {
                    this.getToolBarContainer().setAllowRearrangement(dTGroup.allowToolBarRearrangement());
                }
                if (PlatformInfo.isMacintosh()) {
                    this.getToolBarContainer().addLeftCorner(this.fDockButtonBox);
                } else if (object == null) {
                    this.getToolBarContainer().addRightCorner(this.fDockButtonBox);
                } else {
                    this.setMenuBarNeighbor(this.fDockButtonBox);
                }
                this.setJMenuBar((JMenuBar)object);
            }
        }
        object = dTClient.getStatusBar();
        if (object == null) {
            this.setStatusBar(new MJStatusBar());
        } else if (object != DTClientProperty.NULL_STATUS_BAR) {
            this.setStatusBar((MJStatusBar)object);
        }
        this.setStatusBarVisible(dTClient.wasStatusBarVisible());
        this.setBounds(dTFloatingLocation.getFrameBounds());
        if (dTFloatingLocation.isMaximized()) {
            this.setExtendedState(6);
        } else if (dTFloatingLocation.isMinimized()) {
            this.setExtendedState(1);
        }
        if (this.fDesktop.hasMainFrame()) {
            this.addRootBinding(KeyStroke.getKeyStroke(68, 3), (Action)dTClient.getDockAction());
        }
    }

    private DTFloatingLocation refineLocation(DTLocation dTLocation) {
        boolean bl;
        DTFloatingLocation dTFloatingLocation;
        Rectangle rectangle = WindowUtils.getScreenBounds();
        DTFloatingLocation dTFloatingLocation2 = dTFloatingLocation = dTLocation instanceof DTFloatingLocation ? (DTFloatingLocation)dTLocation : null;
        if (dTFloatingLocation != null && dTFloatingLocation.isMaximized()) {
            dTFloatingLocation.setFrameBounds(dTFloatingLocation.getRestoreBounds());
        }
        boolean bl2 = this.fClient.maintainAspectRatio() && this.fClient.getLastDockedLocation() instanceof DTFloatingLocation;
        boolean bl3 = this.fClient.getLastLocation() != null && this.fClient.getLastLocation().isDocked() && dTFloatingLocation == this.fClient.getLastUndockedLocation();
        boolean bl4 = dTFloatingLocation != null && dTFloatingLocation.isSizeInitialized();
        boolean bl5 = bl = dTFloatingLocation != null && (dTFloatingLocation.isSizeInitialized() || dTFloatingLocation.hasNormalizedSize());
        if (!bl4) {
            Dimension dimension;
            Dimension dimension2 = dimension = this.fDesktop.useToolstrip() ? DTSingleClientFrame.getDefaultDocumentFrameSize(rectangle.getSize()) : new Dimension(3 * rectangle.width / 8, 3 * rectangle.height / 8);
            if (dTFloatingLocation == null) {
                dTFloatingLocation = new DTFloatingLocation(dimension.width, dimension.height, true);
            } else if (dTFloatingLocation.hasNormalizedSize()) {
                dTFloatingLocation.initializeSize(rectangle.getSize());
            } else {
                dTFloatingLocation.setFrameSize(dimension);
            }
        }
        if (!dTFloatingLocation.isLocationInitialized()) {
            if (dTFloatingLocation.hasNormalizedLocation()) {
                dTFloatingLocation.initializeLocation(WindowUtils.getScreenBounds());
            } else {
                dTFloatingLocation.setFrameLocation(DTSingleClientFrame.getCascadeLocation(dTFloatingLocation.getFrameSize()));
            }
        }
        if (bl2 && (bl3 || !bl)) {
            int n;
            int n2 = this.fClient.getLastDockedLocation().getFrameWidth();
            int n3 = this.fClient.getLastDockedLocation().getFrameHeight();
            int n4 = dTFloatingLocation.getFrameWidth();
            int n5 = dTFloatingLocation.getFrameHeight();
            int n6 = n2 * n5;
            if (n6 > (n = n3 * n4) + n3 + n4 || n > n6 + n2 + n5) {
                int n7 = (int)Math.sqrt(n4 * n5);
                int n8 = (int)Math.sqrt(n2 * n3);
                n4 = n7 * n2 / n8;
                n5 = n7 * n3 / n8;
                int n9 = rectangle.width - dTFloatingLocation.getFrameX() - 5;
                int n10 = rectangle.height - dTFloatingLocation.getFrameY() - 5;
                if (n4 > n9) {
                    n5 = n5 * n9 / n4;
                    n4 = n9;
                }
                if (n5 > n10) {
                    n4 = n4 * n10 / n5;
                    n5 = n10;
                }
            }
            dTFloatingLocation.setFrameSize(n4, n5);
        }
        if (this.fClient.getUndockedBounding() == DTProperty.Bounding.PARTIALLY_VISIBLE) {
            dTFloatingLocation.ensureVisible(WindowUtils.getVirtualScreenBounds());
            if (dTFloatingLocation.getFrameX() < 0 && PlatformInfo.isLinux()) {
                dTFloatingLocation.setFrameLocation(0, dTFloatingLocation.getFrameY());
            }
        }
        return dTFloatingLocation;
    }

    @Override
    public void removeClient(DTClient dTClient) {
        Component component;
        DTToolBarContainer dTToolBarContainer = this.getToolBarContainer();
        if (this.fToolstrip == null && dTToolBarContainer != null) {
            if (PlatformInfo.isMacintosh()) {
                dTToolBarContainer.removeLeftCorner(this.fDockButtonBox);
            } else {
                dTToolBarContainer.removeRightCorner(this.fDockButtonBox);
            }
        }
        if (this.fToolstripAttributeListener != null) {
            this.fToolstrip.removeAttributeChangeListener(this.fToolstripAttributeListener);
        }
        super.removeClient(dTClient);
        this.fClient.setLocation(null);
        if (dTClient.isSelected() && dTClient.isClosing()) {
            this.fDesktop.getSelectionManager().clearSelection();
        }
        if (dTClient.mayHaveHeavyContent() && (component = this.fDesktop.getSelectionManager().getComponentUnderMouse()) != null && SwingUtilities.windowForComponent(component) == this) {
            component.dispatchEvent(new MouseEvent(component, 505, System.currentTimeMillis(), 0, 0, 0, 1, false));
        }
        this.dispose();
        if (!dTClient.isClosing()) {
            this.setJMenuBar(null);
        }
        if (this.fDesktop.hasMainFrame()) {
            this.removeRootBinding(KeyStroke.getKeyStroke(68, 3), (Action)dTClient.getDockAction());
        }
        this.fClient = null;
    }

    DTClient getClient() {
        return this.fClient;
    }

    @Override
    public DTGroup getGroup() {
        return this.fClient == null ? null : this.fClient.getGroup();
    }

    @Override
    protected DTToolBarContainer getToolBarContainer() {
        if (this.usingToolstrip()) {
            return super.getToolBarContainer();
        }
        if (this.fClient != null) {
            return this.fClient.getInternalFrame().getToolBarContainer();
        }
        return null;
    }

    @Override
    protected DTFloatingLocation getLocationToUpdate() {
        if (this.fClient == null) {
            return null;
        }
        return this.fClient.getLastUndockedLocation();
    }

    private void setMenuBarBorder(JMenuBar jMenuBar) {
        if (jMenuBar != null && !(jMenuBar instanceof DTMenuBar)) {
            this.fSavedMenuBarBorder = jMenuBar.getBorder();
            jMenuBar.setBorder(DTBorderFactory.createMenuBarBorder());
        }
    }

    private void restoreMenuBarBorder(JMenuBar jMenuBar) {
        if (jMenuBar != null && !(jMenuBar instanceof DTMenuBar) && this.fSavedMenuBarBorder != null) {
            jMenuBar.setBorder(this.fSavedMenuBarBorder);
        }
        this.fSavedMenuBarBorder = null;
    }

    @Override
    public void setVisible(boolean bl) {
        if (this.fClient != null && !this.fClient.isSingleton()) {
            this.fDesktop.getWindowRegistry().setVisible(this.fClient, bl);
        }
        super.setVisible(bl);
    }

    @Override
    public void dispose() {
        if (this.fToolstrip == null && this.fQuickAccessBar != null) {
            this.setQuickAccessLocation(null);
            this.getToolBarContainer().setOfferToggles(true);
        }
        if (this.fClient != null) {
            ((DTClientFrame)this.fClient.getInternalFrame()).hideUndockedControls();
        }
        JMenuBar jMenuBar = this.getJMenuBar();
        super.dispose();
        this.restoreMenuBarBorder(jMenuBar);
    }

    @Override
    void saveState() {
        if (this.fClient != null) {
            if (!this.fClient.isSingleton()) {
                this.fClient.saveToolBarState();
            }
            this.fClient.saveStatusBarVisible(this.isStatusBarVisible());
        }
    }

    @Override
    protected void mainFrameCreated() {
        super.mainFrameCreated();
        this.fDockButtonBox.setVisible(true);
        this.addRootBinding(KeyStroke.getKeyStroke(68, 3), (Action)this.fClient.getDockAction());
    }

    @Override
    protected void mainFrameDestroyed() {
        super.mainFrameDestroyed();
        this.fDockButtonBox.setVisible(false);
        this.removeRootBinding(KeyStroke.getKeyStroke(68, 3), (Action)this.fClient.getDockAction());
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        DTClient dTClient = (DTClient)propertyChangeEvent.getSource();
        assert (dTClient == this.fClient);
        if (DTClientProperty.TITLE.toString().equals(propertyChangeEvent.getPropertyName())) {
            this.setTitle((String)propertyChangeEvent.getNewValue());
        } else if (DTClientProperty.SHORT_TITLE.toString().equals(propertyChangeEvent.getPropertyName())) {
            if (this.fDockButton != null) {
                this.fDockButton.setTargetShortTitle((String)propertyChangeEvent.getNewValue());
            }
        } else if (DTClientProperty.ICON.toString().equals(propertyChangeEvent.getPropertyName())) {
            this.setIcon((Icon)propertyChangeEvent.getNewValue());
            this.setSmallIcon(this.fClient.getSmallIcon());
        } else if (DTClientProperty.SMALL_ICON.toString().equals(propertyChangeEvent.getPropertyName())) {
            this.setSmallIcon((Icon)propertyChangeEvent.getNewValue());
        } else if (DTClientProperty.MENU_BAR.toString().equals(propertyChangeEvent.getPropertyName()) || DTClientProperty.DONT_MERGE_MENU.toString().equals(propertyChangeEvent.getPropertyName())) {
            this.initiateMenuBarUpdate();
        } else if (DTClientProperty.TOOL_BAR.toString().equals(propertyChangeEvent.getPropertyName())) {
            if (this.fDesktopMenu != null) {
                this.fDesktopMenu.refreshClient(this.fClient);
            }
        } else if (DTProperty.TOOLSTRIP_TABS.toString().equals(propertyChangeEvent.getPropertyName())) {
            this.updateToolstrip();
        } else if (DTClientProperty.STATUS_BAR.toString().equals(propertyChangeEvent.getPropertyName())) {
            this.setStatusBar((MJStatusBar)propertyChangeEvent.getNewValue());
        } else if (DTClientProperty.DOCKABLE.toString().equals(propertyChangeEvent.getPropertyName())) {
            boolean bl;
            if (this.fDesktopMenu != null) {
                this.fDesktopMenu.refreshClient(this.fClient);
            }
            boolean bl2 = bl = (Boolean)propertyChangeEvent.getNewValue() != false && (this.fDesktop != null && this.fDesktop.hasMainFrame() || this.fClient.getGroup() != null);
            if (this.fDockButton != null) {
                this.fDockButtonBox.setVisible(bl);
            }
        } else if ("Occupant Selected".equals(propertyChangeEvent.getPropertyName())) {
            if (((Boolean)propertyChangeEvent.getNewValue()).booleanValue() && !this.isActive()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (DTSingleClientFrame.this.fClient != null && DTSingleClientFrame.this.fClient.isSelected()) {
                            DTSingleClientFrame.this.toFront();
                        }
                    }
                });
            }
            if (((Boolean)propertyChangeEvent.getNewValue()).booleanValue() && this.fClient != null && this.fClient.getGroup() != null) {
                this.fClient.getGroup().setCollapseDocumentToolstrips(this.isToolstripCollapsed());
            }
        }
    }

    protected void updateToolstrip() {
        if (this.fToolstrip != null) {
            ClientCollection clientCollection;
            ++this.fToolstripUpdateDepth;
            this.updateToolstripTabs(this.fClient.getToolstripTabs());
            String string = this.fToolstrip.getCurrentTab();
            if (string.length() == 0 && (clientCollection = this.fToolstrip.getModel()).size() > 0) {
                ToolstripTab toolstripTab = (ToolstripTab)clientCollection.get(0);
                string = toolstripTab.getName();
                if (((Boolean)toolstripTab.getAttribute((Attribute)DTToolstripFactory.IS_GLOBAL_TAB)).booleanValue()) {
                    for (int i = 0; i < clientCollection.size(); ++i) {
                        toolstripTab = (ToolstripTab)clientCollection.get(i);
                        if (((Boolean)toolstripTab.getAttribute((Attribute)DTToolstripFactory.IS_GLOBAL_TAB)).booleanValue()) continue;
                        string = toolstripTab.getName();
                        break;
                    }
                }
            }
            if (string != null) {
                this.fToolstrip.setCurrentTab(string);
            }
            --this.fToolstripUpdateDepth;
            if (this.fToolstripUpdateDepth == 0) {
                this.saveTabSelectionInGroup();
            }
        }
    }

    protected void saveTabSelectionInGroup() {
        if (this.fClient != null && this.fClient.getGroup() != null) {
            this.fClient.getGroup().setLastSelectedToolstripTab(this.fToolstrip.getCurrentTab());
        }
    }

    @Override
    protected void updateMenuBar() {
        Object object;
        JMenuBar jMenuBar = this.getJMenuBar();
        this.restoreMenuBarBorder(jMenuBar);
        if (this.fClient == null) {
            return;
        }
        if (this.fClient.isMenuMergeEnabled()) {
            if (jMenuBar instanceof DTMenuBar) {
                ((MJMenuBar)jMenuBar).dispose();
            }
            object = this.createMenuBar(this.fClient, null);
        } else {
            object = this.fClient.getMenuBar();
            this.setMenuBarBorder((JMenuBar)object);
        }
        if (!(PlatformInfo.isMacintosh() || jMenuBar == object || jMenuBar != null && object != null || this.fDockButtonBox == null)) {
            if (object == null) {
                this.setMenuBarNeighbor(null);
                this.getToolBarContainer().addRightCorner(this.fDockButtonBox);
            } else {
                this.getToolBarContainer().removeRightCorner(this.fDockButtonBox);
                this.setMenuBarNeighbor(this.fDockButtonBox);
            }
        }
        this.setJMenuBar((JMenuBar)object);
        ((DTClientFrame)this.fClient.getInternalFrame()).hideUndockedControls();
        this.getRootPane().revalidate();
    }

    private class LocalWindowListener
    extends WindowAdapter {
        private LocalWindowListener() {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
            DTSingleClientFrame.this.fFocusRequestPending = true;
            if (DTSingleClientFrame.this.fDesktop != null && DTSingleClientFrame.this.fClient != null && (!DTSingleClientFrame.this.fCreatedDuringLayoutRestore || DTSingleClientFrame.this.fClient.isSelected())) {
                if (!DTSingleClientFrame.this.fCreatedDuringLayoutRestore) {
                    DTSingleClientFrame.this.fClient.getComponent().transferFocus();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (DTSingleClientFrame.this.isActive() && DTSingleClientFrame.this.fClient != null) {
                            DTSingleClientFrame.this.fClient.requestFocus(!DTSingleClientFrame.this.fCreatedDuringLayoutRestore);
                            DTSingleClientFrame.this.fFocusRequestPending = false;
                        }
                    }
                });
            }
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            DTSingleClientFrame.this.fIsClosing = false;
            if (DTSingleClientFrame.this.fDesktop != null && !DTSingleClientFrame.this.fDesktop.isRestoringLayout() && DTSingleClientFrame.this.fClient != null && !DTSingleClientFrame.this.fClient.isSelected()) {
                boolean bl;
                Window window = windowEvent.getOppositeWindow();
                boolean bl2 = bl = window instanceof JDialog && window.getOwner() == DTSingleClientFrame.this && DTSingleClientFrame.this.fDesktop.getSelectionManager().getSelectedClient() != null;
                if (!bl) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (DTSingleClientFrame.this.isActive() && DTSingleClientFrame.this.fClient != null) {
                                DTSingleClientFrame.this.fDesktop.getSelectionManager().selectClient(DTSingleClientFrame.this.fClient, DTSingleClientFrame.this.fFocusRequestPending);
                                DTSingleClientFrame.this.fFocusRequestPending = false;
                            }
                        }
                    });
                }
            }
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
            if (DTSingleClientFrame.this.fClient != null && DTSingleClientFrame.this.fClient.isSelected()) {
                DTSingleClientFrame.this.fClient.setSelected(false);
            }
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (DTSingleClientFrame.this.fClient != null && (DTSingleClientFrame.this.fOtherClosingWhenThisOpened || !DTSingleClientFrame.this.fDesktop.isAnyFrameClosing())) {
                if (!DTSingleClientFrame.this.fClient.permitUserClose()) {
                    DTSingleClientFrame.this.fDesktop.setClientDocked(DTSingleClientFrame.this.fClient, true);
                } else {
                    DTSingleClientFrame.this.fIsClosing = true;
                    DTCloseTransaction dTCloseTransaction = new DTCloseTransaction(Collections.singleton(DTSingleClientFrame.this.fClient));
                    dTCloseTransaction.setDoneListener(new DTCloseTransaction.DoneListener(){

                        @Override
                        public void closeTransactionDone(boolean bl) {
                            DTSingleClientFrame.this.fIsClosing = false;
                        }
                    });
                    dTCloseTransaction.start();
                }
            }
        }
    }
}

