/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.fonts;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.services.FontPrefs;
import com.mathworks.widgets.fonts.AutoCompletionFontPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

public final class FontDialog {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(AutoCompletionFontPanel.class.getPackage().getName() + ".resources.RES_Fonts");
    private static final String DEFAULT_TITLE = BUNDLE.getString("FontDialog.defaultTitle");
    private static final Font DEFAULT_FONT = FontPrefs.getTextFont();
    private boolean fApproved;
    private String fTitle;
    private Font fSelectedFont;

    public FontDialog() {
        this(DEFAULT_TITLE);
    }

    public FontDialog(String string) {
        this(string, DEFAULT_FONT);
    }

    public FontDialog(Font font) {
        this(DEFAULT_TITLE, font);
    }

    public FontDialog(String string, Font font) {
        this.fTitle = string;
        this.fSelectedFont = font;
    }

    public void setTitle(String string) {
        this.fTitle = string;
    }

    public void setSelectedFont(Font font) {
        this.fSelectedFont = font;
    }

    public Font getSelectedFont() {
        return this.fSelectedFont;
    }

    public Font showDialog(Component component) {
        Window window = component == null ? null : (component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component));
        MJDialog mJDialog = window instanceof Frame ? new MJDialog((Frame)window, this.fTitle, true) : (window instanceof Dialog ? new MJDialog((Dialog)window, this.fTitle, true) : new MJDialog((Frame)null, this.fTitle, true));
        this.initialize(mJDialog);
        mJDialog.show();
        return this.fApproved ? this.fSelectedFont : null;
    }

    private void initialize(final MJDialog mJDialog) {
        mJDialog.setResizable(false);
        mJDialog.setCloseOnEscapeEnabled(true);
        mJDialog.setName("FontDialog");
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("pref:grow", "pref, 10dlu, pref"));
        panelBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        final AutoCompletionFontPanel autoCompletionFontPanel = new AutoCompletionFontPanel(this.fSelectedFont);
        panelBuilder.add((Component)autoCompletionFontPanel.getComponent(), cellConstraints.xy(1, 1));
        MJButton mJButton = new MJButton((Action)new AbstractAction(BUNDLE.getString("FontDialog.ok")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontDialog.this.fSelectedFont = autoCompletionFontPanel.getSelectedFont();
                FontDialog.this.fApproved = true;
                mJDialog.dispose();
            }
        });
        mJButton.setName("OkButton");
        mJDialog.getRootPane().setDefaultButton((JButton)mJButton);
        MJButton mJButton2 = new MJButton((Action)new AbstractAction(BUNDLE.getString("FontDialog.cancel")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontDialog.this.fSelectedFont = null;
                mJDialog.dispose();
            }
        });
        mJButton2.setName("CancelButton");
        panelBuilder.add((Component)ButtonBarFactory.buildOKCancelBar((JButton)mJButton, (JButton)mJButton2), cellConstraints.xy(1, 3));
        mJDialog.setContentPane((Container)panelBuilder.getPanel());
        mJDialog.pack();
        mJDialog.setLocationRelativeTo((Component)mJDialog.getOwner());
    }
}

