/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet.data;

import com.mathworks.util.ArrayUtils;
import com.mathworks.widgets.spreadsheet.data.ComplexArray;
import com.mathworks.widgets.spreadsheet.data.ComplexScalarInteger;
import java.util.Arrays;

public final class ComplexArrayInteger
extends ComplexArray {
    private final int[][] fR;
    private final int[][] fI;

    public static ComplexArrayInteger valueOf(int[][] nArray) {
        return ComplexArrayInteger.valueOf(nArray, true);
    }

    public static ComplexArrayInteger valueOf(int[][] nArray, boolean bl) {
        if (nArray == null) {
            throw new IllegalArgumentException("null arrays are not permitted");
        }
        if (!ArrayUtils.isRectangular((Object)nArray)) {
            throw new IllegalArgumentException("Array argument must be rectangular.");
        }
        return new ComplexArrayInteger(nArray, bl);
    }

    public static ComplexArrayInteger valueOf(int[][] nArray, int[][] nArray2) {
        return ComplexArrayInteger.valueOf(nArray, nArray2, true);
    }

    public static ComplexArrayInteger valueOf(int[][] nArray, int[][] nArray2, boolean bl) {
        if (nArray == null || nArray2 == null) {
            throw new IllegalArgumentException("null arrays are not permitted");
        }
        if (!Arrays.equals(ArrayUtils.getLengths((int[][])nArray), ArrayUtils.getLengths((int[][])nArray2))) {
            throw new IllegalArgumentException("Real and imaginary array arguments must have the same size.");
        }
        return new ComplexArrayInteger(nArray, nArray2, bl);
    }

    private ComplexArrayInteger(int[][] nArray, boolean bl) {
        super(bl);
        this.fR = nArray;
        this.fI = null;
    }

    private ComplexArrayInteger(int[][] nArray, int[][] nArray2, boolean bl) {
        super(bl);
        this.fR = nArray;
        this.fI = nArray2;
    }

    public int[][] intValueReal() {
        return this.fR;
    }

    public int[][] intValueImaginary() {
        return this.fI;
    }

    @Override
    public boolean isReal() {
        return this.fI == null;
    }

    @Override
    public int[] getLengths() {
        return ArrayUtils.getLengths((int[][])this.fR);
    }

    @Override
    public ComplexScalarInteger getValueAt(int n, int n2) {
        if (this.isReal()) {
            return ComplexScalarInteger.valueOf(this.fR[n][n2], this.isSigned());
        }
        return ComplexScalarInteger.valueOf(this.fR[n][n2], this.fI[n][n2], this.isSigned());
    }
}

