/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.mathworks.matlab.api.editor.EditorLanguagePreferencesPanel;
import com.mathworks.matlab.api.editor.EditorSyntaxHighlighting;
import com.mathworks.matlab.api.editor.SyntaxHighlightingColor;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.services.ColorPrefs;
import com.mathworks.services.FontPrefs;
import com.mathworks.services.Prefs;
import com.mathworks.widgets.FileExtensionsPanel;
import com.mathworks.widgets.SyntaxTextPane;
import com.mathworks.widgets.color.ColorPicker;
import com.mathworks.widgets.text.EditorLanguageUtils;
import com.mathworks.widgets.text.EditorPreferences;
import com.mathworks.widgets.text.IndentingStyle;
import com.mathworks.widgets.text.MWKit;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.text.EditorKit;
import org.apache.commons.lang.Validate;

public abstract class AbstractEditorLanguagePanel
implements EditorLanguagePreferencesPanel {
    public static final String SYNTAX_HIGHLIGHTING_CHECKBOX_NAME = "SyntaxHighlightingCheckBox";
    public static final String PREVIEW_PANE_NAME = "PreviewPane";
    public static final String SMART_INDENTING_CHECKBOX_NAME = "SmartIndentCheckBox";
    private static final int MAX_COLOR_PICKERS_BEFORE_COMPACTING = 6;
    private static final int HGAP = 6;
    private static final int VGAP = 5;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com/mathworks/widgets/text/resources/RES_text");
    private FileExtensionsPanel fFileExtensions;
    private MJCheckBox fEnableSmartIndenting;
    private MJCheckBox fEnableSyntaxHighlighting;
    private SyntaxTextPane fPreviewPane;
    private Map<SyntaxHighlightingColor, ColorPicker> fColorsToPickers;
    private Component fAdditionalSyntaxHighlightingComponent;
    private Component fAdditionalSmartIndentingComponent;
    private Collection<JComponent> fAdditionalSections;
    private PreviewPaneCreationListener fPreviewPaneCreationListener;

    public final JComponent createPanel() {
        this.build();
        FormLayout formLayout = new FormLayout("fill:pref:grow, 1dlu, fill:pref:grow", "");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.append((Component)this.createSyntaxHighlightingPanel(), 3);
        if (this.fAdditionalSections != null) {
            for (JComponent jComponent : this.fAdditionalSections) {
                defaultFormBuilder.append((Component)jComponent, 3);
            }
        }
        if (EditorLanguageUtils.isSmartIndentingSupported(this.getLanguage())) {
            if (this.getSyntaxHighlighting().getColors().size() > 6) {
                defaultFormBuilder.appendRow(new RowSpec("fill:pref:grow"));
                defaultFormBuilder.append(this.createSmartIndentingPanel(), this.createFileExtensionsPanel());
            } else {
                defaultFormBuilder.append(this.createSmartIndentingPanel(), 3);
                defaultFormBuilder.append(this.createFileExtensionsPanel(), 3);
            }
        } else {
            defaultFormBuilder.append(this.createFileExtensionsPanel(), 3);
        }
        return defaultFormBuilder.getPanel();
    }

    public void commit() {
        this.commitSyntaxHighlighting();
        if (this.hasPreviewPaneAndColorPickers()) {
            this.commitColors();
        }
        this.commitSmartIndenting();
        this.commitFileExtensions();
        this.updatePreviewPaneForegroundBackground();
    }

    public void cleanup() {
        if (this.hasPreviewPaneAndColorPickers()) {
            this.fPreviewPane.cleanup();
        }
    }

    public void setSyntaxHighlightingComponent(Component component) {
        Validate.notNull((Object)component, (String)"'component' cannot be null");
        this.fAdditionalSyntaxHighlightingComponent = component;
    }

    public void setAdditionalSmartIndentingComponent(Component component) {
        Validate.notNull((Object)component, (String)"'component' cannot be null");
        if (!EditorLanguageUtils.isSmartIndentingSupported(this.getLanguage())) {
            throw new IllegalStateException("The language does not support smart indenting");
        }
        this.fAdditionalSmartIndentingComponent = component;
    }

    public void setAdditionalSections(Map<String, JComponent> map) {
        Validate.notNull(map, (String)"'sectionsByTitle' cannot be null");
        for (String string : map.keySet()) {
            JComponent jComponent = map.get(string);
            Validate.notNull((Object)jComponent, (String)"'component' cannot be null");
            Validate.notEmpty((String)string, (String)"'title' cannot be null or empty");
            jComponent.setBorder(BorderFactory.createTitledBorder(string));
        }
        this.fAdditionalSections = map.values();
    }

    protected abstract void build();

    protected abstract MWKit getModifiableKit();

    protected abstract EditorSyntaxHighlighting getSyntaxHighlighting();

    protected abstract String getSampleCode();

    protected void setPreviewPaneCreationListener(PreviewPaneCreationListener previewPaneCreationListener) {
        Validate.notNull((Object)previewPaneCreationListener, (String)"'listener' cannot be null");
        this.fPreviewPaneCreationListener = previewPaneCreationListener;
    }

    private JComponent createSyntaxHighlightingPanel() {
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(new FormLayout("fill:pref:grow", ""));
        defaultFormBuilder.setBorder((Border)BorderFactory.createTitledBorder(BUNDLE.getString("languagePanel.syntaxHighlightingPanelTitle")));
        this.fEnableSyntaxHighlighting = this.createSyntaxHighlightingCheckBox();
        defaultFormBuilder.append(this.createSyntaxHighlightingPanel(this.fEnableSyntaxHighlighting));
        if (this.getModifiableKit() != null) {
            defaultFormBuilder.append(this.createColorPanel(this.fEnableSyntaxHighlighting.isSelected()));
            this.fPreviewPane = this.createSyntaxTextPane();
            this.applyColorPickersToPreviewPane();
            this.fPreviewPane.setSyntaxHighlightingEnabled(this.getLanguage(), this.fEnableSyntaxHighlighting.isSelected());
            defaultFormBuilder.append(AbstractEditorLanguagePanel.createPaddedPanel(this.fPreviewPane));
        }
        return defaultFormBuilder.getPanel();
    }

    private static Component createPaddedPanel(JComponent jComponent) {
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        mJPanel.add(jComponent);
        mJPanel.setBorder(BorderFactory.createEmptyBorder(0, 6, 5, 6));
        return mJPanel;
    }

    private MJCheckBox createSyntaxHighlightingCheckBox() {
        final MJCheckBox mJCheckBox = new MJCheckBox(BUNDLE.getString("languagePanel.enableSyntaxHighlighting"), EditorPreferences.isSyntaxHighlightingEnabled(this.getSyntaxHighlighting()));
        mJCheckBox.setName(this.getInternalLanguageName() + SYNTAX_HIGHLIGHTING_CHECKBOX_NAME);
        mJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AbstractEditorLanguagePanel.this.hasPreviewPaneAndColorPickers()) {
                    boolean bl = mJCheckBox.isSelected();
                    for (ColorPicker colorPicker : AbstractEditorLanguagePanel.this.fColorsToPickers.values()) {
                        colorPicker.setEnabled(bl);
                    }
                    AbstractEditorLanguagePanel.this.fPreviewPane.setSyntaxHighlightingEnabled(AbstractEditorLanguagePanel.this.getLanguage(), bl);
                    if (bl) {
                        AbstractEditorLanguagePanel.this.applyColorPickersToPreviewPane();
                    }
                }
            }
        });
        return mJCheckBox;
    }

    private Component createSmartIndentingPanel() {
        this.fEnableSmartIndenting = new MJCheckBox(BUNDLE.getString("languagePanel.enableSmartIndent"));
        this.fEnableSmartIndenting.setName(this.getInternalLanguageName() + SMART_INDENTING_CHECKBOX_NAME);
        this.fEnableSmartIndenting.setSelected(IndentingStyle.SMART.equals((Object)EditorPreferences.getIndentingStyle(this.getLanguage())));
        MJPanel mJPanel = new MJPanel((LayoutManager)new FormLayout("pref", "pref, 3dlu, pref, 2dlu"));
        mJPanel.setBorder((Border)BorderFactory.createTitledBorder(BUNDLE.getString("languagePanel.indentingPanelTitle")));
        mJPanel.add((Component)this.fEnableSmartIndenting, (Object)new CellConstraints(1, 1));
        if (this.fAdditionalSmartIndentingComponent != null) {
            mJPanel.add(this.fAdditionalSmartIndentingComponent, (Object)new CellConstraints(1, 3));
        }
        return mJPanel;
    }

    private Component createFileExtensionsPanel() {
        this.fFileExtensions = new FileExtensionsPanel(this.getInternalLanguageName(), EditorPreferences.getFileExtensions(this.getLanguage()));
        return this.fFileExtensions.getComponent();
    }

    private Component createColorPanel(boolean bl) {
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(new FormLayout("fill:pref:grow, 10dlu, fill:pref:grow", "pref"));
        this.fColorsToPickers = new HashMap<SyntaxHighlightingColor, ColorPicker>();
        boolean bl2 = true;
        for (SyntaxHighlightingColor syntaxHighlightingColor : this.getSyntaxHighlighting().getColors()) {
            MJLabel mJLabel = new MJLabel(syntaxHighlightingColor.getDisplayName());
            ColorPicker colorPicker = this.createColorPicker(syntaxHighlightingColor, bl);
            this.fColorsToPickers.put(syntaxHighlightingColor, colorPicker);
            defaultFormBuilder.setLeadingColumnOffset(bl2 ? 0 : 2);
            defaultFormBuilder.append((Component)AbstractEditorLanguagePanel.createLabelAndPickerPanel((JLabel)mJLabel, colorPicker));
            if (!bl2) {
                defaultFormBuilder.setLeadingColumnOffset(0);
                defaultFormBuilder.appendRow(new RowSpec("3dlu"));
                defaultFormBuilder.nextLine();
                defaultFormBuilder.appendRow(new RowSpec("pref"));
                defaultFormBuilder.nextLine();
            }
            bl2 = !bl2;
        }
        return AbstractEditorLanguagePanel.createPaddedPanel(defaultFormBuilder.getPanel());
    }

    private static JComponent createLabelAndPickerPanel(JLabel jLabel, ColorPicker colorPicker) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(jLabel);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add((Component)((Object)colorPicker));
        return jPanel;
    }

    private ColorPicker createColorPicker(SyntaxHighlightingColor syntaxHighlightingColor, boolean bl) {
        assert (syntaxHighlightingColor != null) : "'color' cannot be null";
        ColorPicker colorPicker = new ColorPicker(ColorPicker.PickerIcon.NONE);
        colorPicker.setValue(syntaxHighlightingColor.getCurrentColor());
        colorPicker.setName(this.getInternalLanguageName() + syntaxHighlightingColor.getTokenName());
        colorPicker.getAccessibleContext().setAccessibleName(syntaxHighlightingColor.getDisplayName());
        colorPicker.setEnabled(bl);
        colorPicker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractEditorLanguagePanel.this.applyColorPickersToPreviewPane();
            }
        });
        return colorPicker;
    }

    private Component createSyntaxHighlightingPanel(MJCheckBox mJCheckBox) {
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("pref, fill:pref:grow, pref, 3dlu", "pref"));
        panelBuilder.add((Component)mJCheckBox, new CellConstraints().xy(1, 1));
        if (this.fAdditionalSyntaxHighlightingComponent != null) {
            panelBuilder.add(this.fAdditionalSyntaxHighlightingComponent, new CellConstraints().xy(3, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        }
        return panelBuilder.getPanel();
    }

    private void applyColorPickersToPreviewPane() {
        assert (this.hasPreviewPaneAndColorPickers()) : "updatePreviewPane shouldn't be called without a preview pane";
        for (SyntaxHighlightingColor syntaxHighlightingColor : this.fColorsToPickers.keySet()) {
            ColorPicker colorPicker = this.fColorsToPickers.get(syntaxHighlightingColor);
            this.fPreviewPane.setSyntaxColor(this.getSyntaxHighlighting(), syntaxHighlightingColor, (Color)colorPicker.getValue());
        }
    }

    private void commitColors() {
        for (SyntaxHighlightingColor syntaxHighlightingColor : this.fColorsToPickers.keySet()) {
            Color color = (Color)this.fColorsToPickers.get(syntaxHighlightingColor).getValue();
            Prefs.setColorPref((String)syntaxHighlightingColor.getPreferenceKey(), (Color)color);
        }
    }

    private void commitSyntaxHighlighting() {
        EditorPreferences.setSyntaxHighlightingEnabled(this.getSyntaxHighlighting(), this.fEnableSyntaxHighlighting.isSelected());
    }

    private void commitSmartIndenting() {
        if (this.fEnableSmartIndenting != null) {
            EditorPreferences.setIndentingStyle(this.getLanguage(), this.fEnableSmartIndenting.isSelected() ? IndentingStyle.SMART : IndentingStyle.NONE);
        }
    }

    private void commitFileExtensions() {
        EditorPreferences.setFileExtensions(this.getLanguage(), this.fFileExtensions.getExtensions());
    }

    private String getInternalLanguageName() {
        return this.getLanguage().getInternalName();
    }

    private boolean hasPreviewPaneAndColorPickers() {
        return this.fPreviewPane != null;
    }

    private void updatePreviewPaneForegroundBackground() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AbstractEditorLanguagePanel.this.hasPreviewPaneAndColorPickers()) {
                    AbstractEditorLanguagePanel.this.fPreviewPane.setBackgroundColor(ColorPrefs.getBackgroundColor(), false);
                    AbstractEditorLanguagePanel.this.fPreviewPane.setTextColor(ColorPrefs.getTextColor(), false);
                }
            }
        });
    }

    private SyntaxTextPane createSyntaxTextPane() {
        assert (this.getSampleCode() != null);
        assert (this.getModifiableKit() != null);
        Validate.isTrue((boolean)this.getModifiableKit().isModifiable(), (String)"getModifiableKit() must return a modifiable kit");
        SyntaxTextPane syntaxTextPane = new SyntaxTextPane();
        syntaxTextPane.setName(this.getInternalLanguageName() + PREVIEW_PANE_NAME);
        syntaxTextPane.setPreferredSize(new Dimension(125, 80));
        String string = BUNDLE.getString("languagePanel.acc.sampleCode");
        String string2 = MessageFormat.format(string, this.getLanguage().getName());
        syntaxTextPane.getAccessibleContext().setAccessibleName(string2);
        syntaxTextPane.registerEditorKit(this.getLanguage().getMimeType(), (EditorKit)((Object)this.getModifiableKit()));
        syntaxTextPane.setContentType(this.getLanguage().getMimeType());
        syntaxTextPane.setEditable(false);
        syntaxTextPane.setContextMenuEnabled(false, false);
        syntaxTextPane.setFont(FontPrefs.DEFAULT_CODE_FONT, false);
        syntaxTextPane.setText(this.getSampleCode());
        syntaxTextPane.setTextColor(ColorPrefs.getTextColor(), false);
        syntaxTextPane.setBackgroundColor(ColorPrefs.getBackgroundColor(), false);
        syntaxTextPane.setFocusable(false);
        syntaxTextPane.setHighlightCaretRow(false, false);
        syntaxTextPane.enableDelimiterMatchForArrows(false, false);
        if (this.fPreviewPaneCreationListener != null) {
            this.fPreviewPaneCreationListener.previewPaneCreated(syntaxTextPane);
        }
        return syntaxTextPane;
    }

    public static interface PreviewPaneCreationListener {
        public void previewPaneCreated(SyntaxTextPane var1);
    }
}

