/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.layer;

import com.mathworks.matlab.api.editor.EditorMessage;
import java.awt.Color;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.text.BadLocationException;
import org.apache.commons.lang.Validate;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;

public class DefaultEditorMessage
implements EditorMessage {
    private final int fStartPosition;
    private final Color fColor;
    private final String fMessage;
    private final int fEndPosition;
    private final int fLine;
    private boolean fStatic;
    private final BaseDocument fDocument;

    public DefaultEditorMessage(String string, int n, int n2, BaseDocument baseDocument, Color color, boolean bl) {
        Validate.notNull((Object)baseDocument, (String)"Input document cannot be null");
        Validate.notNull((Object)color, (String)"Input color cannot be null");
        Validate.isTrue((n2 <= baseDocument.getLength() ? 1 : 0) != 0, (String)"endPosition must be less than the document length");
        Validate.isTrue((n >= 0 && n <= n2 ? 1 : 0) != 0, (String)"startPosition must be non-negative and <= endPosition");
        try {
            this.fLine = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n);
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException(badLocationException);
        }
        this.fDocument = baseDocument;
        this.fMessage = string;
        this.fStartPosition = n;
        this.fEndPosition = n2;
        this.fColor = color;
        this.fStatic = bl;
    }

    public final int getStartPosition() {
        return this.fStartPosition;
    }

    public final Color getColor() {
        return this.fColor;
    }

    public boolean dismissOnCaretUpdate() {
        return true;
    }

    public final int getLineNumber() {
        return this.fLine;
    }

    public Icon getIcon(int n) {
        return null;
    }

    public boolean isActionable() {
        return false;
    }

    public boolean hasTooltipAction() {
        return false;
    }

    public Action getTooltipAction() {
        assert (false) : "should not be called because isActionable is false";
        return null;
    }

    public boolean hasExtendedInformation() {
        return false;
    }

    public boolean isTooltipActionVisible() {
        return false;
    }

    public boolean isExtendable() {
        return false;
    }

    public final String getMessage() {
        return this.fMessage;
    }

    public final int getEndPosition() {
        return this.fEndPosition;
    }

    public int getNumberOfLines() {
        try {
            return Utilities.getRowCount((BaseDocument)this.fDocument, (int)this.getStartPosition(), (int)this.getEndPosition());
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException(badLocationException);
        }
    }

    public String getExtendedInformation() {
        assert (false) : "should not be called because hasExtendedInformation is false";
        return null;
    }

    public boolean isStatic() {
        return this.fStatic;
    }
}

