/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.matlab;

import com.mathworks.util.Log;
import com.mathworks.widgets.text.matlab.MatlabTokenManager;
import com.mathworks.widgets.text.matlab.MatlabTokenUtils;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Finder;
import org.netbeans.editor.TextBatchProcessor;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.TokenProcessor;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtSyntaxSupport;

public final class MatlabSyntaxSupport
extends ExtSyntaxSupport {
    private final Map<Integer, int[]> fTokenForwardsMap = new HashMap<Integer, int[]>();
    private final Map<Integer, int[]> fTokenBackwardsMap = new HashMap<Integer, int[]>();
    private final MatlabTokenManager fManager;

    public MatlabSyntaxSupport(BaseDocument baseDocument, MatlabTokenManager matlabTokenManager) {
        super(baseDocument);
        if (matlabTokenManager == null) {
            throw new IllegalArgumentException("'manager' cannot be null");
        }
        this.fManager = matlabTokenManager;
    }

    public final TokenID getTokenID(int n) throws BadLocationException {
        int n2;
        ExtSyntaxSupport.FirstTokenTP firstTokenTP = new ExtSyntaxSupport.FirstTokenTP((ExtSyntaxSupport)this);
        int n3 = Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)n);
        int n4 = Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)this.getDocument().getLength());
        int n5 = n4 > n3 + (n2 = 5) ? Utilities.getRowStartFromLineOffset((BaseDocument)this.getDocument(), (int)(n3 + n2)) : this.getDocument().getLength();
        this.tokenizeText((TokenProcessor)firstTokenTP, n, n5, true);
        return firstTokenTP.getTokenID();
    }

    public final int[] findMatchingBlock(int n, boolean bl) throws BadLocationException {
        int[] nArray = this.findMatchingBracket(n, bl);
        if (nArray == null) {
            TokenID tokenID = MatlabTokenUtils.getTokenID(this.getDocument(), n);
            if (this.fManager.isStatementBlockEnd(tokenID)) {
                nArray = this.findMatchingKeywordPos(SearchType.STMT_START_FOR_END, n);
            } else if (this.fManager.isStatementBlockStart(tokenID)) {
                nArray = this.findMatchingKeywordPos(SearchType.END_FOR_STMT_START, n);
            } else if (this.fManager.isMidStatementStart(tokenID)) {
                nArray = this.findMatchingKeywordPos(SearchType.STMT_START_FOR_MID, n);
            }
        }
        return nArray;
    }

    private int[] findMatchingBracket(int n, boolean bl) throws BadLocationException {
        int[] nArray = null;
        final ExtSyntaxSupport.BracketFinder bracketFinder = this.getMatchingBracketFinder(this.getDocument().getChars(n, 1)[0]);
        if (bracketFinder != null) {
            if (bl) {
                nArray = bracketFinder.isForward() ? (this.fTokenForwardsMap.containsKey(n) ? this.fTokenForwardsMap.get(n) : MatlabSyntaxSupport.storeInfo(n, this.getDocument().find((Finder)bracketFinder, n, -1), this.fTokenForwardsMap)) : (this.fTokenBackwardsMap.containsKey(n) ? this.fTokenBackwardsMap.get(n) : MatlabSyntaxSupport.storeInfo(n, this.getDocument().find((Finder)bracketFinder, n + 1, 0), this.fTokenBackwardsMap));
            } else {
                TextBatchProcessor textBatchProcessor = new TextBatchProcessor(){

                    public int processTextBatch(BaseDocument baseDocument, int n, int n2, boolean bl) {
                        try {
                            int[] nArray = MatlabSyntaxSupport.this.getTokenBlocks(n, n2, MatlabSyntaxSupport.this.getBracketSkipTokens());
                            return MatlabSyntaxSupport.this.findOutsideBlocks((Finder)bracketFinder, n, n2, nArray);
                        }
                        catch (BadLocationException badLocationException) {
                            Log.logException((Exception)badLocationException);
                            return -1;
                        }
                    }
                };
                nArray = bracketFinder.isForward() ? (this.fTokenForwardsMap.containsKey(n) ? this.fTokenForwardsMap.get(n) : MatlabSyntaxSupport.storeInfo(n, this.getDocument().processText(textBatchProcessor, n, -1), this.fTokenForwardsMap)) : (this.fTokenBackwardsMap.containsKey(n) ? this.fTokenBackwardsMap.get(n) : MatlabSyntaxSupport.storeInfo(n, this.getDocument().processText(textBatchProcessor, n + 1, 0), this.fTokenBackwardsMap));
            }
        }
        return nArray;
    }

    private static int[] storeInfo(TokenItem tokenItem, TokenItem tokenItem2, Map<Integer, int[]> map) {
        assert (tokenItem != null);
        int[] nArray = null;
        if (tokenItem2 != null) {
            nArray = new int[]{tokenItem2.getOffset(), tokenItem2.getOffset() + tokenItem2.getImage().length()};
        }
        int n = tokenItem.getOffset();
        for (int i = 0; i < tokenItem.getImage().length(); ++i) {
            map.put(n + i, nArray);
        }
        return nArray;
    }

    private static int[] storeInfo(int n, int n2, Map<Integer, int[]> map) {
        int[] nArray;
        if (n2 != -1) {
            int[] nArray2 = new int[2];
            nArray2[0] = n2;
            nArray = nArray2;
            nArray2[1] = n2 + 1;
        } else {
            nArray = null;
        }
        int[] nArray3 = nArray;
        map.put(n, nArray3);
        return nArray3;
    }

    private int[] findMatchingKeywordPos(SearchType searchType, int n) throws BadLocationException {
        Map<Integer, int[]> map = this.getTokenMap(searchType == SearchType.END_FOR_STMT_START);
        if (map.containsKey(n)) {
            return map.get(n);
        }
        TokenItem tokenItem = MatlabTokenUtils.getToken(this.getDocument(), n);
        if (tokenItem == null) {
            Log.log((String)"Token at current position is null in findMathingKeywordPos");
            if (Log.isLogging()) {
                Thread.dumpStack();
            }
            return null;
        }
        TokenItem tokenItem2 = searchType == SearchType.STMT_START_FOR_END ? this.fManager.findStatementStartForEnd(tokenItem) : (searchType == SearchType.STMT_START_FOR_MID ? this.fManager.findStatementStartForMid(tokenItem) : this.fManager.findEndForStatementStart(tokenItem));
        return MatlabSyntaxSupport.storeInfo(tokenItem, tokenItem2, map);
    }

    public Map<Integer, int[]> getTokenMap(boolean bl) {
        return bl ? this.fTokenForwardsMap : this.fTokenBackwardsMap;
    }

    protected final void documentModified(DocumentEvent documentEvent) {
        super.documentModified(documentEvent);
        this.fTokenBackwardsMap.clear();
        this.fTokenForwardsMap.clear();
    }

    public final TokenID[] getBracketSkipTokens() {
        return this.fManager.getBracketSkipTokens();
    }

    private static enum SearchType {
        STMT_START_FOR_MID,
        STMT_START_FOR_END,
        END_FOR_STMT_START;

    }
}

