/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.mcode;

import com.mathworks.services.Prefs;
import com.mathworks.util.LanguageUtils;
import com.mathworks.util.Log;
import com.mathworks.widgets.text.mcode.MLintConfiguration;
import com.mathworks.widgets.text.mcode.MTree;
import com.mathworks.widgets.text.mcode.analyzer.CodeAnalyzerUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MLint {
    private static boolean sNativeLibraryExists;
    private static String sLastConfiguration;
    private static final Map<String, Boolean> DEFAULT_ENABLED_STATES;
    public static final int SEVERITY_THRESHOLD = 1;

    public static boolean nativeLibraryExists() {
        return sNativeLibraryExists;
    }

    public static List<Message> getMessages(String string, String string2) {
        return MLint.getMessages(string, string2, MLintConfiguration.createEmpty());
    }

    public static synchronized List<Message> getMessages(String string, String string2, MLintConfiguration mLintConfiguration) {
        return MLint.getMessages(string, string2, mLintConfiguration, false);
    }

    public static synchronized List<Message> getMessages(String string, String string2, MLintConfiguration mLintConfiguration, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("'buffer' cannot be null");
        }
        List<Message> list = Collections.emptyList();
        if (MLint.nativeLibraryExists()) {
            String string3 = mLintConfiguration.getMessagesAsString();
            if (!string3.equals(sLastConfiguration)) {
                MLint.nativeSetConfiguration(string3);
                sLastConfiguration = string3;
            }
            MLint.nativeSetOptionVal("eml", bl);
            if (string.length() > 0) {
                try {
                    list = MLint.nativeGetMessages(string, string2);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    Log.printLn((String)CodeAnalyzerUtils.getBundle().getString("mlint.msg.insufficientMemoryMessages"));
                }
            }
        }
        return list;
    }

    public static synchronized List<MessageDefinition> getMessageDefinitions() {
        return Collections.unmodifiableList(MLint.nativeGetMessageDefinitions());
    }

    public static MessageDefinition getMessageDefinition(String string) {
        for (MessageDefinition messageDefinition : MLint.getMessageDefinitions()) {
            if (!messageDefinition.getTag().equals(string)) continue;
            return messageDefinition;
        }
        return null;
    }

    public static synchronized List<Category> getCategories() {
        return Collections.unmodifiableList(MLint.nativeGetCategories());
    }

    public static synchronized MTree parse(String string) {
        return MLint.parse(string, false);
    }

    static synchronized MTree parse(String string, boolean bl) {
        MTree mTree;
        if (string == null || string.length() == 0) {
            mTree = new MTree(0, true);
        } else {
            try {
                mTree = MLint.nativeParse(string, bl);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Log.printLn((String)CodeAnalyzerUtils.getBundle().getString("mlint.msg.insufficientMemoryTree"));
                mTree = new MTree(0, false);
            }
        }
        return mTree;
    }

    private static native void nativeEnableJapaneseMessages();

    private static native void nativeSetConfiguration(String var0);

    private static native List<Message> nativeGetMessages(String var0, String var1);

    private static native List<MessageDefinition> nativeGetMessageDefinitions();

    private static native List<Category> nativeGetCategories();

    private static native MTree nativeParse(String var0, boolean var1);

    private MLint() {
    }

    private static native void nativeSetOption(String var0);

    private static native void nativeSetOptionVal(String var0, boolean var1);

    private static void setMyLintDirectory(String string) {
        MLint.nativeSetOption("xdir=" + string);
    }

    private static void setMyLintDirectoryToPrefdir() {
        MLint.setMyLintDirectory(Prefs.getPropertyDirectory());
    }

    static {
        DEFAULT_ENABLED_STATES = new HashMap<String, Boolean>();
        try {
            System.loadLibrary("nativemlint");
            sNativeLibraryExists = true;
            if (LanguageUtils.isJapanese()) {
                MLint.nativeEnableJapaneseMessages();
            }
            List<MessageDefinition> list = MLint.nativeGetMessageDefinitions();
            for (MessageDefinition messageDefinition : list) {
                DEFAULT_ENABLED_STATES.put(messageDefinition.getTag(), messageDefinition.fEnabledByDefault);
            }
            MLint.setMyLintDirectoryToPrefdir();
        }
        catch (Throwable throwable) {
            sNativeLibraryExists = false;
        }
    }

    public static final class Message {
        private final String fMessage;
        private final int fSeverity;
        private final String fTag;
        private int fLineNumber;
        private int fStartColumn;
        private int fEndColumn;
        private String fAutoFixMessage;
        private List<AutoFixChange> fAutoFixChanges;

        private Message(String string, String string2, int n, int n2, int n3, int n4) {
            this.fMessage = string;
            this.fTag = string2;
            this.fLineNumber = n;
            this.fStartColumn = n2;
            this.fEndColumn = n3;
            this.fSeverity = n4;
        }

        public String getTag() {
            return this.fTag;
        }

        public String getMessage() {
            return this.fMessage;
        }

        public int getLineNumber() {
            return this.fLineNumber;
        }

        public void setLineNumber(int n) {
            this.fLineNumber = n;
        }

        public int getStartColumn() {
            return this.fStartColumn;
        }

        public void setStartColumn(int n) {
            this.fStartColumn = n;
        }

        public int getEndColumn() {
            return this.fEndColumn;
        }

        public void setEndColumn(int n) {
            this.fEndColumn = n;
        }

        public int getSeverity() {
            return this.fSeverity;
        }

        private void setAutoFixMessage(String string) {
            this.fAutoFixMessage = string;
        }

        public String getAutoFixMessage() {
            return this.fAutoFixMessage;
        }

        public boolean hasAutoFix() {
            return this.fAutoFixMessage != null;
        }

        private void addAutoFixChange(AutoFixChange autoFixChange) {
            if (this.fAutoFixChanges == null) {
                this.fAutoFixChanges = new ArrayList<AutoFixChange>();
            }
            this.fAutoFixChanges.add(autoFixChange);
        }

        public List<AutoFixChange> getAutoFixChanges() {
            return Collections.unmodifiableList(this.fAutoFixChanges);
        }

        public String toString() {
            return this.fLineNumber + " (" + this.fStartColumn + ',' + this.fEndColumn + ") " + this.fMessage + " autoFix: " + this.fAutoFixMessage + " changes: " + this.fAutoFixChanges;
        }
    }

    public static final class AutoFixChange {
        private final int fStartLine;
        private final int fStartColumn;
        private final int fEndLine;
        private final int fEndColumn;
        private final String fText;

        private AutoFixChange(int n, int n2, int n3, int n4, String string) {
            this.fStartLine = n;
            this.fStartColumn = n2;
            this.fEndLine = n3;
            this.fEndColumn = n4;
            this.fText = string;
        }

        public int getStartLine() {
            return this.fStartLine;
        }

        public int getStartColumn() {
            return this.fStartColumn;
        }

        public int getEndLine() {
            return this.fEndLine;
        }

        public int getEndColumn() {
            return this.fEndColumn;
        }

        public String getText() {
            return this.fText;
        }

        public String toString() {
            return "[AutoFixChange L" + this.fStartLine + ", C" + this.fStartColumn + ", to L" + this.fEndLine + ", C" + this.fEndColumn + ", " + this.fText + "]";
        }
    }

    public static final class Category {
        private final String fName;
        private final String fTag;

        private Category(String string, String string2) {
            this.fName = string;
            this.fTag = string2;
        }

        public String getName() {
            return this.fName;
        }

        public String getTag() {
            return this.fTag;
        }

        public String toString() {
            return this.fName;
        }
    }

    public static final class MessageDefinition {
        private final String fMessage;
        private final String fTag;
        private final String fCategoryTag;
        private final boolean fEnabledByDefault;
        private final int fSeverity;

        private MessageDefinition(String string, String string2, String string3, boolean bl, int n) {
            assert (string != null) : "message is null";
            assert (string2 != null) : "tag is null";
            assert (string3 != null) : "category is null";
            this.fMessage = string;
            this.fCategoryTag = string3;
            this.fTag = string2;
            this.fEnabledByDefault = bl;
            this.fSeverity = n;
        }

        public String getMessage() {
            return this.fMessage;
        }

        public boolean isEnabledByDefault() {
            if (!DEFAULT_ENABLED_STATES.containsKey(this.fTag)) {
                DEFAULT_ENABLED_STATES.put(this.fTag, this.fEnabledByDefault);
            }
            return (Boolean)DEFAULT_ENABLED_STATES.get(this.fTag);
        }

        public String getTag() {
            return this.fTag;
        }

        public String getCategoryTag() {
            return this.fCategoryTag;
        }

        public int getSeverity() {
            return this.fSeverity;
        }

        public String toString() {
            return this.fMessage;
        }
    }
}

