/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.jmi.bean;

import com.mathworks.jmi.Support;
import com.mathworks.jmi.bean.BeanFileData;
import com.mathworks.jmi.bean.BeanFinalizeNotifier;
import com.mathworks.jmi.bean.BeanManager;
import com.mathworks.jmi.bean.BeanWrapper;
import com.mathworks.jmi.bean.EventCallback;
import com.mathworks.jmi.bean.EventInfo;
import com.mathworks.jmi.bean.EventServer;
import com.mathworks.jmi.bean.HGpropertyDescriptor;
import com.mathworks.jmi.bean.ListenerClassServer;
import com.mathworks.jmi.bean.MethodInfo;
import com.mathworks.jmi.bean.PropInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.beans.BeanInfo;
import java.beans.Beans;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import java.util.WeakHashMap;

public class MatlabBeanInterface {
    public static final int INVALID_CALLBACK = -1;
    private static Hashtable sBeanInstances = new Hashtable();
    private static WeakHashMap sBeanFinalizers = new WeakHashMap();
    private static Class sComponentClass;
    private static Class sContainerClass;
    private static Class sWindowClass;
    private static Class sObjectClass;
    private static MatlabBeanInterface classHolder;
    private BeanFileData fBeanFileData;
    private BeanInfo fBeanInfo;
    private String fDir;
    private String fName;
    private PropertyDescriptor[] fPropDescriptors;
    private EventSetDescriptor[] fEventDescriptors;
    private MethodDescriptor[] fMethodDescriptors;
    private HGpropertyDescriptor[] fHgPropDescriptors;
    private int fNumProps;
    private int fNumCallbacks;
    private int[] fCallbackOffsets;
    private Class[] fListenerClasses;
    private EventServer fEventServer;

    private MatlabBeanInterface() {
    }

    private void sortPropDescriptors(PropertyDescriptor[] propertyDescriptorArray) {
        Vector<PropertyDescriptor> vector = new Vector<PropertyDescriptor>();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray) {
            String string = (String)propertyDescriptor.getValue("BeanUtils.SortKey");
            boolean bl = false;
            if (string != null) {
                int n = vector.size();
                for (int i = 0; i < n; ++i) {
                    PropertyDescriptor propertyDescriptor2 = (PropertyDescriptor)vector.elementAt(i);
                    String string2 = (String)propertyDescriptor2.getValue("BeanUtils.SortKey");
                    if (string2 == null || string2.compareTo(string) <= 0) continue;
                    vector.insertElementAt(propertyDescriptor, i);
                    bl = true;
                    break;
                }
            }
            if (bl) continue;
            vector.addElement(propertyDescriptor);
        }
        int n = propertyDescriptorArray.length;
        for (int i = 0; i < n; ++i) {
            propertyDescriptorArray[i] = (PropertyDescriptor)vector.elementAt(i);
        }
    }

    public MatlabBeanInterface(String string, String string2) {
        this.fDir = string;
        this.fName = string2;
        this.fBeanFileData = BeanManager.lookupBean(string, string2);
        this.fBeanInfo = this.fBeanFileData.getBeanInfo();
        if (this.fBeanInfo != null) {
            this.fPropDescriptors = this.fBeanInfo.getPropertyDescriptors();
            this.sortPropDescriptors(this.fPropDescriptors);
            this.fNumProps = this.fPropDescriptors != null ? this.fPropDescriptors.length : 0;
            this.fEventDescriptors = this.fBeanInfo.getEventSetDescriptors();
            this.fMethodDescriptors = this.fBeanInfo.getMethodDescriptors();
            this.fHgPropDescriptors = new HGpropertyDescriptor[this.fNumProps];
            for (int i = 0; i < this.fNumProps; ++i) {
                if (this.fPropDescriptors[i] instanceof HGpropertyDescriptor) {
                    this.fHgPropDescriptors[i] = (HGpropertyDescriptor)this.fPropDescriptors[i];
                    continue;
                }
                try {
                    this.fHgPropDescriptors[i] = new HGpropertyDescriptor(this.fPropDescriptors[i].getName(), this.fPropDescriptors[i].getReadMethod(), this.fPropDescriptors[i].getWriteMethod());
                    if (this.fPropDescriptors[i].getWriteMethod() != null) {
                        this.fHgPropDescriptors[i].setAccess(995);
                    } else {
                        this.fHgPropDescriptors[i].setAccess(513);
                    }
                    if (!this.fPropDescriptors[i].isHidden()) continue;
                    this.fHgPropDescriptors[i].setType(5);
                    continue;
                }
                catch (IntrospectionException introspectionException) {
                    System.out.println("introspection exception in uic bean" + introspectionException.toString());
                }
            }
            this.makeListenerData();
            this.fEventServer = new EventServer(this);
        }
    }

    public Object makeBeanInstance(int n) {
        Object object = this.fBeanFileData.getInstance();
        this.addBeanInstance(object, n);
        return object;
    }

    public void addBeanInstance(Object object, int n) {
        BeanWrapper beanWrapper = (BeanWrapper)sBeanInstances.get(new Integer(n));
        if (beanWrapper == null) {
            beanWrapper = new BeanWrapper(object, this.fListenerClasses.length);
            sBeanInstances.put(new Integer(n), beanWrapper);
            sBeanFinalizers.put(object, new BeanFinalizeNotifier(n));
        }
    }

    public static Object getBeanInstance(int n) {
        BeanWrapper beanWrapper = (BeanWrapper)sBeanInstances.get(new Integer(n));
        Object object = null;
        if (beanWrapper != null) {
            object = beanWrapper.getBean();
        }
        return object;
    }

    public Class getBeanClass() {
        return this.fBeanInfo.getBeanDescriptor().getBeanClass();
    }

    private BeanWrapper getBeanWrapper(int n) {
        BeanWrapper beanWrapper = (BeanWrapper)sBeanInstances.get(new Integer(n));
        return beanWrapper;
    }

    public static int getBeanIndex(Object object) {
        int n = 0;
        BeanFinalizeNotifier beanFinalizeNotifier = (BeanFinalizeNotifier)sBeanFinalizers.get(object);
        if (beanFinalizeNotifier != null) {
            n = beanFinalizeNotifier.getIndex();
        }
        return n;
    }

    public void removeBeanInstance(int n, boolean bl, boolean bl2) {
        BeanWrapper beanWrapper = this.getBeanWrapper(n);
        if (beanWrapper != null && !bl2) {
            Object object;
            Object object2;
            for (int i = 0; i < this.fListenerClasses.length; ++i) {
                if (beanWrapper.getHandler(i) == null) continue;
                object2 = new Object[]{beanWrapper.getHandler(i)};
                object = this.fEventDescriptors[i].getRemoveListenerMethod();
                if (object == null) continue;
                try {
                    ((Method)object).invoke(beanWrapper.getBean(), (Object[])object2);
                    beanWrapper.setHandler(null, i);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            sBeanInstances.remove(new Integer(n));
            if (beanWrapper.getBean() != null) {
                sBeanFinalizers.remove(beanWrapper.getBean());
            }
            if (Support.useAWT() && bl && beanWrapper.getBean() != null) {
                Object object3 = Beans.getInstanceOf(beanWrapper.getBean(), sComponentClass);
                if (object3 instanceof Component) {
                    object2 = (Component)object3;
                    ((Component)object2).setVisible(false);
                    object = ((Component)object2).getParent();
                    if (object != null) {
                        ((Container)object).remove((Component)object2);
                    }
                }
                if ((object2 = Beans.getInstanceOf(beanWrapper.getBean(), sWindowClass)) instanceof Window) {
                    ((Window)object2).dispose();
                }
            }
        }
    }

    public boolean canChildParentRelationshipExist(Object object, Object object2) {
        boolean bl = false;
        if (object2 == null) {
            bl = true;
        } else if (Beans.isInstanceOf(object2, sContainerClass) && Beans.isInstanceOf(object, sComponentClass)) {
            bl = true;
        }
        return bl;
    }

    public void setBeanParent(Object object, Object object2) {
        Component component;
        Container container;
        Object object3;
        Object object4 = null;
        if (object2 != null) {
            object4 = Beans.getInstanceOf(object2, sContainerClass);
        }
        if ((object3 = Beans.getInstanceOf(object, sComponentClass)) instanceof Component && (container = (component = (Component)object3).getParent()) != object4) {
            if (container != null) {
                container.remove((Component)object3);
            }
            if (object4 != null && object4 instanceof Container) {
                Container container2 = (Container)object4;
                container2.add(component);
            }
        }
    }

    public int getNumberOfCallbacks() {
        return this.fNumCallbacks;
    }

    public int getCallbackIndex(int n, int n2) {
        int n3 = -1;
        if (n < this.fListenerClasses.length && n2 < this.fCallbackOffsets[n + 1] - this.fCallbackOffsets[n]) {
            n3 = this.fCallbackOffsets[n] + n2;
        }
        return n3;
    }

    public int getListenerIndex(int n) {
        int n2;
        if (n < 0) {
            n2 = -1;
        } else {
            for (n2 = 0; n2 < this.fListenerClasses.length && n >= this.fCallbackOffsets[n2 + 1]; ++n2) {
            }
            if (n2 >= this.fCallbackOffsets.length) {
                n2 = -1;
            }
        }
        return n2;
    }

    public void addCallback(int n, int n2, EventCallback eventCallback) {
        this.fEventServer.addCallback(n, n2, eventCallback);
        BeanWrapper beanWrapper = this.getBeanWrapper(n);
        int n3 = this.getListenerIndex(n2);
        if (beanWrapper.getHandler(n3) == null) {
            try {
                Class[] classArray = new Class[]{this.fEventServer.getClass(), sObjectClass, Integer.TYPE, Integer.TYPE};
                Constructor constructor = this.fListenerClasses[n3].getConstructor(classArray);
                Object[] objectArray = new Object[]{this.fEventServer, beanWrapper.getBean(), new Integer(n), new Integer(n3)};
                Object[] objectArray2 = new Object[]{constructor.newInstance(objectArray)};
                Method method = this.fEventDescriptors[n3].getAddListenerMethod();
                method.invoke(beanWrapper.getBean(), objectArray2);
                beanWrapper.setHandler(objectArray2[0], n3);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void removeCallback(int n, int n2) {
        if (n2 < this.fNumCallbacks) {
            this.fEventServer.removeCallback(n, n2);
        }
    }

    public PropInfo[] getPropInfos() {
        PropInfo[] propInfoArray = null;
        if (this.fNumProps > 0) {
            propInfoArray = new PropInfo[this.fNumProps];
            for (int i = 0; i < this.fNumProps; ++i) {
                propInfoArray[i] = new PropInfo(this.fPropDescriptors[i], this.fHgPropDescriptors[i]);
            }
        }
        return propInfoArray;
    }

    public EventInfo[] getEventInfos() {
        EventInfo[] eventInfoArray = new EventInfo[this.fNumCallbacks];
        int n = 0;
        if (this.fEventDescriptors != null) {
            for (int i = 0; i < this.fEventDescriptors.length; ++i) {
                Method[] methodArray = this.fEventDescriptors[i].getListenerType().getMethods();
                for (int j = 0; j < methodArray.length; ++j) {
                    eventInfoArray[n] = new EventInfo(methodArray[j]);
                    ++n;
                }
            }
        }
        return eventInfoArray;
    }

    public MethodInfo[] getMethodInfos() {
        MethodInfo[] methodInfoArray = null;
        if (this.fMethodDescriptors != null) {
            methodInfoArray = new MethodInfo[this.fMethodDescriptors.length];
            for (int i = 0; i < this.fMethodDescriptors.length; ++i) {
                methodInfoArray[i] = new MethodInfo(this.fMethodDescriptors[i]);
            }
        }
        return methodInfoArray;
    }

    private void makeListenerData() {
        this.fCallbackOffsets = new int[this.fEventDescriptors.length + 1];
        this.fListenerClasses = new Class[this.fEventDescriptors.length];
        this.fCallbackOffsets[0] = 0;
        this.fNumCallbacks = 0;
        for (int i = 0; i < this.fEventDescriptors.length; ++i) {
            Class<?> clazz = this.fEventDescriptors[i].getListenerType();
            this.fCallbackOffsets[i + 1] = this.fCallbackOffsets[i] + clazz.getMethods().length;
            this.fListenerClasses[i] = ListenerClassServer.getListenerClass(clazz);
            this.fNumCallbacks += clazz.getMethods().length;
        }
    }

    public static void main(String[] stringArray) {
        int n;
        String string = new String("d:\\Java\\BDK\\jars");
        String string2 = new String("FigureBean");
        MatlabBeanInterface matlabBeanInterface = new MatlabBeanInterface(string, string2);
        MatlabBeanInterface matlabBeanInterface2 = new MatlabBeanInterface(string, "sunw.demo.UIControl.UIControl");
        MatlabBeanInterface matlabBeanInterface3 = new MatlabBeanInterface(string, "hgPushButton");
        PropInfo[] propInfoArray = matlabBeanInterface2.getPropInfos();
        MethodInfo[] methodInfoArray = matlabBeanInterface2.getMethodInfos();
        matlabBeanInterface.makeBeanInstance(1);
        Object object = MatlabBeanInterface.getBeanInstance(1);
        ((Component)object).setVisible(true);
        for (int i = 0; i < 10; ++i) {
            for (n = 0; n < 10; ++n) {
                Object object2 = matlabBeanInterface3.makeBeanInstance(i * 10 + n + 3);
                matlabBeanInterface3.setBeanParent(object2, object);
            }
        }
        matlabBeanInterface2.makeBeanInstance(2);
        Object object3 = MatlabBeanInterface.getBeanInstance(2);
        ((Container)object).add((Component)object3);
        if (propInfoArray != null) {
            for (n = 0; n < propInfoArray.length; ++n) {
            }
        }
    }

    static {
        try {
            if (Support.useAWT()) {
                sComponentClass = Class.forName("java.awt.Component");
                sContainerClass = Class.forName("java.awt.Container");
                sWindowClass = Class.forName("java.awt.Window");
            }
            sObjectClass = Class.forName("java.lang.Object");
            classHolder = new MatlabBeanInterface();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

