/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.javabuilder.external.org.json;

import com.mathworks.toolbox.javabuilder.external.org.json.JSONArray;
import com.mathworks.toolbox.javabuilder.external.org.json.JSONException;
import com.mathworks.toolbox.javabuilder.external.org.json.JSONObject;
import com.mathworks.toolbox.javabuilder.external.org.json.XML;
import com.mathworks.toolbox.javabuilder.external.org.json.XMLTokener;
import java.util.Iterator;

public class JSONML {
    private static JSONArray parse(XMLTokener xMLTokener, JSONArray jSONArray) throws JSONException {
        while (true) {
            Object object;
            if ((object = xMLTokener.nextContent()) == XML.LT) {
                object = xMLTokener.nextToken();
                if (object instanceof Character) {
                    if (object == XML.BANG) {
                        char c = xMLTokener.next();
                        if (c == '-') {
                            if (xMLTokener.next() == '-') {
                                xMLTokener.skipPast("-->");
                            }
                            xMLTokener.back();
                            continue;
                        }
                        if (c == '[') {
                            object = xMLTokener.nextToken();
                            if (object.equals("CDATA") && xMLTokener.next() == '[') {
                                xMLTokener.nextCDATA();
                                continue;
                            }
                            throw xMLTokener.syntaxError("Expected 'CDATA['");
                        }
                        int n = 1;
                        do {
                            if ((object = xMLTokener.nextMeta()) == null) {
                                throw xMLTokener.syntaxError("Missing '>' after '<!'.");
                            }
                            if (object == XML.LT) {
                                ++n;
                                continue;
                            }
                            if (object != XML.GT) continue;
                            --n;
                        } while (n > 0);
                        continue;
                    }
                    if (object == XML.QUEST) {
                        xMLTokener.skipPast("?>");
                        continue;
                    }
                    if (object == XML.SLASH) {
                        object = xMLTokener.nextToken();
                        if (jSONArray == null) {
                            throw xMLTokener.syntaxError("Mismatched close tag '" + object + "'");
                        }
                        if (!object.equals(jSONArray.get(0))) {
                            throw xMLTokener.syntaxError("Mismatched '" + jSONArray.get(0) + "' and '" + object + "'");
                        }
                        if (xMLTokener.nextToken() != XML.GT) {
                            throw xMLTokener.syntaxError("Misshaped close tag");
                        }
                        return null;
                    }
                    throw xMLTokener.syntaxError("Misshaped tag");
                }
                JSONArray jSONArray2 = new JSONArray();
                JSONObject jSONObject = new JSONObject();
                if (jSONArray != null) {
                    jSONArray.put(jSONArray2);
                }
                jSONArray2.put(object);
                object = null;
                while (true) {
                    if (object == null) {
                        object = xMLTokener.nextToken();
                    }
                    if (object == null) {
                        throw xMLTokener.syntaxError("Misshaped tag");
                    }
                    if (!(object instanceof String)) break;
                    String string = (String)object;
                    object = xMLTokener.nextToken();
                    if (object == XML.EQ) {
                        object = xMLTokener.nextToken();
                        if (!(object instanceof String)) {
                            throw xMLTokener.syntaxError("Missing value");
                        }
                        jSONObject.accumulate(string, object);
                        object = null;
                        continue;
                    }
                    jSONObject.accumulate(string, "");
                }
                if (jSONObject.length() > 0) {
                    jSONArray2.put(jSONObject);
                }
                if (object == XML.SLASH) {
                    if (xMLTokener.nextToken() != XML.GT) {
                        throw xMLTokener.syntaxError("Misshaped tag");
                    }
                    if (jSONArray != null) continue;
                    return jSONArray2;
                }
                if (object == XML.GT) {
                    JSONML.parse(xMLTokener, jSONArray2);
                    if (jSONArray != null) continue;
                    return jSONArray2;
                }
                throw xMLTokener.syntaxError("Misshaped tag");
            }
            if (jSONArray == null) continue;
            jSONArray.put(object);
        }
    }

    public static JSONArray toJSONArray(String string) throws JSONException {
        return JSONML.toJSONArray(new XMLTokener(string));
    }

    public static JSONArray toJSONArray(XMLTokener xMLTokener) throws JSONException {
        return JSONML.parse(xMLTokener, null);
    }

    private static void stringify(JSONArray jSONArray, StringBuffer stringBuffer) throws JSONException {
        int n;
        Object object;
        stringBuffer.append('<');
        stringBuffer.append(jSONArray.get(0));
        Object object2 = jSONArray.opt(1);
        if (object2 instanceof JSONObject) {
            JSONObject jSONObject = (JSONObject)object2;
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                object = jSONObject.get(string).toString();
                stringBuffer.append(' ');
                stringBuffer.append(string);
                stringBuffer.append("=\"");
                stringBuffer.append(XML.escape((String)object));
                stringBuffer.append('\"');
            }
            n = 2;
        } else {
            n = 1;
        }
        int n2 = jSONArray.length();
        if (n >= n2) {
            stringBuffer.append("/>");
        } else {
            stringBuffer.append('>');
            while (n < n2) {
                object = jSONArray.get(n);
                if (object instanceof JSONArray) {
                    JSONML.stringify((JSONArray)object, stringBuffer);
                } else {
                    stringBuffer.append(XML.escape(object.toString()));
                }
                ++n;
            }
            stringBuffer.append("</");
            stringBuffer.append(jSONArray.get(0));
            stringBuffer.append('>');
        }
    }

    public static String toString(JSONArray jSONArray) throws JSONException {
        StringBuffer stringBuffer = new StringBuffer();
        JSONML.stringify(jSONArray, stringBuffer);
        return stringBuffer.toString();
    }
}

