/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin;

import com.mathworks.toolbox.coder.plugin.inputtypes.IDPChangeListener;
import com.mathworks.toolbox.coder.plugin.inputtypes.InputDataProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class EntryPoint {
    static final String FILE_NAME_TAG = "fileName";
    static final String FUNCTION_NAME_TAG = "functionName";
    private String fFileName;
    private String fFunctionName;
    private boolean fUsePreconditions;
    private Vector<InputDataProperty> fInputs = new Vector();

    public EntryPoint(String string, String string2) {
        this.fFileName = string;
        this.fFunctionName = string2;
        this.fUsePreconditions = false;
    }

    public List<String> getInputNames() {
        ArrayList<String> arrayList = new ArrayList<String>(this.fInputs.size());
        for (int i = 0; i < this.fInputs.size(); ++i) {
            arrayList.add(this.fInputs.elementAt(i).getName());
        }
        return arrayList;
    }

    public List<InputDataProperty> getInputDataProperties() {
        ArrayList<InputDataProperty> arrayList = new ArrayList<InputDataProperty>(this.fInputs.size());
        for (InputDataProperty inputDataProperty : this.fInputs) {
            arrayList.add(inputDataProperty);
        }
        return arrayList;
    }

    public InputDataProperty getInputDataProperty(Integer n) {
        return this.fInputs.elementAt(n);
    }

    public boolean hasInputs() {
        return !this.fInputs.isEmpty();
    }

    public boolean hasVarargin() {
        for (InputDataProperty inputDataProperty : this.fInputs) {
            if (!inputDataProperty.isVarargin()) continue;
            return true;
        }
        return false;
    }

    public void addInput(InputDataProperty inputDataProperty) {
        inputDataProperty.setEntryPoint(this);
        this.fInputs.add(inputDataProperty);
    }

    public void addInputs(List<InputDataProperty> list) {
        for (InputDataProperty inputDataProperty : list) {
            this.addInput(inputDataProperty);
        }
    }

    public void replaceInput(InputDataProperty inputDataProperty, InputDataProperty inputDataProperty2) {
        inputDataProperty.clearChangeListenerAndActiveDialog();
        inputDataProperty2.setEntryPoint(this);
        this.fInputs.setElementAt(inputDataProperty2, this.fInputs.indexOf(inputDataProperty));
    }

    public void replaceInputs(List<InputDataProperty> list, IDPChangeListener iDPChangeListener) {
        for (InputDataProperty inputDataProperty : this.fInputs) {
            inputDataProperty.clearChangeListenerAndActiveDialog();
        }
        this.fInputs.clear();
        for (InputDataProperty inputDataProperty : list) {
            inputDataProperty.setChangeListener(iDPChangeListener);
            this.addInput(inputDataProperty);
        }
    }

    public void putInput(InputDataProperty inputDataProperty) {
        for (int i = 0; i < this.fInputs.size(); ++i) {
            InputDataProperty inputDataProperty2 = this.fInputs.elementAt(i);
            if (!inputDataProperty.getName().equals(inputDataProperty2.getName())) continue;
            inputDataProperty2.clearChangeListenerAndActiveDialog();
            this.fInputs.setElementAt(inputDataProperty, i);
            return;
        }
        this.addInput(inputDataProperty);
    }

    public void reconcileInputs(List<InputDataProperty> list) {
        block0: for (InputDataProperty inputDataProperty : this.fInputs) {
            for (InputDataProperty inputDataProperty2 : list) {
                if (!inputDataProperty.getName().equals(inputDataProperty2.getName())) continue;
                this.replaceInput(inputDataProperty, inputDataProperty2);
                list.remove(inputDataProperty2);
                continue block0;
            }
        }
    }

    public String getFileName() {
        return this.fFileName;
    }

    public String getFunctionName() {
        return this.fFunctionName;
    }

    public boolean isUsePreconditions() {
        return this.fUsePreconditions;
    }

    public void setUsePreconditions(boolean bl) {
        this.fUsePreconditions = bl;
    }
}

