/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin.inputtypes;

import com.mathworks.jmi.MatlabLanguage;
import com.mathworks.project.impl.settingsui.validation.ValidationRule;
import com.mathworks.project.impl.table.AbstractSimpleCellEditor;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.inputtypes.InputDataProperty;
import java.awt.event.KeyEvent;

final class NameCellEditor
extends AbstractSimpleCellEditor<InputDataProperty> {
    private final InputDataProperty fProperty;

    public NameCellEditor(PropertyTable<InputDataProperty> propertyTable, InputDataProperty inputDataProperty) {
        super(propertyTable, new ValidationRule(){

            public String getErrorMessage(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() != '_' && !Character.isLetter(keyEvent.getKeyChar()) && !Character.isDigit(keyEvent.getKeyChar()) && keyEvent.getKeyChar() != '\b' && keyEvent.getKeyCode() != 127 && keyEvent.getKeyCode() != 37 && keyEvent.getKeyCode() != 39) {
                    return CoderResources.getString("typedef.error.invalidFieldName");
                }
                return null;
            }

            public String getErrorMessage(String string) {
                if (string.length() > 0 && !MatlabLanguage.isValidVariableName((String)string)) {
                    return CoderResources.getString("typedef.error.invalidFieldName");
                }
                return null;
            }
        });
        this.fProperty = inputDataProperty;
    }

    public void loadData(Object object, String string) {
        this.setData(object, string);
    }

    public void commitData() {
        String string = this.getData().toString();
        if (MatlabLanguage.isValidVariableName((String)string)) {
            this.fProperty.setName(string, true);
        }
    }
}

