/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.screener;

import com.mathworks.matlab.api.explorer.FileList;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.SearchCriteria;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.project.impl.util.Matlab;
import com.mathworks.toolbox.coder.CoderAPI;
import com.mathworks.util.AsyncReceiver;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Predicate;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class GenerateFunctionInfo {
    private GenerateFunctionInfo() {
    }

    public static void run() throws Exception {
        GenerateFunctionInfo.main(new String[0]);
    }

    public static void main(String[] stringArray) throws Exception {
        File file = Matlab.matlabRoot();
        File file2 = new File(file, "java/src/com/mathworks/toolbox/coder/screener/FunctionInfo.java");
        PrintWriter printWriter = new PrintWriter(new FileWriter(file2));
        printWriter.println("// Copyright 2012 The MathWorks. Inc.");
        printWriter.println();
        printWriter.println("package com.mathworks.toolbox.coder.screener;");
        printWriter.println();
        printWriter.println("import java.util.Set;");
        printWriter.println("import java.util.HashSet;");
        printWriter.println();
        printWriter.println("/** Generated by the GenerateFunctionInfo class */");
        printWriter.println("public final class FunctionInfo {");
        printWriter.println("    private static final Set<String> BUILTIN_NAMES = new HashSet<String>();");
        printWriter.println("    private static final Set<String> AUTO_EXTRINSIC_NAMES = new HashSet<String>();");
        printWriter.println("    private static final Set<String> FUNCTIONS_WITH_EML_IMPL = new HashSet<String>();");
        printWriter.println();
        printWriter.println("    static {");
        for (String string : CoderAPI.getBuiltinNames().split(",")) {
            printWriter.println("        BUILTIN_NAMES.add(\"" + string + "\");");
        }
        printWriter.println();
        for (String string : CoderAPI.getAutoExtrinsicNames().split(",")) {
            printWriter.println("        AUTO_EXTRINSIC_NAMES.add(\"" + string + "\");");
        }
        printWriter.println();
        for (String string : GenerateFunctionInfo.findFunctionsWithEmlImpl()) {
            printWriter.println("        FUNCTIONS_WITH_EML_IMPL.add(\"" + string + "\");");
        }
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    public static boolean isBuiltin(String name) {");
        printWriter.println("        return BUILTIN_NAMES.contains(name);");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    public static boolean isAutoExtrinsic(String name) {");
        printWriter.println("        return AUTO_EXTRINSIC_NAMES.contains(name);");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    public static boolean hasEmlImpl(String name) {");
        printWriter.println("        return FUNCTIONS_WITH_EML_IMPL.contains(name);");
        printWriter.println("    }");
        printWriter.println("}");
        printWriter.println();
        printWriter.close();
    }

    private static Set<String> findFunctionsWithEmlImpl() {
        final HashSet<String> hashSet = new HashSet<String>();
        File file = PlatformInfo.isWindows() ? new File("\\\\mathworks\\devel\\jobarchive\\Aeml\\latest_pass\\matlab") : new File("/mathworks/devel/jobarchive/Aeml/latest_pass/matlab");
        List<File> list = Arrays.asList(new File(file, "toolbox/aeroblks/eml"), new File(file, "toolbox/comm/comm/eml"), new File(file, "toolbox/dsp/dsp/eml"), new File(file, "toolbox/eml/lib"), new File(file, "toolbox/images/images/eml"), new File(file, "toolbox/signal/eml"), new File(file, "toolbox/vision/vision/eml"));
        for (File file2 : list) {
            try {
                FileList fileList = RealFileSystem.getInstance().search(new FileLocation(file2), new SearchCriteria("*.m"), (Predicate)new Predicate<FileSystemEntry>(){

                    public boolean accept(FileSystemEntry fileSystemEntry) {
                        return !fileSystemEntry.getName().equals("CVS");
                    }
                });
                fileList.readFilesAndFolders((AsyncReceiver)new AsyncReceiver<FileSystemEntry>(){

                    public boolean receive(FileSystemEntry fileSystemEntry) {
                        if (fileSystemEntry.getName().startsWith("eml_")) {
                            hashSet.add(fileSystemEntry.getName().substring(4, fileSystemEntry.getName().length() - 2));
                        } else {
                            hashSet.add(fileSystemEntry.getLocation().getNameBeforeDot());
                        }
                        return true;
                    }
                });
            }
            catch (IOException iOException) {}
        }
        return hashSet;
    }
}

