/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.screener;

import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.mlwidgets.explorer.util.FileSystemUtils;
import com.mathworks.toolbox.coder.screener.CallTreeImpactModel;
import com.mathworks.toolbox.coder.screener.DependencyFileSystem;
import com.mathworks.toolbox.coder.screener.FileImpactModel;
import com.mathworks.toolbox.coder.screener.MatlabFunctionSupport;
import com.mathworks.toolbox.coder.screener.ScreenerProblemType;
import com.mathworks.toolbox.coder.screener.ScreenerTarget;
import com.mathworks.util.AsyncReceiver;
import com.mathworks.util.Predicate;
import com.mathworks.util.tree.Tree;
import com.mathworks.widgets.text.matlab.MatlabTokenInfo;
import com.mathworks.widgets.text.mcode.MLexer;
import com.mathworks.widgets.text.mcode.MLint;
import com.mathworks.widgets.text.mcode.MTree;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;

public final class ImpactModelBuilder {
    private ImpactModelBuilder() {
    }

    public static CallTreeImpactModel buildImpactModel(List<File> list) {
        return ImpactModelBuilder.buildImpactModel(list, ScreenerTarget.C);
    }

    public static CallTreeImpactModel buildImpactModel(List<File> list, ScreenerTarget screenerTarget) {
        CallTreeImpactModel callTreeImpactModel = new CallTreeImpactModel(screenerTarget);
        try {
            for (File file : list) {
                DependencyFileSystem dependencyFileSystem = new DependencyFileSystem(RealFileSystem.getInstance().getEntry(new FileLocation(file)));
                ImpactModelBuilder.addDependenciesRecursively(screenerTarget, callTreeImpactModel, dependencyFileSystem, FileLocation.ROOT, null, null, null, new LinkedHashSet<String>(), new LinkedHashSet<FileLocation>());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return callTreeImpactModel;
    }

    private static void addDependenciesRecursively(final ScreenerTarget screenerTarget, final CallTreeImpactModel callTreeImpactModel, final DependencyFileSystem dependencyFileSystem, FileLocation fileLocation, String string, FileLocation fileLocation2, MTree.Node node, final Set<String> set, final Set<FileLocation> set2) {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final FileLocation fileLocation3 = dependencyFileSystem.getLocation(fileLocation);
        final File file = fileLocation3.toFile();
        if (string != null && !set.add(string)) {
            FileImpactModel fileImpactModel = callTreeImpactModel.getFileImpact(fileLocation2.toFile());
            fileImpactModel.add(ScreenerProblemType.RECURSION, Arrays.asList(node));
            return;
        }
        if (!set2.add(fileLocation3)) {
            return;
        }
        try {
            String string2 = FileSystemUtils.readText((FileSystemEntry)RealFileSystem.getInstance().getEntry(new FileLocation(file)));
            final MTree mTree = MTree.parse((String)string2, (boolean)true);
            HashSet<MTree.Node> hashSet = new HashSet<MTree.Node>();
            ExtrinsicMap extrinsicMap = new ExtrinsicMap();
            final Map<String, List<MTree.Node>> map = ImpactModelBuilder.findCallSites(string2, mTree, extrinsicMap, hashSet);
            List list = MLint.getMessages((String)string2, (String)file.getAbsolutePath());
            final FileImpactModel fileImpactModel = ImpactModelBuilder.buildFileImpactModel(screenerTarget, list, mTree, extrinsicMap, hashSet, string2);
            callTreeImpactModel.setFileImpact(file, fileImpactModel);
            DependencyFileSystem.DependencyFileList dependencyFileList = dependencyFileSystem.getList(fileLocation);
            dependencyFileList.readFunctions(new AsyncReceiver<DependencyFileSystem.Call>(){

                public boolean receive(DependencyFileSystem.Call call) {
                    String string = call.getFunctionName();
                    String string2 = call.getSourceFunctionName();
                    if (string2 != null && set.isEmpty()) {
                        set.add(string2);
                    }
                    FileSystemEntry fileSystemEntry = call.getEntry();
                    if (map.containsKey(string)) {
                        FileLocation fileLocation = dependencyFileSystem.getLocation(fileSystemEntry.getLocation());
                        callTreeImpactModel.addInvocation(file, fileLocation.toFile());
                        if (DependencyFileSystem.isInToolbox(fileLocation.toString())) {
                            if (!MatlabFunctionSupport.isSupported(fileLocation, string, callTreeImpactModel.getTarget()).booleanValue()) {
                                fileImpactModel.add(string, (List<MTree.Node>)((List)map.get(string)));
                            }
                        } else {
                            ImpactModelBuilder.addDependenciesRecursively(screenerTarget, callTreeImpactModel, dependencyFileSystem, fileSystemEntry.getLocation(), string, fileLocation3, mTree.getRoot(), new LinkedHashSet(set), new LinkedHashSet(set2));
                        }
                    }
                    return true;
                }

                public void finished() {
                    countDownLatch.countDown();
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException(interruptedException);
        }
    }

    private static MTree.Node findParent(MTree.Node node, MTree.NodeType nodeType) {
        if (node.getParent() != null && node.getParent().getType().equals((Object)nodeType) && !node.equals(node.getParent().getNext())) {
            return node.getParent();
        }
        if (node.getParent() != null && node.getParent() != MTree.NULL_NODE) {
            return ImpactModelBuilder.findParent(node.getParent(), nodeType);
        }
        return null;
    }

    private static boolean isNestedFunction(MTree.Node node) {
        MTree.Node node2 = ImpactModelBuilder.findParent(node, MTree.NodeType.FUNCTION);
        return node2 != null && !node.equals(node2.getNext());
    }

    private static FileImpactModel buildFileImpactModel(ScreenerTarget screenerTarget, List<MLint.Message> list, MTree mTree, ExtrinsicMap extrinsicMap, Set<MTree.Node> set, String string) {
        Object object;
        FileImpactModel fileImpactModel = new FileImpactModel(mTree);
        for (MLint.Message object22 : list) {
            if (object22.getSeverity() < 2) continue;
            object = ImpactModelBuilder.findNode(mTree, object22.getLineNumber(), object22.getStartColumn());
            fileImpactModel.add(ScreenerProblemType.SYNTAX_ERROR, Arrays.asList(object));
        }
        List list2 = mTree.findAsList(new MTree.NodeType[]{MTree.NodeType.FIELD});
        fileImpactModel.add(ScreenerProblemType.CELL_ARRAY, ImpactModelBuilder.filter(mTree.findAsList(new MTree.NodeType[]{MTree.NodeType.LEFT_CURLY_BRACE}), new Predicate<MTree.Node>(){

            public boolean accept(MTree.Node node) {
                return ImpactModelBuilder.findParent(node, MTree.NodeType.ATTRIBUTES) == null;
            }
        }), ImpactModelBuilder.filter(mTree.findAsList(new MTree.NodeType[]{MTree.NodeType.CELL}), new Predicate<MTree.Node>(){

            public boolean accept(MTree.Node node) {
                return !node.getLeft().isTextSupported() || !node.getLeft().getText().equals("varargin") && !node.getLeft().getText().equals("varargout");
            }
        }));
        if (screenerTarget == ScreenerTarget.HDL) {
            fileImpactModel.add(ScreenerProblemType.UNSUPPORTED_HDL_CONTROL_FLOW, mTree.findAsList(new MTree.NodeType[]{MTree.NodeType.WHILE}), ImpactModelBuilder.filter(mTree.findAsList(new MTree.NodeType[]{MTree.NodeType.BREAK, MTree.NodeType.CONTINUE, MTree.NodeType.RETURN}), new Predicate<MTree.Node>(){

                public boolean accept(MTree.Node node) {
                    return ImpactModelBuilder.findParent(node, MTree.NodeType.FOR) != null;
                }
            }));
        }
        fileImpactModel.add(ScreenerProblemType.FUNCTION_HANDLE, mTree.findAsList(new MTree.NodeType[]{MTree.NodeType.ANON}));
        fileImpactModel.add(ScreenerProblemType.TRY_CATCH, mTree.findAsList(new MTree.NodeType[]{MTree.NodeType.TRY}));
        List list3 = mTree.findAsList(new MTree.NodeType[]{MTree.NodeType.FUNCTION});
        object = mTree.findAsList(new MTree.NodeType[]{MTree.NodeType.CLASSDEF});
        if (list3.isEmpty() && object.isEmpty()) {
            if (!mTree.isEmpty() || !ImpactModelBuilder.hasFunctionOrClassDefToken(string)) {
                fileImpactModel.add(ScreenerProblemType.SCRIPT_INVOCATION, Arrays.asList(mTree.getRoot()));
            }
        } else {
            for (MTree.Node node : list3) {
                if (!ImpactModelBuilder.isNestedFunction(node)) continue;
                fileImpactModel.add(ScreenerProblemType.NESTED_FUNCTION, Arrays.asList(node));
            }
        }
        fileImpactModel.add(ScreenerProblemType.MISUSE_OF_EXTRINSIC, ImpactModelBuilder.filter(ImpactModelBuilder.findExtrinsicNodes(mTree, extrinsicMap), new Predicate<MTree.Node>(){

            public boolean accept(MTree.Node node) {
                return ImpactModelBuilder.findParent(node, MTree.NodeType.FOR) != null || ImpactModelBuilder.findParent(node, MTree.NodeType.WHILE) != null || ImpactModelBuilder.findParent(node, MTree.NodeType.IF) != null || ImpactModelBuilder.findParent(node, MTree.NodeType.PARFOR) != null || ImpactModelBuilder.findParent(node, MTree.NodeType.SWITCH) != null || ImpactModelBuilder.findParent(node, MTree.NodeType.ELSEIF) != null || ImpactModelBuilder.findParent(node, MTree.NodeType.ELSE) != null;
            }
        }));
        return fileImpactModel;
    }

    private static List<MTree.Node> findExtrinsicNodes(MTree mTree, ExtrinsicMap extrinsicMap) {
        LinkedList<MTree.Node> linkedList = new LinkedList<MTree.Node>();
        HashMap<Integer, MTree.Node> hashMap = new HashMap<Integer, MTree.Node>();
        for (MTree.Node node : mTree.findAsList(new MTree.NodeType[]{MTree.NodeType.FIELD})) {
            hashMap.put(node.getPosition(), node);
        }
        Iterator<Object> iterator = extrinsicMap.getPositions().iterator();
        while (iterator.hasNext()) {
            int n;
            int n2;
            for (n2 = n = ((Integer)iterator.next()).intValue(); n2 >= 0 && !hashMap.containsKey(n2); --n2) {
            }
            if (!hashMap.containsKey(n2)) continue;
            linkedList.add((MTree.Node)hashMap.get(n2));
        }
        return linkedList;
    }

    private static List<MTree.Node> filter(List<MTree.Node> list, Predicate<MTree.Node> predicate) {
        ArrayList<MTree.Node> arrayList = new ArrayList<MTree.Node>();
        for (MTree.Node node : list) {
            if (!predicate.accept((Object)node)) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    private static Map<String, List<MTree.Node>> findCallSites(String string, MTree mTree, ExtrinsicMap extrinsicMap, Set<MTree.Node> set) {
        if (ImpactModelBuilder.mightHaveExtrinsics(mTree)) {
            ImpactModelBuilder.findExtrinsics(string, extrinsicMap);
        }
        List<Call> list = ImpactModelBuilder.findCalls(mTree);
        HashMap<String, List<MTree.Node>> hashMap = new HashMap<String, List<MTree.Node>>();
        for (Call call : list) {
            String string2 = call.getName();
            MTree.Node node = call.getCallNode();
            if (extrinsicMap.isExtrinsic(string2) && !extrinsicMap.isExtrinsic(string2, node.getPosition())) {
                set.add(node);
            }
            if (string2.equals("end") || extrinsicMap.isExtrinsic(string2)) continue;
            LinkedList<MTree.Node> linkedList = (LinkedList<MTree.Node>)hashMap.get(string2);
            if (linkedList == null) {
                linkedList = new LinkedList<MTree.Node>();
                hashMap.put(string2, linkedList);
            }
            linkedList.add(node);
        }
        return hashMap;
    }

    private static boolean mightHaveExtrinsics(MTree mTree) {
        for (MTree.Node node : mTree.findAsList(new MTree.NodeType[]{MTree.NodeType.FIELD})) {
            MTree.Node node2 = node.getParent().getLeft();
            if (!node2.isTextSupported() || !node2.getText().equals("coder")) continue;
            return true;
        }
        return false;
    }

    private static boolean hasFunctionOrClassDefToken(String string) {
        char[] cArray = string.toCharArray();
        MatlabTokenInfo matlabTokenInfo = MLexer.getInstance().tokenizeLines(MLexer.getInstance().getInitialTokenizerState(), cArray, 0, cArray.length);
        for (int i = 0; i < matlabTokenInfo.getNumTokens(); ++i) {
            if (matlabTokenInfo.getToken(i) != 1 && matlabTokenInfo.getToken(i) != 25) continue;
            return true;
        }
        return false;
    }

    private static void findExtrinsics(String string, ExtrinsicMap extrinsicMap) {
        char[] cArray = string.toCharArray();
        MatlabTokenInfo matlabTokenInfo = MLexer.getInstance().tokenizeLines(MLexer.getInstance().getInitialTokenizerState(), cArray, 0, cArray.length);
        for (int i = 2; i < matlabTokenInfo.getNumTokens(); ++i) {
            int n = matlabTokenInfo.getToken(i);
            if (n != 40 || !ImpactModelBuilder.getToken(matlabTokenInfo, cArray, i).equals("extrinsic") || !ImpactModelBuilder.getToken(matlabTokenInfo, cArray, i - 1).equals(".") || !ImpactModelBuilder.getToken(matlabTokenInfo, cArray, i - 2).equals("coder")) continue;
            ++i;
            while (i < matlabTokenInfo.getNumTokens() && matlabTokenInfo.getToken(i) != 53) {
                if (matlabTokenInfo.getToken(i) == 44) {
                    String string2 = ImpactModelBuilder.getToken(matlabTokenInfo, cArray, i);
                    if (string2.startsWith("'")) {
                        string2 = string2.substring(1, string2.length() - 1);
                    }
                    extrinsicMap.declareExtrinsic(string2, matlabTokenInfo.getOffset(i));
                }
                ++i;
            }
        }
    }

    private static String getToken(MatlabTokenInfo matlabTokenInfo, char[] cArray, int n) {
        return new String(cArray, matlabTokenInfo.getOffset(n), matlabTokenInfo.getTokenLength(n));
    }

    private static MTree.Node findNode(MTree mTree, int n, int n2) {
        MTree.Node node = null;
        int n3 = 0;
        int n4 = Integer.MAX_VALUE;
        for (MTree.Node node2 : mTree) {
            if (Math.abs(node2.getStartLine() - n) >= Math.abs(n3 - n) || Math.abs(node2.getEndLine() - n) >= Math.abs(n4 - n)) continue;
            node = node2;
            n3 = node.getStartLine();
            n4 = node.getEndLine();
        }
        return node;
    }

    private static boolean isImplementation(FileLocation fileLocation, Set<String> set) {
        block0: for (String string : set) {
            if (string.contains(".")) {
                String[] stringArray = string.split("\\Q.\\E");
                for (int i = stringArray.length - 1; i >= 0; --i) {
                    String string2 = fileLocation.getNameBeforeDot();
                    if (string2.startsWith("+") || string2.startsWith("@")) {
                        string2 = string2.substring(1);
                    }
                    if (!string2.equals(stringArray[i])) continue block0;
                    fileLocation = fileLocation.getParent();
                }
                return true;
            }
            if (!fileLocation.getNameBeforeDot().equals(string)) continue;
            return true;
        }
        return false;
    }

    private static List<Call> findCalls(MTree mTree) {
        MTree.Node node2;
        ArrayList<Call> arrayList = new ArrayList<Call>();
        for (MTree.Node node2 : mTree.findAsList(new MTree.NodeType[]{MTree.NodeType.CALL})) {
            if (!node2.getLeft().isTextSupported()) continue;
            arrayList.add(new Call(node2.getLeft().getText(), node2));
        }
        Tree tree = mTree.findAsTree(new MTree.NodeType[]{MTree.NodeType.DOT, MTree.NodeType.ID, MTree.NodeType.FIELD});
        node2 = (MTree.Node)tree.getRoot();
        int n = tree.getChildCount((Object)node2);
        for (int i = 0; i < n; ++i) {
            MTree.Node node3 = (MTree.Node)tree.getChild((Object)node2, i);
            if (node3.getType() != MTree.NodeType.DOT) continue;
            arrayList.add(new Call(ImpactModelBuilder.assembleQualifiedName(node3), node3));
        }
        for (MTree.Node node3 : mTree.findAsList(new MTree.NodeType[]{MTree.NodeType.CEXPR})) {
            if (node3.getRight().getType() != MTree.NodeType.LT || node3.getRight().getRight() == MTree.NULL_NODE || !node3.getRight().getRight().isTextSupported() || node3.getRight().getRight().getText().equalsIgnoreCase("handle")) continue;
            arrayList.add(new Call(node3.getRight().getRight().getText(), node3.getRight().getRight()));
        }
        return arrayList;
    }

    public static String assembleQualifiedName(MTree.Node node) {
        if (node.getType() == MTree.NodeType.DOT) {
            StringBuilder stringBuilder = new StringBuilder(ImpactModelBuilder.assembleQualifiedName(node.getLeft()));
            if (stringBuilder.length() > 0) {
                stringBuilder.append('.');
            }
            stringBuilder.append(ImpactModelBuilder.assembleQualifiedName(node.getRight()));
            return stringBuilder.toString();
        }
        if (node.getType() == MTree.NodeType.ID && node.isTextSupported()) {
            return node.getText();
        }
        if (node.getType() == MTree.NodeType.FIELD && node.isTextSupported()) {
            return node.getText();
        }
        return "";
    }

    private static final class Call {
        private final String fName;
        private final MTree.Node fCallNode;

        Call(String string, MTree.Node node) {
            this.fName = string;
            this.fCallNode = node;
        }

        public String getName() {
            return this.fName;
        }

        public MTree.Node getCallNode() {
            return this.fCallNode;
        }
    }

    private static class ExtrinsicMap {
        private final Map<String, Integer> fExtrinsicPosition = new HashMap<String, Integer>();

        ExtrinsicMap() {
        }

        public boolean isExtrinsic(String string) {
            return this.fExtrinsicPosition.containsKey(string);
        }

        public boolean isExtrinsic(String string, int n) {
            return this.isExtrinsic(string) && this.fExtrinsicPosition.get(string) <= n;
        }

        public void declareExtrinsic(String string, int n) {
            this.fExtrinsicPosition.put(string, n);
        }

        public List<Integer> getPositions() {
            return new ArrayList<Integer>(this.fExtrinsicPosition.values());
        }
    }
}

