/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.screener;

import com.mathworks.jmi.Matlab;
import com.mathworks.matlab.api.explorer.FileList;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.SearchCriteria;
import com.mathworks.mlwidgets.explorer.model.MatlabPathModel;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.mlwidgets.explorer.model.table.UiFileList;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.FileSetInstance;
import com.mathworks.toolbox.coder.screener.DependencyFileSystem;
import com.mathworks.toolbox.coder.screener.ScreenerReportModel;
import com.mathworks.toolbox.coder.screener.ScreenerTarget;
import com.mathworks.util.AsyncReceiver;
import com.mathworks.util.MulticastChangeListener;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.Predicate;
import com.mathworks.util.RequestQueue;
import com.mathworks.widgets.grouptable.ExpansionChangeListener;
import com.mathworks.widgets.grouptable.GroupingTableTransaction;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class ProjectScreenerModel {
    private final Configuration fConfiguration;
    private final FileSetInstance fEntryPoints;
    private final PropertyChangeListener fFileSetListener;
    private final PropertyChangeListener fPathListener;
    private final PropertyChangeListener fConfigurationListener;
    private final Map<FileLocation, UiFileList> fLists;
    private final MulticastChangeListener fChangeListeners;
    private final RequestQueue fRequestQueue;
    private volatile List<File> fFiles;
    private volatile boolean fInvisibleEntryPoint;
    private ScreenerReportModel fReportModel;

    public ProjectScreenerModel(Configuration configuration) {
        this.fConfiguration = configuration;
        this.fEntryPoints = this.fConfiguration.getFileSet("fileset.entrypoints");
        this.fRequestQueue = new RequestQueue("Request queue for code generation screener");
        this.fChangeListeners = new MulticastChangeListener();
        this.fFiles = new ArrayList<File>(0);
        this.fFileSetListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ProjectScreenerModel.this.updateLists();
                ProjectScreenerModel.this.updateReport();
            }
        };
        this.fConfigurationListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("param.artifact")) {
                    ProjectScreenerModel.this.updateLists();
                    ProjectScreenerModel.this.updateReport();
                }
            }
        };
        this.fLists = new HashMap<FileLocation, UiFileList>();
        this.fEntryPoints.addPropertyChangeListener(this.fFileSetListener);
        if (!this.fEntryPoints.getFiles().isEmpty()) {
            this.updateLists();
            this.updateReport();
        }
        this.fPathListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ProjectScreenerModel.this.updateReport();
            }
        };
        MatlabPathModel.getInstance().addPropertyChangeListener(this.fPathListener);
        this.fConfiguration.addPropertyChangeListener(this.fConfigurationListener);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.removeChangeListener(changeListener);
    }

    public ScreenerReportModel getReportModel() {
        return this.fReportModel;
    }

    public boolean hasInvisibleEntryPoint() {
        return this.fInvisibleEntryPoint;
    }

    private void updateLists() {
        this.findAllFiles(new ParameterRunnable<List<File>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(List<File> list) {
                Map map = ProjectScreenerModel.this.fLists;
                synchronized (map) {
                    ArrayList<FileLocation> arrayList = new ArrayList<FileLocation>();
                    for (File object : list) {
                        FileLocation fileLocation = new FileLocation(object.getParentFile());
                        if (DependencyFileSystem.isInToolbox(fileLocation.toString())) continue;
                        arrayList.add(fileLocation);
                        if (ProjectScreenerModel.this.fLists.containsKey(fileLocation)) continue;
                        try {
                            UiFileList uiFileList = new UiFileList(ProjectScreenerModel.this.fRequestQueue, RealFileSystem.getInstance().getList(fileLocation), true);
                            uiFileList.addListener((ExpansionChangeListener)new ExpansionChangeListener<FileSystemEntry>(){

                                public void childrenChanged(GroupingTableTransaction<FileSystemEntry> groupingTableTransaction) {
                                    ProjectScreenerModel.this.updateLists();
                                    ProjectScreenerModel.this.updateReport();
                                }

                                public void hasChildrenChanged() {
                                    ProjectScreenerModel.this.updateLists();
                                    ProjectScreenerModel.this.updateReport();
                                }
                            });
                            ProjectScreenerModel.this.fLists.put(fileLocation, uiFileList);
                        }
                        catch (IOException iOException) {}
                    }
                    Iterator<Object> iterator = ProjectScreenerModel.this.fLists.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        if (arrayList.contains(entry.getKey())) continue;
                        ((UiFileList)entry.getValue()).close();
                        iterator.remove();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map<FileLocation, UiFileList> map = this.fLists;
        synchronized (map) {
            for (UiFileList uiFileList : this.fLists.values()) {
                uiFileList.close();
            }
            this.fLists.clear();
            this.fConfiguration.removePropertyChangeListener(this.fConfigurationListener);
            MatlabPathModel.getInstance().removePropertyChangeListener(this.fPathListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findAllFiles(ParameterRunnable<List<File>> parameterRunnable) {
        final ArrayList<File> arrayList = new ArrayList<File>();
        if (this.fEntryPoints.getCurrentCount() == 0) {
            this.fFiles = new ArrayList<File>(0);
            parameterRunnable.run(this.fFiles);
            return;
        }
        for (File file : this.fEntryPoints.getFiles()) {
            Object object = arrayList;
            synchronized (object) {
                arrayList.add(file);
            }
            try {
                object = new DependencyFileSystem(RealFileSystem.getInstance().getEntry(new FileLocation(file)));
                FileList fileList = ((DependencyFileSystem)object).search(FileLocation.ROOT, new SearchCriteria("*"), new Predicate<FileSystemEntry>(){

                    public boolean accept(FileSystemEntry fileSystemEntry) {
                        return true;
                    }
                });
                fileList.readFilesAndFolders((AsyncReceiver)new AsyncReceiver<FileSystemEntry>((DependencyFileSystem)object, parameterRunnable){
                    final /* synthetic */ DependencyFileSystem val$dependencies;
                    final /* synthetic */ ParameterRunnable val$output;
                    {
                        this.val$dependencies = dependencyFileSystem;
                        this.val$output = parameterRunnable;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public boolean receive(FileSystemEntry fileSystemEntry) {
                        if (!DependencyFileSystem.isInToolbox(fileSystemEntry.getLocation().toString())) {
                            List list = arrayList;
                            synchronized (list) {
                                arrayList.add(this.val$dependencies.getLocation(fileSystemEntry.getLocation()).toFile());
                            }
                        }
                        return true;
                    }

                    public void finished() {
                        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                List list = arrayList;
                                synchronized (list) {
                                    ProjectScreenerModel.this.fFiles = new ArrayList(arrayList);
                                    val$output.run((Object)ProjectScreenerModel.this.fFiles);
                                }
                            }
                        });
                    }
                });
            }
            catch (IOException iOException) {}
        }
    }

    public void updateReportAndRun(Runnable runnable) {
        this.updateReport(runnable);
    }

    public void updateReport() {
        this.updateReport(null);
    }

    private void updateReport(final Runnable runnable) {
        Matlab.whenAtPrompt((Runnable)new Runnable(){

            @Override
            public void run() {
                ProjectScreenerModel.this.fInvisibleEntryPoint = false;
                for (File file : ProjectScreenerModel.this.fEntryPoints.getFiles()) {
                    try {
                        Object object = Matlab.mtFeval((String)"which", (Object[])new Object[]{file.getAbsolutePath()}, (int)1);
                        if (object != null && !object.toString().isEmpty()) continue;
                        ProjectScreenerModel.this.fInvisibleEntryPoint = true;
                    }
                    catch (Exception exception) {
                        ProjectScreenerModel.this.fInvisibleEntryPoint = true;
                    }
                    break;
                }
                ProjectScreenerModel.this.fRequestQueue.request(new Runnable(){

                    @Override
                    public void run() {
                        if (ProjectScreenerModel.this.fInvisibleEntryPoint) {
                            ProjectScreenerModel.this.fReportModel = null;
                        } else {
                            ProjectScreenerModel.this.fReportModel = new ScreenerReportModel(new ArrayList<File>(ProjectScreenerModel.this.fFiles), ProjectScreenerModel.this.getCurrentScreenerTarget());
                        }
                        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ProjectScreenerModel.this.fChangeListeners.stateChanged(new ChangeEvent(ProjectScreenerModel.this));
                            }
                        });
                        if (runnable != null) {
                            runnable.run();
                        }
                    }
                });
            }
        });
    }

    private ScreenerTarget getCurrentScreenerTarget() {
        if (this.fConfiguration.getTarget().getKey().equals("target.matlab.hdlcoder")) {
            return ScreenerTarget.HDL;
        }
        String string = this.fConfiguration.getParamAsString("param.artifact");
        if (string.equals("option.target.artifact.mex.instrumented")) {
            return ScreenerTarget.MEX;
        }
        if (string.equals("option.target.artifact.mex")) {
            return ScreenerTarget.MEX;
        }
        return ScreenerTarget.C;
    }
}

