/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.HtmlActions;
import com.mathworks.html.HtmlContextMenuBuilder;
import com.mathworks.html.StandardHtmlActionId;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import org.w3c.dom.Node;

public class DefaultContextMenuBuilder<T extends HtmlActions>
implements HtmlContextMenuBuilder<T> {
    private final HtmlContextMenuGrouper fGrouper;

    public DefaultContextMenuBuilder() {
        this(new DefaultContextMenuGrouper());
    }

    public DefaultContextMenuBuilder(HtmlContextMenuGrouper htmlContextMenuGrouper) {
        this.fGrouper = htmlContextMenuGrouper;
    }

    @Override
    public JPopupMenu buildContextMenu(T t, Node node) {
        Collection<Collection<Action>> collection;
        if (t != null && !(collection = this.fGrouper.groupActions((HtmlActions)t)).isEmpty()) {
            JPopupMenu jPopupMenu = this.createEmptyPopupMenu();
            for (Collection<Action> collection2 : collection) {
                DefaultContextMenuBuilder.addAsGroup(jPopupMenu, collection2);
            }
            return jPopupMenu;
        }
        return null;
    }

    private static void addAsGroup(JPopupMenu jPopupMenu, Collection<? extends Action> collection) {
        if (jPopupMenu.getSubElements().length > 0) {
            jPopupMenu.addSeparator();
        }
        for (Action action : collection) {
            jPopupMenu.add(action);
        }
    }

    protected JPopupMenu createEmptyPopupMenu() {
        return new JPopupMenu();
    }

    public static class DefaultContextMenuGrouper
    implements HtmlContextMenuGrouper {
        @Override
        public Collection<Collection<Action>> groupActions(HtmlActions htmlActions) {
            LinkedList<Collection<Action>> linkedList = new LinkedList<Collection<Action>>();
            this.addIfNotEmpty(linkedList, this.getCustomActionsGroup(htmlActions));
            Collection<Action> collection = this.getActionGroup(htmlActions, StandardHtmlActionId.GO_BACK, StandardHtmlActionId.GO_FORWARD, StandardHtmlActionId.RELOAD);
            this.addIfNotEmpty(linkedList, collection);
            Collection<Action> collection2 = this.getActionGroup(htmlActions, StandardHtmlActionId.VIEW_SOURCE);
            this.addIfNotEmpty(linkedList, collection2);
            Collection<Action> collection3 = this.getActionGroup(htmlActions, StandardHtmlActionId.FIND);
            this.addIfNotEmpty(linkedList, collection3);
            return linkedList;
        }

        private Collection<Action> getCustomActionsGroup(HtmlActions htmlActions) {
            Collection<? extends Action> collection = htmlActions.getCustomActions();
            if (collection == null) {
                return null;
            }
            return new LinkedList<Action>(htmlActions.getCustomActions());
        }

        private void addIfNotEmpty(List<Collection<Action>> list, Collection<Action> collection) {
            if (collection != null && !collection.isEmpty()) {
                list.add(collection);
            }
        }

        private Collection<Action> getActionGroup(HtmlActions htmlActions, StandardHtmlActionId ... standardHtmlActionIdArray) {
            Map<StandardHtmlActionId, ? extends Action> map = htmlActions.getBasicActions();
            if (map == null || map.isEmpty()) {
                return null;
            }
            LinkedList<Action> linkedList = new LinkedList<Action>();
            for (StandardHtmlActionId standardHtmlActionId : standardHtmlActionIdArray) {
                Action action = map.get((Object)standardHtmlActionId);
                if (action == null) continue;
                linkedList.add(action);
            }
            return linkedList;
        }
    }

    public static interface HtmlContextMenuGrouper {
        public Collection<Collection<Action>> groupActions(HtmlActions var1);
    }
}

