/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.BaseTagResourceHandler;
import com.mathworks.html.CopyResourceHandler;
import com.mathworks.html.ResourceReferenceHandler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class HtmlFileWriter {
    private final File fFileToSave;
    private final String fHtmlText;
    private final String fUrl;
    private final ResourceReferenceHandler fResourceHandler;

    public HtmlFileWriter(File file, String string, String string2, boolean bl) {
        this(file, string, string2, HtmlFileWriter.getResourceHandler(file, bl));
    }

    public HtmlFileWriter(File file, String string, String string2, ResourceReferenceHandler resourceReferenceHandler) {
        this.fFileToSave = file;
        this.fHtmlText = string;
        this.fUrl = string2;
        this.fResourceHandler = resourceReferenceHandler;
    }

    private static ResourceReferenceHandler getResourceHandler(File file, boolean bl) {
        if (bl) {
            return new CopyResourceHandler(file);
        }
        return new BaseTagResourceHandler();
    }

    public void saveFile() {
        String string = this.fResourceHandler.handleReferences(this.fHtmlText, this.fUrl);
        this.writeNewFile(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeNewFile(String string) {
        Writer writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.fFileToSave)));
            writer.write(string);
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

