/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.mathworks.html.jxbrowser.HtmlTextWriter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;

class DefaultHtmlTextWriter
implements HtmlTextWriter {
    private static int sNextId = 0;
    private final String fFileName = DefaultHtmlTextWriter.getUniqueFileName();
    private File fHtmlTextDir;

    DefaultHtmlTextWriter() {
    }

    private static synchronized String getUniqueFileName() {
        return "mwblank" + sNextId++ + ".html";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeHtmlText(String string, Charset charset) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.getHtmlTextFile()));
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)bufferedOutputStream, charset);
        try {
            outputStreamWriter.write(string);
        }
        finally {
            outputStreamWriter.close();
        }
    }

    @Override
    public void setHtmlTextDir(File file) {
        if (this.isDirectoryValid(file)) {
            this.getHtmlTextFile().delete();
            this.fHtmlTextDir = file;
        }
    }

    private boolean isDirectoryValid(File file) {
        return file != null && file.exists() && file.isDirectory() && file.canWrite();
    }

    @Override
    public File getHtmlTextFile() {
        File file = this.fHtmlTextDir == null ? new File(System.getProperty("java.io.tmpdir")) : this.fHtmlTextDir;
        return new File(file, this.fFileName);
    }

    @Override
    public void dispose() {
        this.getHtmlTextFile().delete();
    }
}

