/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.services.binding;

import com.mathworks.mwswing.binding.CustomKeyBindingSet;
import com.mathworks.mwswing.binding.CustomKeyBindingSetUtils;
import com.mathworks.mwswing.binding.DefaultKeyBindingSet;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.mwswing.binding.KeyBindingManagerRegistry;
import com.mathworks.mwswing.binding.KeyBindingSet;
import com.mathworks.mwswing.binding.ReadWriteException;
import com.mathworks.services.Prefs;
import com.mathworks.services.binding.KeyBindingPreferences;
import com.mathworks.services.binding.MatlabKeyBindingPreferenceUtils;
import com.mathworks.util.Log;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

class MatlabKeyBindingPreferences
implements KeyBindingPreferences {
    private final KeyBindingManager fManager;

    MatlabKeyBindingPreferences(KeyBindingManager keyBindingManager) {
        this.fManager = keyBindingManager;
    }

    @Override
    public void addCustomSetToPrefs(File file) {
        if (this.isModifiedDefaultFile(file)) {
            throw new IllegalArgumentException("File specified conflicts with a default modified set.\n" + file.getPath());
        }
        List<File> list = this.resolveCustomFilesFromPrefs();
        if (!list.contains(file)) {
            list.add(file);
            MatlabKeyBindingPreferenceUtils.setCustomSetFilesInPrefs(list);
        }
    }

    @Override
    public boolean isModifiedDefaultFile(File file) {
        for (DefaultKeyBindingSet defaultKeyBindingSet : this.fManager.getDefaultKeyBindingSets()) {
            if (!MatlabKeyBindingPreferences.getModifiedDefaultFile(defaultKeyBindingSet).equals(file)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void storeCurrentSetInPrefs(KeyBindingSet keyBindingSet) {
        if (keyBindingSet instanceof CustomKeyBindingSet) {
            File file = new File(keyBindingSet.getID());
            assert (file.isAbsolute()) : "CustomKeyBindingSet must have an absolute path " + file.getPath();
            if (file.getParent().equals(Prefs.getPropertyDirectory())) {
                MatlabKeyBindingPreferenceUtils.setCurrentSetInPrefs(file.getName());
            } else {
                MatlabKeyBindingPreferenceUtils.setCurrentSetInPrefs(MatlabKeyBindingPreferences.getIDFromFile(file));
            }
        } else {
            assert (keyBindingSet instanceof DefaultKeyBindingSet) : "Have already handled all custom keybinding sets";
            MatlabKeyBindingPreferenceUtils.setCurrentSetInPrefs(keyBindingSet.getID());
        }
    }

    @Override
    public CustomKeyBindingSet addModifiedDefaultSetToPrefs(CustomKeyBindingSet customKeyBindingSet, DefaultKeyBindingSet defaultKeyBindingSet) throws ReadWriteException, IOException {
        File file = MatlabKeyBindingPreferences.getModifiedDefaultFile(defaultKeyBindingSet);
        CustomKeyBindingSetUtils.writeModifiedDefaultToFile((File)file, (CustomKeyBindingSet)customKeyBindingSet);
        return CustomKeyBindingSetUtils.readFromFile((File)file, (KeyBindingManagerRegistry)this.fManager);
    }

    @Override
    public void clearModifiedDefaultSetFromPrefs(DefaultKeyBindingSet defaultKeyBindingSet) {
        File file = MatlabKeyBindingPreferences.getModifiedDefaultFile(defaultKeyBindingSet);
        if (file.exists() && !file.delete()) {
            System.out.println("MatlabKeyBindingPreferences: Unable to delete modified default file " + file.getAbsolutePath());
        }
    }

    @Override
    public KeyBindingSet resolveCurrentSetFromPrefs() {
        return this.fManager.getKeyBindingSet(this.getUniqueSetIDFromPrefValue());
    }

    @Override
    public List<File> resolveCustomFilesFromPrefs() {
        return MatlabKeyBindingPreferenceUtils.readCustomSetFilesFromPrefs();
    }

    @Override
    public List<File> resolveModifiedDefaultFilesFromPrefs() throws ReadWriteException {
        LinkedList<File> linkedList = new LinkedList<File>();
        for (DefaultKeyBindingSet defaultKeyBindingSet : DefaultKeyBindingSet.getDefaultKeyBindingSets()) {
            File file = MatlabKeyBindingPreferences.getModifiedDefaultFile(defaultKeyBindingSet);
            if (!file.exists()) continue;
            linkedList.add(file);
        }
        return linkedList;
    }

    void deletePrefEntries() {
        for (DefaultKeyBindingSet defaultKeyBindingSet : DefaultKeyBindingSet.getDefaultKeyBindingSets()) {
            this.clearModifiedDefaultSetFromPrefs(defaultKeyBindingSet);
        }
        MatlabKeyBindingPreferenceUtils.deletePrefEntries();
    }

    private String getUniqueSetIDFromPrefValue() {
        Object object;
        String string = MatlabKeyBindingPreferenceUtils.readCurrentSetFromPrefs();
        String string2 = null;
        Collection collection = this.fManager.getDefaultKeyBindingSets();
        Object object2 = collection.iterator();
        while (object2.hasNext()) {
            object = (DefaultKeyBindingSet)object2.next();
            if (!object.getID().equals(string)) continue;
            if (this.fManager.getDefaultKeyBindingSetsForPlatform().contains(object)) {
                string2 = MatlabKeyBindingPreferences.getModifiedDefaultFile((DefaultKeyBindingSet)object).exists() ? this.revertToModifiedDefaultFile(MatlabKeyBindingPreferences.getModifiedDefaultFile((DefaultKeyBindingSet)object)) : string;
                break;
            }
            string2 = this.revertToDefaultSet();
            break;
        }
        if (string2 == null) {
            Object object3 = object2 = new File(string).isAbsolute() ? new File(string) : MatlabKeyBindingPreferenceUtils.resolveToPrefDir(string);
            if (((File)object2).exists() && this.fManager.containsCustomKeyBindingSet(MatlabKeyBindingPreferences.getIDFromFile((File)object2))) {
                string2 = MatlabKeyBindingPreferences.getIDFromFile((File)object2);
                object = new LinkedList(this.fManager.getDefaultKeyBindingSets());
                object.removeAll(this.fManager.getDefaultKeyBindingSetsForPlatform());
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    DefaultKeyBindingSet defaultKeyBindingSet = (DefaultKeyBindingSet)iterator.next();
                    if (!((File)object2).equals(MatlabKeyBindingPreferences.getModifiedDefaultFile(defaultKeyBindingSet))) continue;
                    string2 = this.revertToDefaultSet();
                }
            }
        }
        if (string2 == null) {
            Log.log((String)("MatlabKeyBindingPreferences: Stored keybinding set '" + string + "' does not exist, reverting to default."));
            string2 = this.revertToDefaultSet();
        }
        return string2;
    }

    private String revertToDefaultSet() {
        DefaultKeyBindingSet defaultKeyBindingSet = MatlabKeyBindingPreferenceUtils.getDefaultSetForPlatform();
        File file = MatlabKeyBindingPreferences.getModifiedDefaultFile(defaultKeyBindingSet);
        return file.exists() ? this.revertToModifiedDefaultFile(file) : this.storeInPrefsAndReturnID((KeyBindingSet)defaultKeyBindingSet);
    }

    private String revertToModifiedDefaultFile(File file) {
        String string = MatlabKeyBindingPreferences.getIDFromFile(file);
        boolean bl = this.fManager.containsCustomKeyBindingSet(string);
        assert (bl) : "Modified default set exists, but it is not registered with the keybinding manager " + string;
        return this.storeInPrefsAndReturnID((KeyBindingSet)(bl ? this.fManager.getKeyBindingSet(string) : MatlabKeyBindingPreferenceUtils.getDefaultSetForPlatform()));
    }

    private String storeInPrefsAndReturnID(KeyBindingSet keyBindingSet) {
        this.storeCurrentSetInPrefs(keyBindingSet);
        return keyBindingSet.getID();
    }

    private static File getModifiedDefaultFile(DefaultKeyBindingSet defaultKeyBindingSet) {
        return MatlabKeyBindingPreferenceUtils.resolveToPrefDir(MatlabKeyBindingPreferenceUtils.makeModifiedDefaultSetFilename(defaultKeyBindingSet));
    }

    private static String getIDFromFile(File file) {
        return file.getPath();
    }
}

