/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.services.lmgr;

import com.mathworks.services.lmgr.BorrowAPI;
import com.mathworks.services.lmgr.FeatureData;
import com.mathworks.services.lmgr.JNIException;
import com.mathworks.services.lmgr.LmgrBorrowService;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NativeLmgrBorrowService
implements LmgrBorrowService {
    private final BorrowAPI nativeMethodProvider;

    private static native void nativeGetAllInfo(ArrayList var0);

    private static native boolean nativeHasBorrowableLicense();

    private static native int nativeAutoBorrowModeOn(String var0, StringBuffer var1);

    private static native void nativeAutoBorrowModeOff();

    private static native int nativeBorrowFeature(String var0, String var1);

    private static native int nativeReturnFeature(String var0);

    private static native boolean nativeGetAutoBorrowMode();

    private static native String nativeGetErrorMsg(int var0, String var1);

    public NativeLmgrBorrowService(String string) throws JNIException {
        this(new nativeBorrowAPI(string));
    }

    public NativeLmgrBorrowService(BorrowAPI borrowAPI) {
        this.nativeMethodProvider = borrowAPI;
    }

    @Override
    public Collection<FeatureData> getFeatureData() {
        ArrayList<FeatureData> arrayList = new ArrayList<FeatureData>();
        this.nativeMethodProvider.getAllInfo(arrayList);
        return arrayList;
    }

    @Override
    public int borrowFeature(String string, int n) {
        if (string == null) {
            throw new NullPointerException("Feature name parameter is NULL.");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Number of days to borrow MUST be greater than zero.");
        }
        String string2 = this.getFlexBorrowDateFormat(n);
        if (!this.checkDateStringFormat(string2)) {
            throw new IllegalArgumentException("Date is not of the [dd-MMM-yyyy HH:mm] format");
        }
        return this.nativeMethodProvider.borrowFeature(string, string2);
    }

    @Override
    public int autoBorrowModeOn(int n, StringBuffer stringBuffer) {
        if (n <= 0) {
            throw new IllegalArgumentException("Number of days to borrow MUST be greater than zero.");
        }
        String string = this.getFlexBorrowDateFormat(n);
        if (!this.checkDateStringFormat(string)) {
            throw new IllegalArgumentException("Date is not of the [dd-MMM-yyyy HH:mm] format");
        }
        int n2 = this.nativeMethodProvider.autoBorrowModeOn(string, stringBuffer);
        return n2;
    }

    @Override
    public void autoBorrowModeOff() {
        this.nativeMethodProvider.autoBorrowModeOff();
    }

    @Override
    public boolean getAutoBorrowMode() {
        return this.nativeMethodProvider.getAutoBorrowMode();
    }

    @Override
    public int returnFeature(String string) {
        if (string == null) {
            throw new NullPointerException("Feature name parameter is NULL.");
        }
        return this.nativeMethodProvider.returnFeature(string);
    }

    @Override
    public String getErrorMessage(String string, int n) {
        if (string == null) {
            throw new NullPointerException("Feature name parameter is NULL.");
        }
        if (n >= 0) {
            throw new IllegalArgumentException("Error number must be a value LESS than zero.");
        }
        return this.nativeMethodProvider.getErrorMsg(n, string);
    }

    @Override
    public boolean hasBorrowableFeatures() {
        return this.nativeMethodProvider.hasBorrowableLicense();
    }

    private String getFlexBorrowDateFormat(int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, n - 1);
        Date date = calendar.getTime();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy HH:mm", Locale.ENGLISH);
        String string = simpleDateFormat.format(date);
        return string;
    }

    private boolean checkDateStringFormat(String string) {
        Pattern pattern = Pattern.compile("\\d\\d\\-\\D\\D\\D\\-\\d\\d\\d\\d\\s\\d\\d\\:\\d\\d");
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    private static class nativeBorrowAPI
    implements BorrowAPI {
        nativeBorrowAPI(String string) throws JNIException {
            String string2 = System.mapLibraryName("nativelmgr");
            String string3 = string.endsWith(File.separator) ? string + string2 : string + File.separator + string2;
            try {
                System.load(string3);
            }
            catch (SecurityException securityException) {
                throw new JNIException(securityException);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new JNIException(unsatisfiedLinkError);
            }
            catch (NullPointerException nullPointerException) {
                throw new JNIException(nullPointerException);
            }
            catch (Throwable throwable) {
                throw new JNIException(throwable);
            }
        }

        @Override
        public void getAllInfo(ArrayList arrayList) {
            NativeLmgrBorrowService.nativeGetAllInfo(arrayList);
        }

        @Override
        public boolean hasBorrowableLicense() {
            return NativeLmgrBorrowService.nativeHasBorrowableLicense();
        }

        @Override
        public int autoBorrowModeOn(String string, StringBuffer stringBuffer) {
            return NativeLmgrBorrowService.nativeAutoBorrowModeOn(string, stringBuffer);
        }

        @Override
        public void autoBorrowModeOff() {
            NativeLmgrBorrowService.nativeAutoBorrowModeOff();
        }

        @Override
        public int borrowFeature(String string, String string2) {
            return NativeLmgrBorrowService.nativeBorrowFeature(string, string2);
        }

        @Override
        public int returnFeature(String string) {
            return NativeLmgrBorrowService.nativeReturnFeature(string);
        }

        @Override
        public boolean getAutoBorrowMode() {
            return NativeLmgrBorrowService.nativeGetAutoBorrowMode();
        }

        @Override
        public String getErrorMsg(int n, String string) {
            return NativeLmgrBorrowService.nativeGetErrorMsg(n, string);
        }
    }
}

