/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.services.settings;

import com.mathworks.services.settings.SettingKeyConverter;
import com.mathworks.services.settings.SettingTypeException;
import com.mathworks.services.settings.SettingValidationException;
import java.awt.Color;

public class SettingColorConverter
extends SettingKeyConverter<Color, Integer[]> {
    @Override
    protected Color createObject(Integer[] integerArray) throws SettingTypeException, SettingValidationException {
        if (integerArray.length != 3) {
            throw new SettingTypeException("3");
        }
        try {
            return new Color(integerArray[0], integerArray[1], integerArray[2]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SettingValidationException(illegalArgumentException.getMessage());
        }
    }

    @Override
    protected Integer[] createKeyValue(Color color) {
        return new Integer[]{color.getRed(), color.getGreen(), color.getBlue()};
    }

    @Override
    protected Class<Color> getType() {
        return Color.class;
    }
}

