/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.services.settings;

import com.mathworks.mvm.MVM;
import com.mathworks.mvm.context.MvmContext;
import com.mathworks.services.settings.Setting;
import com.mathworks.services.settings.SettingAccessException;
import com.mathworks.services.settings.SettingConverter;
import com.mathworks.services.settings.SettingException;
import com.mathworks.services.settings.SettingInfo;
import com.mathworks.services.settings.SettingLevel;
import com.mathworks.services.settings.SettingListener;
import com.mathworks.services.settings.SettingNameDuplicationException;
import com.mathworks.services.settings.SettingNameRuntimeException;
import com.mathworks.services.settings.SettingNotFoundException;
import com.mathworks.services.settings.SettingTypeException;
import com.mathworks.services.settings.SettingUnsupportedTypeRuntimeException;
import com.mathworks.services.settings.SettingValidationException;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.RandomAccess;
import org.jetbrains.annotations.Nullable;

public final class SettingPath
extends AbstractList<String>
implements RandomAccess {
    private final TreeReference fTreeReference;
    private final String[] fElements;
    private int fHashCode = 0;

    public SettingPath(MVM mVM, String ... stringArray) {
        this(new TreeReference(SettingPath.nativeGetMvmRoot(mVM.getHandle())), null, Arrays.copyOfRange(stringArray, 0, stringArray.length));
    }

    public SettingPath(MVM mVM) {
        this(new TreeReference(SettingPath.nativeGetMvmRoot(mVM.getHandle())), null, (String[])null);
    }

    public SettingPath() throws IllegalStateException {
        TreeReference treeReference;
        this.fElements = null;
        try {
            MVM mVM = MvmContext.get();
            treeReference = new TreeReference(SettingPath.nativeGetMvmRoot(mVM.getHandle()));
        }
        catch (IllegalStateException illegalStateException) {
            treeReference = new TreeReference(SettingPath.nativeGetMvmRoot(0L));
        }
        this.fTreeReference = treeReference;
    }

    public SettingPath(String ... stringArray) throws RuntimeException, IllegalStateException, IllegalArgumentException {
        this.fTreeReference = new TreeReference(SettingPath.nativeGetMvmRoot(MvmContext.get().getHandle()));
        this.fElements = new String[stringArray.length];
        SettingPath.validateElements(stringArray);
        System.arraycopy(stringArray, 0, this.fElements, 0, stringArray.length);
        if (!Setting.nativeExists(this.getTreePtr(), this.fElements, null)) {
            throw new RuntimeException(this.toString());
        }
    }

    public SettingPath(SettingPath settingPath, String ... stringArray) throws SettingNotFoundException, IllegalArgumentException, RuntimeException {
        this(settingPath, true, stringArray);
        if (!Setting.nativeExists(this.getTreePtr(), this.elements(), null)) {
            throw new SettingNotFoundException(this.toString());
        }
    }

    SettingPath(SettingPath settingPath, boolean bl, String ... stringArray) throws IllegalArgumentException {
        this(settingPath.fTreeReference, bl ? settingPath : null, stringArray);
    }

    private SettingPath(TreeReference treeReference, @Nullable SettingPath settingPath, String ... stringArray) throws IllegalArgumentException {
        this.fTreeReference = treeReference;
        SettingPath.validateElements(stringArray);
        if (settingPath == null) {
            this.fElements = stringArray;
        } else {
            int n = settingPath.size();
            int n2 = stringArray == null ? 0 : stringArray.length;
            int n3 = n + n2;
            String[] stringArray2 = this.fElements = n3 == 0 ? null : new String[n + n2];
            if (n != 0) {
                System.arraycopy(settingPath.fElements, 0, this.fElements, 0, n);
            }
            if (n2 != 0) {
                System.arraycopy(stringArray, 0, this.fElements, n, n2);
            }
        }
    }

    public SettingPath(SettingPath settingPath, int n) throws IndexOutOfBoundsException {
        this.fTreeReference = settingPath.fTreeReference;
        if (n == 0) {
            this.fElements = null;
        } else {
            if (n > settingPath.size()) {
                throw new IndexOutOfBoundsException("Requested " + n + "elements in path of length " + settingPath.size());
            }
            this.fElements = new String[n];
            System.arraycopy(settingPath.fElements, 0, this.fElements, 0, n);
        }
    }

    public SettingPath(File file) throws FileNotFoundException {
        this.fTreeReference = new TreeReference(SettingPath.nativeLoadSettings(file == null ? null : file.getAbsolutePath()));
        this.fElements = null;
    }

    public static SettingPath createStandaloneRoot() {
        try {
            return new SettingPath((File)null);
        }
        catch (FileNotFoundException fileNotFoundException) {
            assert (false);
            return null;
        }
    }

    public SettingPath getParent() {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("Path empty");
        }
        return new SettingPath(this, this.size() - 1);
    }

    @Override
    public String toString() {
        if (this.fElements == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.fElements) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append('.');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public boolean isSameTree(SettingPath settingPath) {
        return this.fTreeReference.equals(settingPath.fTreeReference);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof SettingPath) {
            SettingPath settingPath = (SettingPath)object;
            return this.isSameTree(settingPath) && Arrays.equals(this.fElements, settingPath.fElements);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.fHashCode == 0) {
            this.fHashCode = Arrays.hashCode(this.fElements);
        }
        return this.fHashCode;
    }

    @Override
    public String get(int n) throws IndexOutOfBoundsException {
        if (n >= 0 && n < this.size()) {
            return this.fElements[n];
        }
        throw new IndexOutOfBoundsException("Requested element " + n + " in path of length " + this.size());
    }

    @Override
    public int size() {
        return this.fElements == null ? 0 : this.fElements.length;
    }

    public boolean exists() {
        return Setting.nativeExists(this.getTreePtr(), this.fElements, null);
    }

    String[] elements() {
        return this.fElements;
    }

    public <T> Setting<T> addSetting(String string, T t) throws SettingNotFoundException, SettingNameDuplicationException, SettingNameRuntimeException, SettingUnsupportedTypeRuntimeException, SettingValidationException, SettingAccessException {
        return this.addSetting(string, t, null);
    }

    public <T> Setting<T> addSetting(String string, T t, @Nullable SettingLevel settingLevel) throws SettingNotFoundException, SettingNameDuplicationException, SettingNameRuntimeException, SettingUnsupportedTypeRuntimeException, SettingValidationException, SettingAccessException {
        try {
            return this.addSetting(string, t, settingLevel, (Class)null, null, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            AssertionError assertionError = new AssertionError((Object)"Unexpected Exception");
            ((Throwable)((Object)assertionError)).initCause(noSuchMethodException);
            throw assertionError;
        }
    }

    public <T> Setting<T> addSetting(String string, Class<T> clazz, SettingLevel settingLevel) throws SettingNotFoundException, SettingNameDuplicationException, SettingNameRuntimeException, SettingUnsupportedTypeRuntimeException, SettingValidationException, SettingAccessException {
        try {
            return this.addSetting(string, null, settingLevel, clazz, null, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            assert (false);
            return null;
        }
    }

    public <T> Setting<T> addSetting(String string, @Nullable T t, SettingLevel settingLevel, Class<T> clazz, @Nullable Class<?> clazz2, @Nullable String string2) throws SettingNotFoundException, SettingNameDuplicationException, SettingNameRuntimeException, SettingUnsupportedTypeRuntimeException, SettingValidationException, NoSuchMethodException, IllegalArgumentException, SettingAccessException {
        return this.addSetting(string, t, settingLevel, clazz, SettingPath.getValidateMethod(clazz2, string2));
    }

    public <T> Setting<T> addSetting(String string, T t, SettingLevel settingLevel, Class<T> clazz, @Nullable Method method) throws SettingNotFoundException, SettingNameDuplicationException, SettingNameRuntimeException, SettingUnsupportedTypeRuntimeException, SettingValidationException, IllegalArgumentException, SettingAccessException {
        this.internalAddSetting(string, t, settingLevel, clazz, method);
        try {
            return new Setting<T>(this, clazz == null ? t.getClass() : clazz, string);
        }
        catch (SettingTypeException settingTypeException) {
            return null;
        }
    }

    public <T> Setting<T> addSetting(String string, T t, SettingLevel settingLevel, SettingConverter<T> settingConverter, Class<?> clazz, String string2) throws SettingNotFoundException, SettingNameDuplicationException, SettingNameRuntimeException, SettingUnsupportedTypeRuntimeException, SettingValidationException, NoSuchMethodException, IllegalArgumentException, SettingAccessException {
        return this.addSetting(string, t, settingLevel, settingConverter, SettingPath.getValidateMethod(clazz, string2));
    }

    /*
     * Unable to fully structure code
     */
    public <T> Setting<T> addSetting(String var1_1, T var2_2, SettingLevel var3_3, SettingConverter<T> var4_4, @Nullable Method var5_5) throws SettingNotFoundException, SettingNameDuplicationException, SettingNameRuntimeException, SettingUnsupportedTypeRuntimeException, SettingValidationException, IllegalArgumentException, SettingAccessException {
        if (var4_4 != null) {
            try {
                var7_6 = var4_4.isNode();
                var6_8 = var7_6 != false ? SettingPath.createStandaloneRoot() : this;
                var4_4.create(var6_8, var1_1, var2_2, var3_3, var5_5);
                if (!var7_6) ** GOTO lbl23
                this.copySubtree(var6_8, var3_3);
            }
            catch (SettingNameDuplicationException var6_9) {
                throw var6_9;
            }
            catch (SettingNotFoundException var6_10) {
                throw var6_10;
            }
            catch (SettingAccessException var6_11) {
                throw var6_11;
            }
            catch (SettingValidationException var6_12) {
                throw var6_12;
            }
            catch (SettingException var6_13) {
                var7_7 = new AssertionError((Object)"Unexpected Exception");
                var7_7.initCause(var6_13);
                throw var7_7;
            }
        } else {
            this.internalAddSetting(var1_1, var2_2, var3_3, null, var5_5);
        }
lbl23:
        // 3 sources

        try {
            return new Setting<T>(this, var4_4, var1_1);
        }
        catch (SettingTypeException var6_14) {
            return null;
        }
    }

    private <T> void internalAddSetting(String string, T t, SettingLevel settingLevel, @Nullable Class<T> clazz, Method method) throws SettingNotFoundException, SettingNameDuplicationException, SettingNameRuntimeException, SettingUnsupportedTypeRuntimeException, SettingValidationException, IllegalArgumentException, SettingAccessException {
        SettingConverter<T> settingConverter;
        if (t == null && clazz == null) {
            throw new IllegalArgumentException();
        }
        String string2 = null;
        String string3 = null;
        if (method != null) {
            string2 = method.getDeclaringClass().getName();
            string3 = method.getName();
        }
        if (clazz == null) {
            clazz = t.getClass();
        }
        if ((settingConverter = Setting.getBuiltinConverter(clazz)) != null) {
            this.addSetting(string, t, settingLevel, settingConverter, method);
        } else {
            SettingInfo<T> settingInfo = t == null ? new SettingInfo<T>(clazz) : new SettingInfo<T>(t);
            try {
                SettingPath.nativeAddKey(this.getTreePtr(), this.fElements, string, settingInfo, (settingLevel == null ? SettingLevel.DEFAULT : settingLevel).value(), string2, string3);
            }
            catch (SettingUnsupportedTypeRuntimeException settingUnsupportedTypeRuntimeException) {
                throw new SettingUnsupportedTypeRuntimeException(settingInfo.getType(), this, string);
            }
        }
    }

    public <T> Setting<T> addSetting(Setting<T> setting) throws SettingNotFoundException, SettingNameDuplicationException, SettingValidationException, SettingAccessException, SettingTypeException, SettingUnsupportedTypeRuntimeException {
        try {
            if (setting.getConverter() != null) {
                return this.addSetting(setting.getName(), setting.get(), setting.getLevel(), setting.getConverter(), null);
            }
            return this.addSetting(setting.getName(), setting.get(), setting.getLevel(), setting.getType(), null);
        }
        catch (SettingNameRuntimeException settingNameRuntimeException) {
            AssertionError assertionError = new AssertionError((Object)"Unexpected Exception");
            ((Throwable)((Object)assertionError)).initCause(settingNameRuntimeException);
            throw assertionError;
        }
    }

    public <T> Setting<T> addSetting(Setting<T> setting, Class<T> clazz, String string) throws SettingNotFoundException, SettingNameDuplicationException, SettingValidationException, NoSuchMethodException, SettingAccessException, IllegalArgumentException, SettingTypeException, SettingUnsupportedTypeRuntimeException {
        try {
            if (setting.getConverter() != null) {
                return this.addSetting(setting.getName(), setting.get(), setting.getLevel(), setting.getConverter(), clazz, string);
            }
            return this.addSetting(setting.getName(), setting.get(), setting.getLevel(), setting.getType(), clazz, string);
        }
        catch (SettingNameRuntimeException settingNameRuntimeException) {
            AssertionError assertionError = new AssertionError((Object)"Unexpected Exception");
            ((Throwable)((Object)assertionError)).initCause(settingNameRuntimeException);
            throw assertionError;
        }
    }

    public SettingPath addNode(String string) throws SettingNotFoundException, SettingNameDuplicationException, SettingNameRuntimeException {
        try {
            this.addNode(string, null, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return new SettingPath(this, string);
    }

    public SettingPath addNode(String string, @Nullable Class<?> clazz, @Nullable String string2) throws SettingNotFoundException, SettingNameDuplicationException, SettingNameRuntimeException, NoSuchMethodException, IllegalArgumentException {
        return this.addNode(string, clazz == null ? null : SettingPath.getValidateMethod(clazz, string2));
    }

    public SettingPath addNode(String string, Method method) throws SettingNotFoundException, SettingNameDuplicationException, SettingNameRuntimeException {
        String string2 = null;
        String string3 = null;
        if (method != null) {
            string2 = method.getDeclaringClass().getName();
            string3 = method.getName();
        }
        SettingPath.nativeAddNode(this.getTreePtr(), this.fElements, string, string2, string3);
        return new SettingPath(this, string);
    }

    public void copySubtree(SettingPath settingPath, SettingLevel settingLevel) throws SettingNotFoundException, UnsupportedOperationException, SettingValidationException, SettingNameDuplicationException {
        SettingPath.nativeCopySubtree(this.getTreePtr(), this.fElements, settingPath.getTreePtr(), settingPath.fElements, (settingLevel == null ? SettingLevel.DEFAULT : settingLevel).value());
    }

    long getTreePtr() {
        return this.fTreeReference.fTreePtr;
    }

    public SettingPath delete() throws SettingNotFoundException, SettingAccessException {
        if (this.fElements == null) {
            throw new SettingAccessException("Can't delete the root node");
        }
        SettingPath.nativeDelete(this.getTreePtr(), this.getParent().elements(), this.fElements[this.fElements.length - 1]);
        return this.getParent();
    }

    public void delete(String string) throws SettingNotFoundException, SettingAccessException {
        SettingPath.nativeDelete(this.getTreePtr(), this.fElements, string);
    }

    public void prune() throws SettingNotFoundException, SettingAccessException {
        for (String string : this.getChildNames()) {
            try {
                this.delete(string);
            }
            catch (SettingNotFoundException settingNotFoundException) {
                // empty catch block
            }
        }
    }

    public String[] getChildNames() throws SettingNotFoundException {
        return SettingPath.nativeGetChildren(this.getTreePtr(), this.elements(), 0);
    }

    public List<SettingPath> getChildPaths() throws SettingNotFoundException {
        String[] stringArray = SettingPath.nativeGetChildren(this.getTreePtr(), this.elements(), -1);
        ArrayList<SettingPath> arrayList = new ArrayList<SettingPath>(stringArray.length);
        for (String string : stringArray) {
            try {
                arrayList.add(new SettingPath(this, string));
            }
            catch (SettingNotFoundException settingNotFoundException) {
                if (this.exists()) continue;
                throw settingNotFoundException;
            }
        }
        return arrayList;
    }

    public List<Setting<?>> getChildSettings() throws SettingNotFoundException {
        String[] stringArray = SettingPath.nativeGetChildren(this.getTreePtr(), this.elements(), 1);
        ArrayList arrayList = new ArrayList(stringArray.length);
        for (String string : stringArray) {
            try {
                arrayList.add(new Setting(this, string));
            }
            catch (SettingNotFoundException settingNotFoundException) {
                if (this.exists()) continue;
                throw settingNotFoundException;
            }
        }
        return arrayList;
    }

    private static void validateElements(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        for (String string : stringArray) {
            if (string != null) continue;
            throw new IllegalArgumentException("Null name in path");
        }
    }

    public boolean isChildNode(String string) throws SettingNotFoundException {
        return SettingPath.nativeIsChildNode(this.getTreePtr(), this.elements(), string);
    }

    private static Method getValidateMethod(Class<?> clazz, String string) throws NoSuchMethodException {
        if (clazz == null) {
            return null;
        }
        if (string == null) {
            throw new IllegalArgumentException();
        }
        Method method = clazz.getMethod(string, Setting.class, Object.class);
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new NoSuchMethodException(string + " not static");
        }
        return method;
    }

    public void addListener(SettingListener settingListener) throws UnsupportedOperationException, SettingNotFoundException {
        Setting.nativeAddRemoveListener(this, this.getTreePtr(), this.elements(), null, settingListener);
    }

    public void removeListener(SettingListener settingListener) throws SettingNotFoundException {
        Setting.nativeAddRemoveListener(null, this.getTreePtr(), this.elements(), null, settingListener);
    }

    private static native void nativeCopySubtree(long var0, String[] var2, long var3, String[] var5, String var6);

    private static native <T> void nativeAddKey(long var0, String[] var2, String var3, SettingInfo<T> var4, String var5, String var6, String var7) throws SettingNotFoundException, SettingNameDuplicationException, SettingNameRuntimeException, SettingUnsupportedTypeRuntimeException;

    private static native long nativeLoadSettings(String var0) throws FileNotFoundException;

    private static native void nativeAddNode(long var0, String[] var2, String var3, String var4, String var5) throws SettingNotFoundException, SettingNameDuplicationException, SettingNameRuntimeException;

    private static native long nativeGetMvmRoot(long var0);

    private static native void nativeDelete(long var0, String[] var2, String var3) throws SettingNotFoundException, SettingAccessException;

    private static native long nativeGetPtrTarget(long var0);

    private static native void nativeReleasePtr(long var0);

    private static native boolean nativeIsChildNode(long var0, String[] var2, String var3) throws SettingNotFoundException;

    private static native String[] nativeGetChildren(long var0, String[] var2, int var3) throws SettingNotFoundException;

    static {
        Setting.loadLibrary();
    }

    private static class TreeReference {
        public final long fTreePtr;

        TreeReference(long l) {
            this.fTreePtr = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                SettingPath.nativeReleasePtr(this.fTreePtr);
            }
            finally {
                super.finalize();
            }
        }

        private long getRealTreePtr() {
            return SettingPath.nativeGetPtrTarget(this.fTreePtr);
        }

        public boolean equals(Object object) {
            return this == object || object instanceof TreeReference && ((TreeReference)object).getRealTreePtr() == this.getRealTreePtr();
        }

        public int hashCode() {
            return Long.valueOf(this.getRealTreePtr()).hashCode();
        }
    }
}

