/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt;

import com.mathworks.mwt.MWComponent;
import com.mathworks.mwt.MWFocusChain;
import com.mathworks.mwt.MWLightweight;
import com.mathworks.mwt.MWUtils;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.mwt.dnd.DragMessage;
import com.mathworks.mwt.dnd.DropTarget;
import com.mathworks.mwt.floater.Floater;
import com.mathworks.mwt.floater.FloaterContainer;
import com.mathworks.mwt.floater.FloaterOwner;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class MWContainer
extends Container
implements MWLightweight,
DropTarget {
    private static final int KEY_MASK = 14;
    private int CMDMASK = 2;
    private int INV_CMD_MASK;
    private int fKeyCode = 0;
    private boolean fOpaque = true;
    private Component fRedispatchDestination;

    protected MWContainer() {
        this.enableEvents(28L);
        if (PlatformInfo.getPlatform() == 0) {
            this.CMDMASK = 4;
        }
        this.INV_CMD_MASK = PlatformInfo.getPlatform() == 2 ? ~(this.CMDMASK | 8) : ~this.CMDMASK;
    }

    @Override
    public Font getFont() {
        Font font = super.getFont();
        if (font == null) {
            font = Decorations.getFont(0);
        }
        return font;
    }

    @Override
    public void trackDrag(DragMessage dragMessage) {
    }

    @Override
    public boolean willReceiveDrag(Transferable transferable, MouseEvent mouseEvent, Rectangle rectangle) {
        return false;
    }

    @Override
    public void receiveDrop(Transferable transferable) {
    }

    @Override
    public boolean isOpaque() {
        return this.fOpaque;
    }

    @Override
    public void setOpaque(boolean bl) {
        this.fOpaque = bl;
    }

    @Override
    public Cursor getCursor() {
        Cursor cursor = null;
        for (Container container = this.getParent(); container != null && cursor == null; container = container.getParent()) {
            Cursor cursor2 = container instanceof MWContainer ? ((MWContainer)container).superGetCursor() : container.getCursor();
            if (!Cursor.getPredefinedCursor(3).equals(cursor2)) continue;
            cursor = cursor2;
        }
        if (cursor == null) {
            cursor = super.getCursor();
        }
        return cursor;
    }

    Cursor superGetCursor() {
        return super.getCursor();
    }

    public Window getTopLevelWindow() {
        return MWUtils.getTopLevelWindow(this);
    }

    public Rectangle boundsInOtherComponent(Component component) {
        return MWUtils.boundsInOtherComponent(this, component);
    }

    public Rectangle boundsInTopLevelWindow() {
        return MWUtils.boundsInTopLevelWindow(this);
    }

    public Rectangle getBoundsInWindow() {
        Rectangle rectangle = this.getBounds();
        for (Container container = this.getParent(); container != null && !(container instanceof Window); container = container.getParent()) {
            rectangle.x += container.getLocation().x;
            rectangle.y += container.getLocation().y;
        }
        return rectangle;
    }

    @Override
    public void processFocusEvent(FocusEvent focusEvent) {
        MWFocusChain mWFocusChain = MWUtils.getNextFocusLink(this);
        if (mWFocusChain != null) {
            mWFocusChain.focusEvent(focusEvent);
        }
        if (focusEvent.getID() == 1005) {
            this.fKeyCode = 0;
        }
        super.processFocusEvent(focusEvent);
    }

    private boolean isFloaterEvent(MouseEvent mouseEvent) {
        boolean bl = false;
        if (mouseEvent.getSource() instanceof Component) {
            Component component = (Component)mouseEvent.getSource();
            if (component instanceof Floater) {
                bl = true;
            } else {
                Container container;
                for (container = component.getParent(); container != null && !(container instanceof Floater); container = container.getParent()) {
                }
                if (container instanceof Floater) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    private FloaterOwner getFloaterOwner(MouseEvent mouseEvent) {
        FloaterOwner floaterOwner = null;
        if (mouseEvent.getSource() instanceof Component) {
            Component component = (Component)mouseEvent.getSource();
            if (component instanceof FloaterOwner) {
                floaterOwner = (FloaterOwner)((Object)component);
            } else {
                Container container;
                for (container = component.getParent(); container != null && !(container instanceof FloaterOwner); container = container.getParent()) {
                }
                if (container instanceof FloaterOwner) {
                    floaterOwner = (FloaterOwner)((Object)container);
                }
            }
        }
        return floaterOwner;
    }

    @Override
    public void processMouseEvent(MouseEvent mouseEvent) {
        Object object;
        if (PlatformInfo.isMacintosh()) {
            if (mouseEvent.getID() == 501) {
                this.fRedispatchDestination = null;
                object = (Component)mouseEvent.getSource();
                Point point = mouseEvent.getPoint();
                Window window = SwingUtilities.windowForComponent((Component)object);
                point = SwingUtilities.convertPoint((Component)object, point, window);
                Component component = SwingUtilities.getDeepestComponentAt(window, point.x, point.y);
                if (object != component) {
                    this.fRedispatchDestination = component;
                    this.redispatch(mouseEvent);
                    return;
                }
            } else if (this.fRedispatchDestination != null) {
                this.redispatch(mouseEvent);
                if (mouseEvent.getID() == 502) {
                    this.fRedispatchDestination = null;
                }
                return;
            }
        }
        if (mouseEvent.getID() == 501 && (object = MWUtils.getNextFocusLink(this)) != null) {
            object.focusMousePressed(mouseEvent);
        }
        if (mouseEvent.getID() == 501 && !this.isFloaterEvent(mouseEvent)) {
            for (object = this; object != null && !(object instanceof FloaterContainer); object = ((Component)object).getParent()) {
            }
            if (object instanceof FloaterContainer) {
                ((FloaterContainer)object).hideFloaters(this.getFloaterOwner(mouseEvent));
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        int n = 1;
        int n2 = keyEvent.getKeyCode();
        int n3 = keyEvent.getModifiers();
        if ((n3 & 0xE) != 0) {
            boolean bl;
            boolean bl2 = n3 == 2;
            boolean bl3 = bl = bl2 || n3 == 3;
            if (keyEvent.getID() == 401 && (bl && (n2 == 9 || n2 == 117) || bl2 && (n2 == 33 || n2 == 34))) {
                MWFocusChain mWFocusChain = MWUtils.getNextFocusLink(this);
                if (mWFocusChain != null) {
                    mWFocusChain.focusSwitch(keyEvent);
                }
            } else {
                n = this.processAcceleratorKey(keyEvent);
            }
        } else if (n2 >= 112 && n2 <= 123) {
            n = this.processAcceleratorKey(keyEvent);
        } else if (PlatformInfo.getPlatform() == 1 && (n2 == 155 || n2 == 127) && n3 == 1) {
            n = this.processAcceleratorKey(keyEvent);
        }
        if (n == 1) {
            super.processKeyEvent(keyEvent);
        } else {
            keyEvent.consume();
        }
    }

    public void superProcessKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
    }

    private int processAcceleratorKey(KeyEvent keyEvent) {
        int n = 0;
        if (keyEvent.getID() == 401) {
            int n2 = keyEvent.getKeyCode();
            if (n2 != 17 && n2 != 157 && n2 != 18) {
                if (PlatformInfo.getPlatform() == 2 && keyEvent.isControlDown() && keyEvent.isShiftDown() && n2 == 0 && keyEvent.getKeyChar() == '\u001f') {
                    n2 = PlatformInfo.isVersion118() ? 189 : 45;
                }
                if (n2 == 0 && keyEvent.isAltDown() && keyEvent.isControlDown()) {
                    n = 1;
                    n2 = this.fKeyCode;
                }
                if (this.fKeyCode != n2) {
                    this.fKeyCode = n2;
                    int n3 = keyEvent.getModifiers();
                    if (n2 >= 112 && n2 <= 123 && (n3 & 2) == 0) {
                        n3 |= 0xFFFFFF80;
                    }
                    n2 += (n3 & this.INV_CMD_MASK) << 24;
                    MWCommandCenter mWCommandCenter = MWCommandCenter.findCommandCenter(this);
                    n = mWCommandCenter != null ? mWCommandCenter.processKey(n2) : 1;
                }
                if (n == 1) {
                    this.fKeyCode = 0;
                }
            }
        } else {
            int n4;
            if (keyEvent.getID() == 402) {
                this.fKeyCode = 0;
                switch (keyEvent.getKeyCode()) {
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: {
                        n = 1;
                        break;
                    }
                }
            } else if (keyEvent.getID() == 400 && (n4 = keyEvent.getKeyCode()) != 17 && n4 != 157 && n4 != 18) {
                this.fKeyCode = 0;
            }
            if (keyEvent.getKeyCode() == 0 && keyEvent.isAltDown() && keyEvent.isControlDown()) {
                n = 1;
            }
        }
        return n;
    }

    public Frame getFrame() {
        return MWComponent.getComponentFrame(this);
    }

    private void redispatch(MouseEvent mouseEvent) {
        Component component = (Component)mouseEvent.getSource();
        if (this.fRedispatchDestination != null && this.fRedispatchDestination != component) {
            this.fRedispatchDestination.dispatchEvent(SwingUtilities.convertMouseEvent(component, mouseEvent, this.fRedispatchDestination));
        }
    }
}

