/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.dialog;

import com.mathworks.util.FactoryUtils;
import javax.swing.SwingUtilities;

class SynchronousInvokeUtility {
    SynchronousInvokeUtility() {
    }

    public static void queueSynchronousEvent(SynchronousEvent synchronousEvent) {
        if (SwingUtilities.isEventDispatchThread()) {
            synchronousEvent.executeOnSwingThread();
        } else {
            Thread thread = Thread.currentThread();
            synchronousEvent.setThread(thread);
            SwingUtilities.invokeLater(synchronousEvent);
            while (!synchronousEvent.isDone()) {
                if (FactoryUtils.processPendingEvents()) {
                    synchronousEvent.setInterruptPending(true);
                    break;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public static abstract class SynchronousEvent
    implements Runnable {
        private boolean fDone = false;
        private Thread fThread;
        private boolean fInterruptPending = false;

        public abstract void executeOnSwingThread();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.executeOnSwingThread();
            }
            catch (Error error) {
                error.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                this.fDone = true;
            }
        }

        void setInterruptPending(boolean bl) {
            this.fInterruptPending = bl;
        }

        public boolean isInterruptPending() {
            return this.fInterruptPending;
        }

        boolean isDone() {
            return this.fDone;
        }

        void setThread(Thread thread) {
            this.fThread = thread;
        }
    }

    public static class SynchronousEventAdapter
    extends SynchronousEvent {
        Runnable fRunnable;

        public SynchronousEventAdapter(Runnable runnable) {
            this.fRunnable = runnable;
        }

        @Override
        public void executeOnSwingThread() {
            if (this.fRunnable != null) {
                this.fRunnable.run();
            }
        }
    }
}

