/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.table;

import com.mathworks.mwt.table.EnumWithState;
import java.util.Vector;

public class DynamicEnumWithState
implements Cloneable,
EnumWithState {
    private int fCurrentIndex = -1;
    private Vector fItems = null;
    private boolean fCanEdit = false;

    public DynamicEnumWithState() {
    }

    public DynamicEnumWithState(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addString(stringArray[i]);
        }
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Vector vector = this.getStorageVector();
            int n = vector.size();
            if (n > 0) {
                Object[] objectArray = new String[n];
                vector.copyInto(objectArray);
                object = new DynamicEnumWithState((String[])objectArray);
            } else {
                object = new DynamicEnumWithState();
            }
            ((DynamicEnumWithState)object).setCurrentValue(this.getCurrentValue());
            ((DynamicEnumWithState)object).setEditable(this.isEditable());
        }
        return object;
    }

    protected Vector getStorageVector() {
        if (this.fItems == null) {
            this.fItems = new Vector(5, 7);
        }
        return this.fItems;
    }

    @Override
    public void setCurrentValue(int n) {
        if (n >= 0 && n < this.getStorageVector().size()) {
            this.fCurrentIndex = n;
        }
    }

    @Override
    public int getCurrentValue() {
        if (this.fCurrentIndex == -1 && !this.getStorageVector().isEmpty()) {
            this.fCurrentIndex = 0;
        }
        return this.fCurrentIndex;
    }

    @Override
    public int getValue(String string) {
        int n = -1;
        if (string != null && (n = this.getStorageVector().indexOf(string)) < 0) {
            n = -1;
        }
        return n;
    }

    @Override
    public int[] getAllValues() {
        int[] nArray = new int[this.getStorageVector().size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    public void setEditable(boolean bl) {
        this.fCanEdit = bl;
    }

    public boolean isEditable() {
        return this.fCanEdit;
    }

    @Override
    public void setCurrentString(String string) {
        if (string != null) {
            int n = this.getStorageVector().indexOf(string);
            if (n >= 0) {
                this.fCurrentIndex = n;
            } else {
                this.addString(string);
                this.setCurrentValue(this.getValue(string));
            }
        }
    }

    @Override
    public String getCurrentString() {
        return this.getString(this.getCurrentValue());
    }

    @Override
    public String getString(int n) {
        String string = null;
        Vector vector = this.getStorageVector();
        if (n >= 0 && n < vector.size()) {
            string = (String)vector.elementAt(n);
        }
        return string;
    }

    @Override
    public String[] getAllStrings() {
        String[] stringArray = null;
        Vector vector = this.getStorageVector();
        if (!vector.isEmpty()) {
            stringArray = new String[vector.size()];
            for (int i = 0; i < vector.size() && i < stringArray.length; ++i) {
                stringArray[i] = (String)vector.elementAt(i);
            }
        }
        return stringArray;
    }

    public int addString(String string) {
        int n = -1;
        if (string != null) {
            this.removeString(string);
            this.getStorageVector().addElement(string);
            n = this.getStorageVector().size() - 1;
            if (this.fCurrentIndex == -1) {
                this.fCurrentIndex = n;
            }
        }
        return n;
    }

    public int insertString(String string, int n) {
        int n2 = -1;
        Vector vector = this.getStorageVector();
        if (string != null && n >= 0 && n < vector.size()) {
            if (!vector.elementAt(n).equals(string)) {
                int n3 = vector.indexOf(string);
                if (this.removeString(n3) && n3 < n) {
                    --n;
                }
                vector.insertElementAt(string, n);
                if (this.fCurrentIndex >= n) {
                    ++this.fCurrentIndex;
                } else if (this.fCurrentIndex == -1) {
                    this.fCurrentIndex = n;
                }
            }
            n2 = n;
        }
        return n2;
    }

    public boolean removeString(int n) {
        boolean bl;
        Vector vector = this.getStorageVector();
        boolean bl2 = bl = n >= 0 && n < vector.size();
        if (bl) {
            vector.removeElementAt(n);
            if (vector.size() == 0 || this.fCurrentIndex == n) {
                this.fCurrentIndex = -1;
            } else if (this.fCurrentIndex > n) {
                --this.fCurrentIndex;
            }
        }
        return bl;
    }

    public boolean removeString(String string) {
        boolean bl = false;
        if (string != null) {
            bl = this.removeString(this.getStorageVector().indexOf(string));
        }
        return bl;
    }

    public void removeAllStrings() {
        this.getStorageVector().removeAllElements();
        this.fCurrentIndex = -1;
    }

    public void setString(String string, int n) {
        Vector vector = this.getStorageVector();
        if (string != null && n >= 0 && n < vector.size()) {
            vector.setElementAt(string, n);
        }
    }

    public int size() {
        return this.getStorageVector().size();
    }

    public String toString() {
        return this.getCurrentString();
    }
}

