/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.table;

import com.mathworks.mwt.ObjBuffer;
import com.mathworks.mwt.table.Table;
import com.mathworks.mwt.table.TableData;
import com.mathworks.mwt.table.TreeData;
import com.mathworks.mwt.table.TreeNode;
import com.mathworks.util.IntHashtable;

public class SimpleTreeData
extends TreeData {
    private ObjBuffer fVisibleItems = new ObjBuffer();
    private ObjBuffer fItems = new ObjBuffer();
    private IntHashtable fItemLookup = new IntHashtable();

    public SimpleTreeData(Table table) {
        super(table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxDepth() {
        int n = 0;
        ObjBuffer objBuffer = this.fVisibleItems;
        synchronized (objBuffer) {
            for (int i = 0; i < this.fVisibleItems.length(); ++i) {
                TreeNode treeNode = (TreeNode)this.fVisibleItems.getAt(i);
                if (treeNode.getDepth() <= n) continue;
                n = treeNode.getDepth();
            }
        }
        return n;
    }

    @Override
    public int getDepth(int n) {
        TreeNode treeNode = this.getNode(n);
        int n2 = treeNode != null ? treeNode.getDepth() : 0;
        return n2;
    }

    @Override
    public boolean isExpanded(int n) {
        TreeNode treeNode = this.getNode(n);
        boolean bl = treeNode != null ? treeNode.isExpanded() : false;
        return bl;
    }

    @Override
    public boolean isBranch(int n) {
        TreeNode treeNode = this.getNode(n);
        boolean bl = treeNode != null ? treeNode.isBranch() : false;
        return bl;
    }

    @Override
    public void setBranch(int n, boolean bl) {
        TreeNode treeNode = this.getNode(n);
        if (treeNode != null && treeNode.isBranch() != bl) {
            if (!bl) {
                this.removeChildren(n);
            }
            treeNode.setIsBranch(bl);
        }
    }

    @Override
    public boolean hasChildren(int n) {
        TreeNode treeNode = this.getNode(n);
        boolean bl = false;
        if (treeNode != null && treeNode.isBranch()) {
            bl = treeNode.getChildren().length() > 0;
        }
        return bl;
    }

    @Override
    public int getParent(int n) {
        TreeNode treeNode = this.getNode(n);
        TreeNode treeNode2 = treeNode != null ? treeNode.getParent() : null;
        int n2 = treeNode2 != null ? treeNode2.getId() : -1;
        return n2;
    }

    @Override
    public int getNextSibling(int n) {
        TreeNode treeNode;
        ObjBuffer objBuffer;
        int n2 = -1;
        TreeNode treeNode2 = this.getNode(n);
        if (treeNode2 != null && (objBuffer = (treeNode = treeNode2.getParent()) != null ? treeNode.getChildren() : this.fItems).length() > 1) {
            for (n2 = 0; n2 < objBuffer.length() - 1 && treeNode2 != objBuffer.getAt(n2); ++n2) {
            }
            n2 = n2 == objBuffer.length() - 1 ? -1 : ((TreeNode)objBuffer.getAt(n2)).getId();
        }
        return n2;
    }

    @Override
    public int[] getChildren(int n) {
        int[] nArray;
        TreeNode treeNode = this.getNode(n);
        if (treeNode != null) {
            nArray = new int[treeNode.getChildren().length()];
            for (int i = 0; i < nArray.length; ++i) {
                TreeNode treeNode2 = (TreeNode)treeNode.getChildren().getAt(i);
                nArray[i] = treeNode2 != null ? treeNode2.getId() : -1;
            }
        } else if (n == -1) {
            nArray = new int[this.fItems.length()];
            for (int i = 0; i < nArray.length; ++i) {
                TreeNode treeNode3 = (TreeNode)this.fItems.getAt(i);
                nArray[i] = treeNode3 != null ? treeNode3.getId() : -1;
            }
        } else {
            nArray = new int[]{};
        }
        return nArray;
    }

    @Override
    public Object getItem(int n) {
        Object object = null;
        TreeNode treeNode = (TreeNode)this.fItemLookup.get(n);
        if (treeNode != null) {
            object = treeNode.getData();
        }
        return object;
    }

    @Override
    public Object getItem(int n, int n2) {
        Object object = null;
        TreeNode treeNode = (TreeNode)this.fItemLookup.get(n);
        if (treeNode != null) {
            if (treeNode.getData() instanceof Object[]) {
                Object[] objectArray = (Object[])treeNode.getData();
                if (n2 >= 0 && n2 < objectArray.length) {
                    object = objectArray[n2];
                }
            } else if (n2 == 0) {
                object = treeNode.getData();
            }
        }
        return object;
    }

    @Override
    public void setItem(int n, Object object) {
        TreeNode treeNode = (TreeNode)this.fItemLookup.get(n);
        if (treeNode != null) {
            treeNode.setData(object);
            int n2 = this.getIndex(treeNode);
            TableData tableData = this.getTable().getData();
            if (n2 != -2 && tableData != null) {
                if (object instanceof Object[]) {
                    Object[] objectArray = (Object[])object;
                    for (int i = 0; i < objectArray.length && i < tableData.getWidth(); ++i) {
                        tableData.setData(n2, i, objectArray[i]);
                    }
                } else {
                    tableData.setData(n2, 0, object);
                }
            }
        }
    }

    @Override
    public void setItem(int n, int n2, Object object) {
        TreeNode treeNode = (TreeNode)this.fItemLookup.get(n);
        if (treeNode != null) {
            if (treeNode.getData() instanceof Object[]) {
                Object[] objectArray = (Object[])treeNode.getData();
                if (n2 >= 0 && n2 < objectArray.length) {
                    objectArray[n2] = object;
                }
            } else if (n2 == 0) {
                treeNode.setData(object);
            }
            int n3 = this.getIndex(treeNode);
            TableData tableData = this.getTable().getData();
            if (n3 != -2 && tableData != null) {
                tableData.setData(n3, n2, object);
            }
        }
    }

    @Override
    public int insertItem(int n, int n2, Object object, boolean bl) {
        TreeNode treeNode = this.getNode(n);
        TreeNode treeNode2 = new TreeNode(this.getUniqueId(), treeNode, object, bl);
        ObjBuffer objBuffer = treeNode != null ? treeNode.getChildren() : this.fItems;
        if (n2 == -1) {
            n2 = objBuffer.length();
        }
        objBuffer.insert(n2, treeNode2);
        this.fItemLookup.put(treeNode2.getId(), (Object)treeNode2);
        if (this.isNodeVisible(treeNode2)) {
            if (n2 == 0 && treeNode == null) {
                this.insertIntoTable(0, treeNode2);
            } else if (n2 == 0) {
                this.insertIntoTable(this.getIndex(treeNode) + 1, treeNode2);
            } else {
                TreeNode[] treeNodeArray;
                TreeNode treeNode3 = (TreeNode)objBuffer.getAt(n2 - 1);
                if (treeNode3.isBranch() && treeNode3.isExpanded() && (treeNodeArray = this.getVisibleDescendants(treeNode3)).length > 0) {
                    treeNode3 = treeNodeArray[treeNodeArray.length - 1];
                }
                this.insertIntoTable(this.getIndex(treeNode3) + 1, treeNode2);
            }
        } else if (n != -1 && this.isNodeVisible(treeNode)) {
            this.getTable().repaint();
        }
        return treeNode2.getId();
    }

    @Override
    public void removeChildren(int n) {
        int[] nArray = this.getChildren(n);
        for (int i = 0; i < nArray.length; ++i) {
            this.removeItem(nArray[i]);
        }
    }

    private void removeNodeChildren(TreeNode treeNode) {
        ObjBuffer objBuffer = treeNode.getChildren();
        int n = objBuffer.length();
        for (int i = 0; i < n; ++i) {
            TreeNode treeNode2 = (TreeNode)objBuffer.getAt(i);
            if (treeNode2 == null || !treeNode2.isBranch() || !treeNode2.isExpanded()) continue;
            this.removeNodeChildren(treeNode2);
        }
        objBuffer.delete(0, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllItems() {
        ObjBuffer objBuffer = this.fVisibleItems;
        synchronized (objBuffer) {
            for (int i = 0; i < this.fVisibleItems.length(); ++i) {
                this.removeNodeChildren((TreeNode)this.fVisibleItems.getAt(i));
            }
            this.fVisibleItems.delete(0, this.fVisibleItems.length());
        }
        this.fItems.delete(0, this.fItems.length());
        this.fItemLookup.clear();
        this.getTable().getData().setHeight(0);
    }

    @Override
    public void removeItem(int n) {
        TreeNode treeNode = this.getNode(n);
        if (treeNode != null) {
            int n2;
            if (this.isNodeVisible(treeNode)) {
                this.removeDescendantsFromTable(treeNode, true);
                n2 = this.getIndex(treeNode);
                this.removeFromTable(n2, n2 + 1, true);
            }
            if (this.fItemLookup.containsKey(n)) {
                this.fItemLookup.remove(n);
            }
            ObjBuffer objBuffer = treeNode.getParent() != null ? treeNode.getParent().getChildren() : this.fItems;
            for (n2 = 0; n2 < objBuffer.length() && objBuffer.getAt(n2) != treeNode; ++n2) {
            }
            if (n2 < objBuffer.length()) {
                objBuffer.delete(n2, n2 + 1);
            }
        }
    }

    @Override
    public void expandItem(int n) {
        TreeNode treeNode = this.getNode(n);
        if (treeNode != null && treeNode.isBranch() && !treeNode.isExpanded()) {
            if (this.isNodeVisible(treeNode)) {
                this.insertDescendantsIntoTable(treeNode);
            }
            treeNode.setExpanded(true);
        }
    }

    @Override
    public void collapseItem(int n) {
        TreeNode treeNode = this.getNode(n);
        if (treeNode != null && treeNode.isBranch() && treeNode.isExpanded()) {
            if (this.isNodeVisible(treeNode)) {
                treeNode.setIsCollapsing(true);
                this.removeDescendantsFromTable(treeNode);
                treeNode.setIsCollapsing(false);
            }
            treeNode.setExpanded(false);
        }
    }

    @Override
    public int getItemId(int n) {
        int n2 = -1;
        TreeNode treeNode = this.getVisibleNode(n);
        if (treeNode != null) {
            n2 = treeNode.getId();
        }
        return n2;
    }

    public int getItemIndex(int n) {
        return this.getIndex(this.getNode(n));
    }

    public boolean isItemVisible(int n) {
        boolean bl = false;
        TreeNode treeNode = this.getNode(n);
        if (treeNode != null && this.isNodeVisible(treeNode)) {
            while ((treeNode = treeNode.getParent()) != null && treeNode.isExpanded() && !treeNode.isCollapsing()) {
            }
            if (treeNode == null || treeNode.isExpanded() && !treeNode.isCollapsing()) {
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getIndex(TreeNode treeNode) {
        int n = -2;
        if (treeNode != null) {
            ObjBuffer objBuffer = this.fVisibleItems;
            synchronized (objBuffer) {
                int n2;
                for (n2 = 0; n2 < this.fVisibleItems.length() && treeNode != this.fVisibleItems.getAt(n2); ++n2) {
                }
                if (n2 < this.fVisibleItems.length()) {
                    n = n2;
                }
            }
        }
        return n;
    }

    private TreeNode[] getVisibleDescendants(TreeNode treeNode) {
        ObjBuffer objBuffer = new ObjBuffer();
        this.getVisibleDescendantsHelper(treeNode, objBuffer);
        Object[] objectArray = new TreeNode[objBuffer.length()];
        objBuffer.copyInto(0, objectArray.length, objectArray, 0);
        return objectArray;
    }

    private void getVisibleDescendantsHelper(TreeNode treeNode, ObjBuffer objBuffer) {
        for (int i = 0; i < treeNode.getChildren().length(); ++i) {
            TreeNode treeNode2 = (TreeNode)treeNode.getChildren().getAt(i);
            if (treeNode2 == null) continue;
            objBuffer.append(treeNode2);
            if (!treeNode2.isBranch() || !treeNode2.isExpanded()) continue;
            this.getVisibleDescendantsHelper(treeNode2, objBuffer);
        }
    }

    private void insertDescendantsIntoTable(TreeNode treeNode) {
        int n;
        if (treeNode != null && (n = this.getIndex(treeNode)) != -2) {
            ++n;
            TreeNode[] treeNodeArray = this.getVisibleDescendants(treeNode);
            if (treeNodeArray.length > 0) {
                this.insertIntoTable(n, treeNodeArray);
            }
        }
    }

    private void removeDescendantsFromTable(TreeNode treeNode) {
        this.removeDescendantsFromTable(treeNode, false);
    }

    private void removeDescendantsFromTable(TreeNode treeNode, boolean bl) {
        TreeNode[] treeNodeArray;
        if (treeNode.isBranch() && treeNode.isExpanded() && (treeNodeArray = this.getVisibleDescendants(treeNode)).length > 0) {
            int n = this.getIndex(treeNode) + 1;
            int n2 = n + treeNodeArray.length;
            this.removeFromTable(n, n2, bl);
        }
    }

    private void insertIntoTable(int n, TreeNode treeNode) {
        TreeNode[] treeNodeArray = new TreeNode[]{treeNode};
        this.insertIntoTable(n, treeNodeArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertIntoTable(int n, TreeNode[] treeNodeArray) {
        TableData tableData = this.getTable().getData();
        ObjBuffer objBuffer = this.fVisibleItems;
        synchronized (objBuffer) {
            this.fVisibleItems.insert(n, treeNodeArray);
        }
        tableData.addRows(n, treeNodeArray.length);
        for (int i = 0; i < treeNodeArray.length; ++i) {
            if (treeNodeArray[i].getData() instanceof Object[]) {
                Object[] objectArray = (Object[])treeNodeArray[i].getData();
                for (int j = 0; j < tableData.getWidth() && j < objectArray.length; ++j) {
                    tableData.setData(n + i, j, objectArray[j]);
                }
                continue;
            }
            tableData.setData(n + i, 0, treeNodeArray[i].getData());
        }
    }

    private void removeFromTable(int n, int n2) {
        this.removeFromTable(n, n2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromTable(int n, int n2, boolean bl) {
        TableData tableData = this.getTable().getData();
        for (int i = n; i < n2; ++i) {
            TreeNode treeNode = this.getVisibleNode(i);
            if (bl) {
                if (!this.fItemLookup.containsKey(treeNode.getId())) continue;
                this.fItemLookup.remove(treeNode.getId());
                continue;
            }
            if (treeNode.getData() instanceof Object[]) {
                Object[] objectArray = (Object[])treeNode.getData();
                for (int j = 0; j < objectArray.length && j < tableData.getWidth(); ++j) {
                    objectArray[j] = tableData.getData(i, j);
                }
                continue;
            }
            treeNode.setData(tableData.getData(i, 0));
        }
        ObjBuffer objBuffer = this.fVisibleItems;
        synchronized (objBuffer) {
            this.fVisibleItems.delete(n, n2);
        }
        tableData.removeRows(n, n2 - n);
    }

    private boolean isNodeVisible(TreeNode treeNode) {
        boolean bl = false;
        TreeNode treeNode2 = treeNode.getParent();
        if (treeNode2 != null && treeNode2.isExpanded()) {
            bl = this.isNodeVisible(treeNode2);
        } else if (treeNode2 == null) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeNode getVisibleNode(int n) {
        TreeNode treeNode = null;
        ObjBuffer objBuffer = this.fVisibleItems;
        synchronized (objBuffer) {
            if (n >= 0 && n < this.fVisibleItems.length()) {
                treeNode = (TreeNode)this.fVisibleItems.getAt(n);
            }
        }
        return treeNode;
    }

    private TreeNode getNode(int n) {
        return (TreeNode)this.fItemLookup.get(n);
    }

    public void setHeight(int n) {
        this.getTable().getData().setHeight(n);
        this.fItems.setSize(n);
        this.fItems.setSize(0);
        this.fVisibleItems.setSize(n);
        this.fVisibleItems.setSize(0);
        this.fItemLookup = new IntHashtable((int)((double)n * 1.5));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAt(int n, Object object, boolean bl) {
        TreeNode treeNode = new TreeNode(this.getUniqueId(), null, object, bl);
        this.fItems.insert(n, treeNode);
        this.fItemLookup.put(treeNode.getId(), (Object)treeNode);
        TableData tableData = this.getTable().getData();
        Object[] objectArray = this.fVisibleItems;
        synchronized (this.fVisibleItems) {
            this.fVisibleItems.insert(n, treeNode);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            if (object instanceof Object[]) {
                objectArray = (Object[])object;
                for (int i = 0; i < tableData.getWidth() && i < objectArray.length; ++i) {
                    tableData.setData(n, i, objectArray[i]);
                }
            } else {
                tableData.setData(n, 0, object);
            }
            return;
        }
    }
}

