/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.text;

import com.mathworks.mwt.text.MWTextAdapter;
import com.mathworks.mwt.text.MWTextEvent;
import com.mathworks.mwt.text.MWTextModel;
import com.mathworks.mwt.text.UndoableCompoundEdit;
import com.mathworks.mwt.text.UndoableTextEdit;
import com.mathworks.mwt.undo.UndoEvent;
import com.mathworks.mwt.undo.UndoListener;
import com.mathworks.mwt.undo.UndoManager;
import com.mathworks.mwt.undo.UndoableEdit;

class TextUndoRelay
extends MWTextAdapter {
    private MWTextModel fText;
    private UndoableCompoundEdit fActiveEdit;
    private boolean fUndoOrRedoInProgress;
    private UndoListener fListener;
    private int fSuspendNestingDepth;
    private UndoManager fSelfUndoManager;

    public TextUndoRelay(MWTextModel mWTextModel) {
        this.fText = mWTextModel;
        this.fActiveEdit = null;
        this.fUndoOrRedoInProgress = false;
        this.fListener = null;
        this.fSuspendNestingDepth = 0;
        this.fSelfUndoManager = null;
        mWTextModel.addTextListener(this);
    }

    private void textChange(MWTextEvent mWTextEvent) {
        if (this.isUndoNotificationSuspended() || this.fActiveEdit == null) {
            return;
        }
        UndoableTextEdit undoableTextEdit = new UndoableTextEdit(mWTextEvent);
        this.fActiveEdit.merge(undoableTextEdit);
    }

    @Override
    public void textInserted(MWTextEvent mWTextEvent) {
        this.textChange(mWTextEvent);
    }

    @Override
    public void textDeleted(MWTextEvent mWTextEvent) {
        this.textChange(mWTextEvent);
    }

    void addEdit(UndoableEdit undoableEdit) {
        if (this.fActiveEdit != null && !this.isUndoNotificationSuspended()) {
            this.fActiveEdit.merge(undoableEdit);
        }
    }

    @Override
    public void commandStarted(MWTextEvent mWTextEvent) {
        if (!this.isSomeoneListening()) {
            this.fSelfUndoManager = new UndoManager();
            this.addUndoListener(this.fSelfUndoManager);
        }
        this.fActiveEdit = new UndoableCompoundEdit(mWTextEvent.getCommandID());
    }

    @Override
    public void commandEnded(MWTextEvent mWTextEvent) {
        if (this.fActiveEdit.isEmpty()) {
            this.fActiveEdit = null;
            return;
        }
        if (this.isSomeoneListening()) {
            TextUndoEvent textUndoEvent = new TextUndoEvent(this.fText, this.fActiveEdit);
            this.fActiveEdit = null;
            this.notifyListener(textUndoEvent);
        } else {
            this.fActiveEdit = null;
        }
    }

    public void addUndoListener(UndoListener undoListener) {
        if (this.fListener != null) {
            throw new IllegalArgumentException("Attempt to add an UndoListener when one is already in place.");
        }
        this.fListener = undoListener;
    }

    public boolean removeUndoListener(UndoListener undoListener) {
        if (undoListener == this.fListener) {
            this.fListener = null;
            return true;
        }
        return false;
    }

    public void suspendUndoNotification() {
        ++this.fSuspendNestingDepth;
    }

    public void resumeUndoNotification() {
        --this.fSuspendNestingDepth;
        if (this.fSuspendNestingDepth < 0) {
            throw new IllegalStateException("Unbalanced resumeUndoNotification");
        }
    }

    private boolean isSomeoneListening() {
        return this.fListener != null;
    }

    private boolean isUndoNotificationSuspended() {
        return this.fSuspendNestingDepth > 0;
    }

    private void notifyListener(UndoEvent undoEvent) {
        if (this.fListener != null && !this.isUndoNotificationSuspended()) {
            this.fListener.undoableEditHappened(undoEvent);
        }
    }

    public void clearUndoHistory() {
        this.verifySelfUndoManager();
        this.fSelfUndoManager.clearUndoHistory();
    }

    public boolean canUndo() {
        if (this.fListener == null) {
            return false;
        }
        this.verifySelfUndoManager();
        return this.fSelfUndoManager.canUndo();
    }

    public void undo() {
        this.verifySelfUndoManager();
        this.fSelfUndoManager.undo();
    }

    public boolean canRedo() {
        if (this.fListener == null) {
            return false;
        }
        this.verifySelfUndoManager();
        return this.fSelfUndoManager.canRedo();
    }

    public void redo() {
        this.verifySelfUndoManager();
        this.fSelfUndoManager.redo();
    }

    private void verifySelfUndoManager() {
        if (this.fSelfUndoManager == null) {
            if (this.fListener != null && this.fListener instanceof UndoManager) {
                this.fSelfUndoManager = (UndoManager)this.fListener;
            } else {
                throw new IllegalStateException(this + " was asked to perform undo/redo/canUndo/canRedo, but " + this.fListener + " is registered as the undo manager.  Did you override ctrl-Z and ctrl-Y with your own versions of Undo & Redo?");
            }
        }
    }

    class TextUndoEvent
    extends UndoEvent {
        TextUndoEvent(Object object, UndoableEdit undoableEdit) {
            super(object, undoableEdit);
        }

        @Override
        public boolean combineWith(UndoableEdit undoableEdit) {
            UndoableEdit undoableEdit2 = this.getEdit();
            if (!(undoableEdit instanceof UndoableCompoundEdit && undoableEdit2 instanceof UndoableCompoundEdit && (undoableEdit.getName().equals("Typing") && undoableEdit2.getName().equals("Typing") || undoableEdit.getName().equals("Delete") && undoableEdit2.getName().equals("Delete")) && ((UndoableCompoundEdit)undoableEdit2).numEdits() == 1)) {
                return false;
            }
            UndoableEdit undoableEdit3 = ((UndoableCompoundEdit)undoableEdit).getLastEdit();
            UndoableEdit undoableEdit4 = ((UndoableCompoundEdit)undoableEdit2).getFirstEdit();
            if (undoableEdit3 == null || undoableEdit4 == null || !(undoableEdit3 instanceof UndoableTextEdit) || !(undoableEdit4 instanceof UndoableTextEdit)) {
                return false;
            }
            UndoableTextEdit undoableTextEdit = (UndoableTextEdit)undoableEdit3;
            UndoableTextEdit undoableTextEdit2 = (UndoableTextEdit)undoableEdit4;
            if (undoableTextEdit.getModel() != undoableTextEdit2.getModel()) {
                return false;
            }
            if (!(undoableTextEdit.getEnd() == undoableTextEdit2.getStart() || undoableEdit.getName().equals("Delete") && undoableEdit2.getName().equals("Delete") && undoableTextEdit.getStart() == undoableTextEdit2.getStart() && undoableTextEdit.getEnd() == undoableTextEdit2.getEnd())) {
                return false;
            }
            ((UndoableCompoundEdit)undoableEdit).merge(undoableEdit4);
            return true;
        }
    }
}

