/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.gui.WritableTableFormat;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import ca.odell.glazedlists.swing.MutableTableModelEvent;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventTableModel<E>
extends AbstractTableModel
implements ListEventListener<E> {
    protected TransformedList<E, E> swingThreadSource;
    private final boolean disposeSwingThreadSource;
    private TableFormat<? super E> tableFormat;
    private final MutableTableModelEvent tableModelEvent = new MutableTableModelEvent(this);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventTableModel(EventList<E> source, TableFormat<? super E> tableFormat) {
        source.getReadWriteLock().readLock().lock();
        try {
            this.disposeSwingThreadSource = !GlazedListsSwing.isSwingThreadProxyList(source);
            this.swingThreadSource = this.disposeSwingThreadSource ? GlazedListsSwing.swingThreadProxyList(source) : (TransformedList)source;
            this.tableFormat = tableFormat;
            this.swingThreadSource.addListEventListener(this);
        }
        finally {
            source.getReadWriteLock().readLock().unlock();
        }
    }

    public EventTableModel(EventList<E> source, String[] propertyNames, String[] columnLabels, boolean[] writable) {
        this(source, GlazedLists.tableFormat(propertyNames, columnLabels, writable));
    }

    public TableFormat<? super E> getTableFormat() {
        return this.tableFormat;
    }

    public void setTableFormat(TableFormat<E> tableFormat) {
        this.tableFormat = tableFormat;
        this.tableModelEvent.setStructureChanged();
        this.fireTableChanged(this.tableModelEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E getElementAt(int index) {
        this.swingThreadSource.getReadWriteLock().readLock().lock();
        try {
            E e = this.swingThreadSource.get(index);
            return e;
        }
        finally {
            this.swingThreadSource.getReadWriteLock().readLock().unlock();
        }
    }

    @Override
    public void listChanged(ListEvent<E> listChanges) {
        while (listChanges.nextBlock()) {
            int startIndex = listChanges.getBlockStartIndex();
            int endIndex = listChanges.getBlockEndIndex();
            int changeType = listChanges.getType();
            this.tableModelEvent.setValues(startIndex, endIndex, changeType);
            this.fireTableChanged(this.tableModelEvent);
        }
    }

    @Override
    public String getColumnName(int column) {
        return this.tableFormat.getColumnName(column);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        this.swingThreadSource.getReadWriteLock().readLock().lock();
        try {
            int n = this.swingThreadSource.size();
            return n;
        }
        finally {
            this.swingThreadSource.getReadWriteLock().readLock().unlock();
        }
    }

    @Override
    public int getColumnCount() {
        return this.tableFormat.getColumnCount();
    }

    public Class getColumnClass(int columnIndex) {
        if (this.tableFormat instanceof AdvancedTableFormat) {
            return ((AdvancedTableFormat)this.tableFormat).getColumnClass(columnIndex);
        }
        return super.getColumnClass(columnIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int row, int column) {
        this.swingThreadSource.getReadWriteLock().readLock().lock();
        try {
            Object object = this.tableFormat.getColumnValue(this.swingThreadSource.get(row), column);
            return object;
        }
        finally {
            this.swingThreadSource.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCellEditable(int row, int column) {
        if (this.tableFormat instanceof WritableTableFormat) {
            WritableTableFormat writableTableFormat = (WritableTableFormat)this.tableFormat;
            this.swingThreadSource.getReadWriteLock().readLock().lock();
            try {
                E toEdit = this.swingThreadSource.get(row);
                boolean bl = writableTableFormat.isEditable(toEdit, column);
                return bl;
            }
            finally {
                this.swingThreadSource.getReadWriteLock().readLock().unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setValueAt(Object editedValue, int row, int column) {
        if (!(this.tableFormat instanceof WritableTableFormat)) throw new UnsupportedOperationException("Unexpected setValueAt() on read-only table");
        this.swingThreadSource.getReadWriteLock().writeLock().lock();
        try {
            boolean baseObjectHasNotMoved;
            WritableTableFormat writableTableFormat = (WritableTableFormat)this.tableFormat;
            E baseObject = this.swingThreadSource.get(row);
            E updatedObject = writableTableFormat.setColumnValue(baseObject, editedValue, column);
            if (updatedObject == null) return;
            boolean bl = baseObjectHasNotMoved = row < this.getRowCount() && this.swingThreadSource.get(row) == baseObject;
            if (!baseObjectHasNotMoved) return;
            this.swingThreadSource.set(row, updatedObject);
            return;
        }
        finally {
            this.swingThreadSource.getReadWriteLock().writeLock().unlock();
        }
    }

    public void dispose() {
        this.swingThreadSource.removeListEventListener(this);
        if (this.disposeSwingThreadSource) {
            this.swingThreadSource.dispose();
        }
        this.swingThreadSource = null;
    }
}

