/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.TreeList;
import ca.odell.glazedlists.swing.EventSelectionModel;
import ca.odell.glazedlists.swing.TreeTableCellPanel;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;

class TreeTableUtilities {
    TreeTableUtilities() {
    }

    static int rowAtPoint(MouseEvent mouseEvent) {
        JTable table = (JTable)mouseEvent.getSource();
        Point clickPoint = mouseEvent.getPoint();
        return table.rowAtPoint(clickPoint);
    }

    static TreeTableCellPanel prepareRenderer(MouseEvent mouseEvent) {
        JTable table = (JTable)mouseEvent.getSource();
        Point clickPoint = mouseEvent.getPoint();
        int row = table.rowAtPoint(clickPoint);
        int column = table.columnAtPoint(clickPoint);
        if (row == -1 || column == -1) {
            return null;
        }
        Rectangle cellRect = table.getCellRect(row, column, true);
        Component renderedComponent = table.prepareRenderer(table.getCellRenderer(row, column), row, column);
        if (!(renderedComponent instanceof TreeTableCellPanel)) {
            return null;
        }
        TreeTableCellPanel renderedPanel = (TreeTableCellPanel)renderedComponent;
        renderedPanel.setBounds(cellRect);
        renderedPanel.doLayout();
        return renderedPanel;
    }

    static Runnable toggleExpansion(JTable table, TreeList treeList, int row) {
        RestoreStateRunnable restoreStateRunnable = new RestoreStateRunnable(table);
        EventSelectionModel selectionModel = restoreStateRunnable.getEventSelectionModel();
        if (selectionModel != null) {
            selectionModel.setEnabled(false);
        }
        table.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        treeList.toggleExpanded(row);
        return restoreStateRunnable;
    }

    private static class RestoreStateRunnable
    implements Runnable {
        private final JTable table;
        private final Boolean autoStartsEdit;
        private final EventSelectionModel eventSelectionModel;
        private final boolean eventSelectionModelEnabled;

        public RestoreStateRunnable(JTable table) {
            this.table = table;
            ListSelectionModel selectionModel = table.getSelectionModel();
            this.eventSelectionModel = selectionModel instanceof EventSelectionModel ? (EventSelectionModel)selectionModel : null;
            this.eventSelectionModelEnabled = this.eventSelectionModel != null && this.eventSelectionModel.getEnabled();
            this.autoStartsEdit = (Boolean)table.getClientProperty("JTable.autoStartsEdit");
        }

        public EventSelectionModel getEventSelectionModel() {
            return this.eventSelectionModel;
        }

        public void run() {
            this.table.putClientProperty("JTable.autoStartsEdit", this.autoStartsEdit);
            if (this.eventSelectionModel != null) {
                this.eventSelectionModel.setEnabled(this.eventSelectionModelEnabled);
            }
        }
    }
}

