/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.export;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.freehep.util.export.ExportFileType;
import org.freehep.util.export.MimeTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportFileTypeGroups {
    public static final String VECTOR = "vector";
    public static final String BITMAP = "bitmap";
    public static final String OTHER = "other";
    public static final String ALTERNATIVE = "alternative";
    private List<String> groupNames = new ArrayList<String>();
    private Map<String, Map<String, ExportFileType>> groups;
    private List<ExportFileType> alternatives;
    private Map<String, String> labels;

    public ExportFileTypeGroups(List<ExportFileType> exportFileTypes) {
        this.groupNames.add(VECTOR);
        this.groupNames.add(BITMAP);
        this.groupNames.add(OTHER);
        this.groupNames.add(ALTERNATIVE);
        this.labels = new HashMap<String, String>();
        this.labels.put(VECTOR, "Vector Formats");
        this.labels.put(BITMAP, "Bitmap Formats");
        this.labels.put(OTHER, "Other");
        this.labels.put(ALTERNATIVE, "Alternative Formats");
        this.groups = new HashMap<String, Map<String, ExportFileType>>();
        this.alternatives = new ArrayList<ExportFileType>();
        for (ExportFileType exportFileType : exportFileTypes) {
            String extension;
            String mimeType = exportFileType.getMIMETypes()[0];
            String key = MimeTypes.isBitmap(mimeType) ? BITMAP : (MimeTypes.isVector(mimeType) ? VECTOR : OTHER);
            Map<String, ExportFileType> fileTypes = this.groups.get(key);
            if (fileTypes == null) {
                fileTypes = new HashMap<String, ExportFileType>();
                this.groups.put(key, fileTypes);
            }
            if (fileTypes.get(extension = exportFileType.getExtensions()[0]) == null) {
                fileTypes.put(extension, exportFileType);
                continue;
            }
            this.alternatives.add(exportFileType);
        }
    }

    public List<ExportFileType> getExportFileTypes(String group) {
        ArrayList<ExportFileType> result = new ArrayList<ExportFileType>();
        if (group.equals(ALTERNATIVE)) {
            result.addAll(this.alternatives);
        } else {
            Map<String, ExportFileType> fileTypes = this.groups.get(group);
            if (fileTypes != null) {
                result.addAll(fileTypes.values());
            }
        }
        return result;
    }

    public List<String> getGroupNames() {
        return this.groupNames;
    }

    public String getLabel(String group) {
        return this.labels.get(group);
    }
}

