/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.dragdrop;

import com.mathworks.services.ObjectRegistry;
import com.mathworks.toolbox.matlab.guide.LayoutArea;
import com.mathworks.toolbox.matlab.guide.LayoutLooper;
import com.mathworks.toolbox.matlab.guide.dragdrop.DragTracker;
import com.mathworks.toolbox.matlab.guide.palette.LOControlWrapper;
import com.mathworks.toolbox.matlab.guide.undoredo.UndoMove;
import com.mathworks.toolbox.matlab.guide.utils.LayoutUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;

public final class MoveDrag
extends DragTracker {
    private static final int MOVE_THRESHOLD = 3;
    private LOControlWrapper fWrapper;
    private Point fStartPt;
    private Point fCurrentPt;
    private Rectangle fBounds;
    private Vector fSelection;
    private LOControlWrapper fOriginalParent;
    private LOControlWrapper fCurrentParent;
    private boolean fThreshold;
    private boolean fHasLeftParent;
    private boolean fControlOnly;
    private boolean fDuplicate;

    public MoveDrag(LayoutArea layoutArea, LOControlWrapper lOControlWrapper, boolean bl) {
        super(layoutArea);
        this.fLayoutArea = layoutArea;
        this.fWrapper = lOControlWrapper;
        this.fThreshold = false;
        this.fHasLeftParent = false;
        this.fControlOnly = true;
        this.fDuplicate = bl;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        LOControlWrapper lOControlWrapper;
        this.fStartPt = mouseEvent.getPoint();
        if (!this.fWrapper.isSelected()) {
            if (!mouseEvent.isShiftDown() && !LayoutUtils.isCommandDown(mouseEvent)) {
                this.fLayoutArea.selectAll(false);
            }
            this.fLayoutArea.selectObject(this.fWrapper, true);
            this.fLayoutArea.drawNow();
            this.fLayoutArea.updateSelection();
        }
        this.fSelection = this.fLayoutArea.getSelectedControls();
        Point point = this.fWrapper.getBaseLocation();
        Dimension dimension = this.fWrapper.getControl().getSize();
        this.fBounds = new Rectangle(point.x, point.y, dimension.width, dimension.height);
        Enumeration enumeration = this.fSelection.elements();
        while (enumeration.hasMoreElements()) {
            lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
            point = lOControlWrapper.getBaseLocation();
            dimension = lOControlWrapper.getControl().getSize();
            this.fBounds.add(point);
            this.fBounds.add(point.x + dimension.width, point.y + dimension.height);
            if (lOControlWrapper.isEnclosable()) continue;
            this.fControlOnly = false;
            break;
        }
        if (this.fControlOnly) {
            for (lOControlWrapper = this.fWrapper.getParent(); lOControlWrapper != null && lOControlWrapper.isSelected(); lOControlWrapper = lOControlWrapper.getParent()) {
            }
            this.fOriginalParent = this.fCurrentParent = lOControlWrapper;
        }
        this.fLayoutArea.getHRuler().doMouseTrackXOROff();
        this.fLayoutArea.getVRuler().doMouseTrackXOROff();
        this.fLayoutArea.getHRuler().doMouseDragMouseMoved(this.fBounds);
        this.fLayoutArea.getVRuler().doMouseDragMouseMoved(this.fBounds);
        if (this.fLayoutArea.getLayoutStatusBar() != null) {
            this.fLayoutArea.getLayoutStatusBar().setPosition(this.fWrapper.getParent(), this.fWrapper, true);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n;
        int n2;
        Cloneable cloneable;
        Graphics graphics = this.getXORGraphics();
        this.drawObjects(graphics);
        if (!this.fThreshold) {
            cloneable = mouseEvent.getPoint();
            n2 = Math.abs(cloneable.x - this.fStartPt.x);
            n = Math.abs(cloneable.y - this.fStartPt.y);
            boolean bl = this.fThreshold = n2 > 3 || n > 3;
        }
        if (this.fThreshold) {
            this.fCurrentPt = mouseEvent.getPoint();
            if (mouseEvent.isShiftDown()) {
                int n3 = Math.abs(this.fCurrentPt.x - this.fStartPt.x);
                if (n3 > (n2 = Math.abs(this.fCurrentPt.y - this.fStartPt.y))) {
                    this.fCurrentPt.y = this.fStartPt.y;
                } else {
                    this.fCurrentPt.x = this.fStartPt.x;
                }
            }
            cloneable = this.pinPointWithSnap();
            this.drawObjects(graphics);
            if (this.fControlOnly) {
                LOControlWrapper lOControlWrapper = this.fLayoutArea.findContainer(this.fCurrentPt);
                if ((lOControlWrapper = this.validateParent(lOControlWrapper)) != this.fCurrentParent && this.fWrapper.isEnclosable()) {
                    this.drawContainer(graphics);
                    this.fCurrentParent = lOControlWrapper;
                    this.fHasLeftParent = true;
                    this.drawContainer(graphics);
                }
            }
            this.fLayoutArea.getHRuler().doMouseDragMouseMoved((Rectangle)cloneable);
            this.fLayoutArea.getVRuler().doMouseDragMouseMoved((Rectangle)cloneable);
            int n4 = this.fStartPt.x - this.fCurrentPt.x;
            n = this.fStartPt.y - this.fCurrentPt.y;
            Point point = new Point(this.fWrapper.getLeft() - n4, this.fWrapper.getBottom() - n);
            Point point2 = new Point(this.fWrapper.getRight() - n4, this.fWrapper.getTop() - n);
            if (this.fLayoutArea.getLayoutStatusBar() != null) {
                this.fLayoutArea.getLayoutStatusBar().setPosition(this.fCurrentParent, point, point2, true);
            }
        }
        graphics.dispose();
        graphics = null;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.fThreshold && this.fCurrentPt != null) {
            Graphics graphics = this.getXORGraphics();
            this.drawObjects(graphics);
            this.fCurrentPt = mouseEvent.getPoint();
            if (mouseEvent.isShiftDown()) {
                int n;
                int n2 = Math.abs(this.fCurrentPt.x - this.fStartPt.x);
                if (n2 > (n = Math.abs(this.fCurrentPt.y - this.fStartPt.y))) {
                    this.fCurrentPt.y = this.fStartPt.y;
                } else {
                    this.fCurrentPt.x = this.fStartPt.x;
                }
            }
            Rectangle rectangle = this.pinPointWithSnap();
            if (this.fControlOnly) {
                this.drawContainer(graphics);
                LOControlWrapper lOControlWrapper = this.fLayoutArea.findContainer(this.fCurrentPt);
                this.fCurrentParent = this.validateParent(lOControlWrapper);
            }
            if (this.fDuplicate) {
                Point point = new Point(this.fCurrentPt.x - this.fStartPt.x, this.fCurrentPt.y - this.fStartPt.y);
                this.fLayoutArea.doDuplicate(this.fCurrentParent, point);
            } else {
                UndoMove undoMove = new UndoMove(this.fLayoutArea, this.fSelection);
                if (this.fCurrentParent != this.fOriginalParent) {
                    this.reparentObjects();
                } else {
                    this.moveObjects();
                }
                if (undoMove.moveComplete()) {
                    this.fLayoutArea.fireUndoEvent(undoMove);
                    this.fLayoutArea.fireContentChangedEvent();
                    this.fLayoutArea.repaint(5L);
                    if (this.fWrapper.isGObject()) {
                        LayoutLooper.requestMove(this.fSelection, null);
                    } else {
                        this.fLayoutArea.fireObjectChangedEvent(this.fSelection);
                    }
                }
            }
            graphics.dispose();
            graphics = null;
        }
        this.fLayoutArea.getHRuler().doMouseDragXOROff();
        this.fLayoutArea.getVRuler().doMouseDragXOROff();
        this.fLayoutArea.getHRuler().doMouseTrackMouseMoved(mouseEvent.getPoint());
        this.fLayoutArea.getVRuler().doMouseTrackMouseMoved(mouseEvent.getPoint());
        this.fLayoutArea.updateSelection();
    }

    private Rectangle pinPointWithSnap() {
        if (this.fCurrentPt.x < 0) {
            this.fCurrentPt.x = 0;
        }
        if (this.fCurrentPt.y < 0) {
            this.fCurrentPt.y = 0;
        }
        Dimension dimension = this.fLayoutArea.getSize();
        if (this.fCurrentPt.x > dimension.width) {
            this.fCurrentPt.x = dimension.width;
        }
        if (this.fCurrentPt.y > dimension.height) {
            this.fCurrentPt.y = dimension.height;
        }
        Rectangle rectangle = new Rectangle(this.fBounds);
        int n = this.fCurrentPt.x - this.fStartPt.x;
        int n2 = this.fCurrentPt.y - this.fStartPt.y;
        rectangle.translate(n, n2);
        n2 = 0;
        n = 0;
        if (rectangle.x < 0) {
            n = -rectangle.x;
        }
        if (rectangle.y < 0) {
            n2 = -rectangle.y;
        }
        if (rectangle.x + rectangle.width > dimension.width) {
            n = dimension.width - (rectangle.x + rectangle.width);
        }
        if (rectangle.y + rectangle.height > dimension.height) {
            n2 = dimension.height - (rectangle.y + rectangle.height);
        }
        if (n != 0 || n2 != 0) {
            this.fCurrentPt.translate(n, n2);
            rectangle.translate(n, n2);
        }
        Point point = this.getSnapRect(rectangle);
        this.fCurrentPt.translate(point.x, point.y);
        return rectangle;
    }

    private void drawObjects(Graphics graphics) {
        if (this.fCurrentPt != null) {
            int n = this.fCurrentPt.x - this.fStartPt.x;
            int n2 = this.fCurrentPt.y - this.fStartPt.y;
            Enumeration enumeration = this.fSelection.elements();
            while (enumeration.hasMoreElements()) {
                LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
                Point point = lOControlWrapper.getBaseLocation();
                point.translate(n, n2);
                Dimension dimension = lOControlWrapper.getControl().getSize();
                graphics.drawRect(point.x, point.y, dimension.width - 1, dimension.height - 1);
            }
        }
    }

    private void drawContainer(Graphics graphics) {
        if (this.fHasLeftParent) {
            if (this.fCurrentParent != null) {
                Point point = this.fCurrentParent.getBaseLocation();
                Dimension dimension = this.fCurrentParent.getControl().getSize();
                graphics.drawRect(point.x - 1, point.y - 1, dimension.width + 1, dimension.height + 1);
                graphics.drawRect(point.x - 2, point.y - 2, dimension.width + 3, dimension.height + 3);
            } else {
                this.drawDropOutline(graphics);
            }
        }
    }

    private LOControlWrapper validateParent(LOControlWrapper lOControlWrapper) {
        LOControlWrapper lOControlWrapper2 = lOControlWrapper;
        while (lOControlWrapper != null) {
            if (this.fSelection.contains(lOControlWrapper)) {
                lOControlWrapper2 = lOControlWrapper.getParent();
                break;
            }
            lOControlWrapper = lOControlWrapper.getParent();
        }
        return lOControlWrapper2;
    }

    private void moveObjects() {
        int n = this.fCurrentPt.x - this.fStartPt.x;
        int n2 = this.fCurrentPt.y - this.fStartPt.y;
        Enumeration enumeration = this.fSelection.elements();
        while (enumeration.hasMoreElements()) {
            LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
            Point point = lOControlWrapper.getControl().getLocation();
            point.translate(n, n2);
            lOControlWrapper.getControl().setLocation(point);
        }
    }

    private void reparentObjects() {
        Object object;
        int n = this.fCurrentPt.x - this.fStartPt.x;
        int n2 = this.fCurrentPt.y - this.fStartPt.y;
        Enumeration enumeration = this.fSelection.elements();
        Object[] objectArray = new Object[this.fSelection.size()];
        Vector<Object> vector = new Vector<Object>(this.fSelection.size());
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            object = (LOControlWrapper)enumeration.nextElement();
            Point point = ((LOControlWrapper)object).getBaseLocation();
            point.translate(n, n2);
            LOControlWrapper lOControlWrapper = ((LOControlWrapper)object).getParent();
            if (lOControlWrapper == null) {
                this.fLayoutArea.removeWrapper((LOControlWrapper)object, false);
            } else if (((LOControlWrapper)object).isGObject()) {
                lOControlWrapper.removeWrapper((LOControlWrapper)object, false);
            } else {
                lOControlWrapper.removeWrapper((LOControlWrapper)object, true);
            }
            if (this.fCurrentParent == null) {
                ((LOControlWrapper)object).getControl().setLocation(point);
                this.fLayoutArea.addWrapper((LOControlWrapper)object, -1, false);
            } else {
                this.fCurrentParent.translateFromBaseCoordinates(point);
                ((LOControlWrapper)object).getControl().setLocation(point);
                this.fCurrentParent.addWrapper((LOControlWrapper)object, -1, false);
            }
            if (((LOControlWrapper)object).isGObject()) {
                vector.addElement(object);
            }
            objectArray[n3++] = ((LOControlWrapper)object).getBean();
        }
        if (vector.size() > 0) {
            LayoutLooper.changeParent(vector, this.fLayoutArea, null, null);
        } else {
            object = this.fCurrentParent != null ? (this.fCurrentParent.isGObject() ? this.fCurrentParent.getBean() : ((Component)objectArray[0]).getParent()) : this.fLayoutArea.getRootObject();
            ObjectRegistry.getLayoutRegistry().move(objectArray, object, -1);
        }
        this.fLayoutArea.repaint();
    }
}

