/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.menueditor;

import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.toolbox.matlab.guide.menueditor.MenuEditor;
import com.mathworks.toolbox.matlab.guide.menueditor.MenuEditorUtils;
import com.mathworks.toolbox.matlab.guide.menueditor.MenuNode;
import com.mathworks.toolbox.matlab.guide.menueditor.MenuTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

class MenuPropertyPanel
extends MJPanel {
    private static final String COMBO_NONE = MenuEditorUtils.getResource("combo.none");
    private MJTextField fLabelField;
    private MJTextField fTagField;
    private MJTextField fCallbackField;
    private MJButton fViewCallback;
    private MJButton fMoreOptions;
    private MJCheckBox fSeparatorCBox;
    private MJCheckBox fCheckedCBox;
    private MJCheckBox fEnabledCBox;
    private MJLabel fAcceleratorLabel;
    private MJComboBox fAcceleratorCombo;
    private MJPanel fAccelPanel;
    private MJPanel fCheckboxPanel;
    private MenuEditor fEditor;
    private MenuNode fNode;
    private MenuTreeNode fTreeNode;

    MenuPropertyPanel(MenuEditor menuEditor, int n) {
        this.fEditor = menuEditor;
        this.setLayout(new BorderLayout());
        switch (n) {
            case 1: {
                this.setName("menuPropertyPanel");
                this.setBorder(BorderFactory.createTitledBorder(MenuEditorUtils.getResource("groupbox.UIMenu")));
                EventHandler eventHandler = new EventHandler();
                MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout(0, 8));
                mJPanel.add((Component)this.stringsPanel(n, eventHandler), (Object)"North");
                mJPanel.add((Component)this.checkboxaccleratorPanel(eventHandler), (Object)"Center");
                mJPanel.add((Component)this.callbackPanel(eventHandler), (Object)"South");
                this.add((Component)mJPanel, "North");
                break;
            }
            case 2: {
                this.setName("contextMenuPropertyPanel");
                this.setBorder(BorderFactory.createTitledBorder(MenuEditorUtils.getResource("groupbox.UIContextMenu")));
                EventHandler eventHandler = new EventHandler();
                MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout(0, 8));
                mJPanel.add((Component)this.stringsPanel(n, eventHandler));
                mJPanel.add((Component)this.callbackPanel(eventHandler), (Object)"South");
                this.add((Component)mJPanel, "North");
                break;
            }
            default: {
                this.setName("nonePropertyPanel");
                this.setBorder(BorderFactory.createTitledBorder(MenuEditorUtils.getResource("groupbox.NoSelection")));
                MJLabel mJLabel = new MJLabel(MenuEditorUtils.getResource("label.NoSelection"));
                this.add((Component)mJLabel, "North");
            }
        }
    }

    protected void synchToNode(MenuTreeNode menuTreeNode, MenuNode menuNode) {
        this.fTreeNode = menuTreeNode;
        this.fNode = menuNode;
        if (this.fNode != null) {
            if (this.fLabelField != null && !this.fLabelField.getText().equals(this.fNode.getLabel())) {
                this.fLabelField.setText(this.fNode.getLabel());
            }
            if (this.fTagField != null && !this.fTagField.getText().equals(this.fNode.getTag())) {
                this.fTagField.setText(this.fNode.getTag());
            }
            if (this.fSeparatorCBox != null) {
                this.fSeparatorCBox.setSelected(this.fNode.getSeparator());
            }
            if (this.fCheckedCBox != null) {
                this.fCheckedCBox.setSelected(this.fNode.getChecked());
            }
            if (this.fEnabledCBox != null) {
                this.fEnabledCBox.setSelected(this.fNode.getEnabled());
            }
            if (this.fCallbackField != null) {
                if (!this.fCallbackField.getText().equals(this.fNode.getCallback())) {
                    this.fCallbackField.setText(this.fNode.getCallback());
                }
                this.fCallbackField.updateUI();
            }
            if (this.fAcceleratorCombo != null) {
                this.fAcceleratorCombo.setSelectedItem((Object)this.fNode.getAccelerator());
            }
        }
    }

    public MJPanel getAccelPanel() {
        return this.fAccelPanel;
    }

    public MJPanel getCheckboxPanel() {
        return this.fCheckboxPanel;
    }

    public void enableAcceleratorPanel(boolean bl) {
        this.fAcceleratorLabel.setEnabled(bl);
        this.fAcceleratorCombo.setEnabled(bl);
    }

    private void commitButton(Object object) {
        if (this.fNode != null) {
            if (object.equals(this.fMoreOptions)) {
                this.fNode.inspectMenuProperty();
            } else if (object.equals(this.fViewCallback)) {
                this.fNode.editCallback(this.fEditor);
            }
        }
    }

    private MJPanel stringsPanel(int n, EventHandler eventHandler) {
        MJLabel mJLabel;
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout(4, 0));
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new GridLayout(0, 1, 0, 8));
        MJPanel mJPanel3 = new MJPanel((LayoutManager)new GridLayout(0, 1, 0, 8));
        if (n == 1) {
            mJLabel = new MJLabel(MenuEditorUtils.getResource("label.menuLabel"));
            this.fLabelField = new MJTextField("fieldLabel");
            this.fLabelField.setName("fieldLabel");
            this.fLabelField.addActionListener((ActionListener)eventHandler);
            this.fLabelField.addFocusListener((FocusListener)eventHandler);
            mJPanel2.add((Component)mJLabel);
            mJPanel3.add((Component)this.fLabelField);
        }
        mJLabel = new MJLabel(MenuEditorUtils.getResource("label.menuTag"));
        this.fTagField = new MJTextField("fieldTag");
        this.fTagField.setName("fieldTag");
        this.fTagField.addActionListener((ActionListener)eventHandler);
        this.fTagField.addFocusListener((FocusListener)eventHandler);
        this.fTagField.setToolTipText(MenuEditorUtils.getResource("tip.tagField"));
        mJPanel2.add((Component)mJLabel);
        mJPanel3.add((Component)this.fTagField);
        mJPanel.add((Component)mJPanel2, (Object)"West");
        mJPanel.add((Component)mJPanel3, (Object)"Center");
        return mJPanel;
    }

    private MJPanel checkboxaccleratorPanel(EventHandler eventHandler) {
        MJPanel mJPanel = new MJPanel((LayoutManager)new GridLayout(4, 1, 0, 8));
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel2.setName("acceleratorPanel");
        this.fSeparatorCBox = new MJCheckBox(MenuEditorUtils.getResource("checkbox.Separator"));
        this.fSeparatorCBox.addItemListener((ItemListener)eventHandler);
        this.fSeparatorCBox.setName("checkboxSeparator");
        this.fCheckedCBox = new MJCheckBox(MenuEditorUtils.getResource("checkbox.Checked"));
        this.fCheckedCBox.addItemListener((ItemListener)eventHandler);
        this.fCheckedCBox.setName("checkboxChecked");
        this.fEnabledCBox = new MJCheckBox(MenuEditorUtils.getResource("checkbox.Enabled"));
        this.fEnabledCBox.addItemListener((ItemListener)eventHandler);
        this.fEnabledCBox.setName("checkboxEnabled");
        this.fAcceleratorCombo = new MJComboBox((Object[])MenuPropertyPanel.getAcceleratorAlphabet());
        this.fAcceleratorCombo.setRenderer((ListCellRenderer)new AcceleratorComboRenderer());
        this.fAcceleratorCombo.setSelectedIndex(0);
        this.fAcceleratorCombo.setName("comboboxAccelerator");
        this.fAcceleratorLabel = new MJLabel(MenuEditorUtils.getResource("combo.accelerator"));
        this.fAcceleratorLabel.setName("labelAccelerator");
        this.fAcceleratorCombo.addActionListener((ActionListener)eventHandler);
        mJPanel2.add((Component)this.fAcceleratorLabel, (Object)"West");
        mJPanel2.add((Component)this.fAcceleratorCombo, (Object)"Center");
        mJPanel.add((Component)mJPanel2);
        mJPanel.add((Component)this.fSeparatorCBox);
        mJPanel.add((Component)this.fCheckedCBox);
        mJPanel.add((Component)this.fEnabledCBox);
        this.fAccelPanel = mJPanel2;
        this.fCheckboxPanel = mJPanel;
        return mJPanel;
    }

    private static String[] getAcceleratorAlphabet() {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("");
        char c = 'A';
        int n2 = Character.getNumericValue(c);
        for (n = 0; n < 26; ++n) {
            arrayList.add(new String(new char[]{Character.toUpperCase(Character.forDigit(n2 + n, 36))}));
        }
        for (n = 0; n <= 9; ++n) {
            arrayList.add(String.valueOf(n));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private MJPanel callbackPanel(EventHandler eventHandler) {
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout(0, 4));
        MJLabel mJLabel = new MJLabel(MenuEditorUtils.getResource("label.menuCallback"));
        this.fCallbackField = new MJTextField("fieldCallback");
        this.fCallbackField.setName("fieldCallback");
        this.fCallbackField.setPreferredSize(new Dimension(150, this.fCallbackField.getPreferredSize().height));
        this.fCallbackField.addActionListener((ActionListener)eventHandler);
        this.fCallbackField.addFocusListener((FocusListener)eventHandler);
        this.fViewCallback = new MJButton(MenuEditorUtils.getResource("button.viewCallback"));
        this.fViewCallback.setName("buttonViewCallback");
        this.fViewCallback.addActionListener((ActionListener)eventHandler);
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new FlowLayout(2, 0, 10));
        this.fMoreOptions = new MJButton(MenuEditorUtils.getResource("button.moreOptions"));
        this.fMoreOptions.setName("buttonMoreOptions");
        this.fMoreOptions.addActionListener((ActionListener)eventHandler);
        mJPanel2.add((Component)this.fMoreOptions);
        mJPanel.add((Component)mJLabel, (Object)"West");
        mJPanel.add((Component)this.fViewCallback, (Object)"East");
        mJPanel.add((Component)this.fCallbackField, (Object)"Center");
        mJPanel.add((Component)mJPanel2, (Object)"South");
        return mJPanel;
    }

    private class EventHandler
    extends FocusAdapter
    implements ActionListener,
    ItemListener {
        private EventHandler() {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                this.commitText(focusEvent.getSource());
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.commitText(actionEvent.getSource());
            MenuPropertyPanel.this.commitButton(actionEvent.getSource());
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (MenuPropertyPanel.this.fNode != null) {
                if (itemEvent.getSource().equals(MenuPropertyPanel.this.fSeparatorCBox)) {
                    MenuPropertyPanel.this.fNode.setSeparator(MenuPropertyPanel.this.fSeparatorCBox.isSelected());
                } else if (itemEvent.getSource().equals(MenuPropertyPanel.this.fCheckedCBox)) {
                    MenuPropertyPanel.this.fNode.setChecked(MenuPropertyPanel.this.fCheckedCBox.isSelected());
                } else if (itemEvent.getSource().equals(MenuPropertyPanel.this.fEnabledCBox)) {
                    MenuPropertyPanel.this.fNode.setEnabled(MenuPropertyPanel.this.fEnabledCBox.isSelected());
                }
            }
        }

        private void commitText(Object object) {
            if (MenuPropertyPanel.this.fNode != null) {
                if (object.equals(MenuPropertyPanel.this.fLabelField)) {
                    MenuPropertyPanel.this.fNode.setLabel(MenuPropertyPanel.this.fLabelField.getText());
                    if (MenuPropertyPanel.this.fTreeNode != null) {
                        MenuPropertyPanel.this.fEditor.fireNodeChange(MenuPropertyPanel.this.fTreeNode);
                    }
                } else if (object.equals(MenuPropertyPanel.this.fAcceleratorCombo)) {
                    String string = (String)MenuPropertyPanel.this.fAcceleratorCombo.getSelectedItem();
                    MenuPropertyPanel.this.fNode.setAccelerator(string);
                } else if (object.equals(MenuPropertyPanel.this.fTagField)) {
                    MenuPropertyPanel.this.fNode.setTag(MenuPropertyPanel.this.fTagField.getText());
                    if (MenuPropertyPanel.this.fTreeNode != null) {
                        MenuPropertyPanel.this.fEditor.fireNodeChange(MenuPropertyPanel.this.fTreeNode);
                    }
                } else if (object.equals(MenuPropertyPanel.this.fCallbackField)) {
                    MenuPropertyPanel.this.fNode.setCallback(MenuPropertyPanel.this.fCallbackField.getText());
                }
            }
        }
    }

    private static class AcceleratorComboRenderer
    extends DefaultListCellRenderer {
        private AcceleratorComboRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            jLabel.setComponentOrientation(jList.getComponentOrientation());
            if (bl) {
                jLabel.setBackground(jList.getSelectionBackground());
                jLabel.setForeground(jList.getSelectionForeground());
            } else {
                jLabel.setBackground(jList.getBackground());
                jLabel.setForeground(jList.getForeground());
            }
            if (object instanceof Icon) {
                jLabel.setIcon((Icon)object);
                jLabel.setText("");
            } else {
                jLabel.setIcon(null);
                jLabel.setText(object == null || object.equals("") ? COMBO_NONE : object.toString());
            }
            jLabel.setEnabled(jList.isEnabled());
            jLabel.setFont(jList.getFont());
            jLabel.setBorder(bl2 ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
            return jLabel;
        }
    }
}

