/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.objectbrowser;

import com.mathworks.common.icons.ControlIcon;
import com.mathworks.jmi.bean.UDDObject;
import com.mathworks.toolbox.matlab.guide.HGControl;
import java.awt.Component;
import java.awt.Image;
import java.beans.BeanInfo;
import java.beans.Introspector;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ObjectNodeUtils {
    private ObjectNodeUtils() {
    }

    public static String getObjectName(Object object) {
        String string = "";
        if (object == null) {
            return string;
        }
        if (object instanceof Component) {
            Component component = (Component)object;
            string = component.getName();
        }
        if (string == null || string.length() == 0) {
            string = ObjectNodeUtils.getBeanName(object);
        }
        return string;
    }

    private static String getBeanName(Object object) {
        String string;
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(object.getClass());
        }
        catch (Exception exception) {
            beanInfo = null;
        }
        if (beanInfo != null) {
            string = beanInfo.getBeanDescriptor().getDisplayName();
        } else {
            string = object.getClass().getName();
            string = string.substring(string.lastIndexOf(46) + 1);
        }
        if (object instanceof Component) {
            String string2 = ((Component)object).getName();
            if (string2 != null && string2.length() > 0) {
                string = string + " (" + string2 + ')';
            }
        } else if (object instanceof UDDObject) {
            UDDObject uDDObject = (UDDObject)object;
            string = HGControl.getDisplayTextForControl(string, uDDObject);
        }
        return string;
    }

    public static Icon getObjectIcon(Object object) {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(object.getClass());
        }
        catch (Exception exception) {
            beanInfo = null;
        }
        Icon icon = null;
        if (beanInfo != null && object instanceof UDDObject) {
            Image image;
            UDDObject uDDObject = (UDDObject)object;
            String string = beanInfo.getBeanDescriptor().getDisplayName();
            icon = HGControl.getDisplayIconForControl(string, uDDObject);
            if (icon == null && (image = beanInfo.getIcon(1)) != null) {
                icon = new ImageIcon(image);
            }
        }
        if (icon == null) {
            icon = ControlIcon.UNKNOWN.getIcon();
        }
        return icon;
    }
}

