/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.palette;

import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolbox.matlab.guide.palette.MObjectProxy;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.util.ArrayList;
import javax.swing.BorderFactory;

public class DefaultProxy
extends MJPanel {
    private MObjectProxy fOwningProxy;
    private boolean fDrawDecoration;
    private static DefaultProxy sDefaultProxy = new DefaultProxy(null, false);

    public DefaultProxy(MObjectProxy mObjectProxy) {
        this(mObjectProxy, false);
    }

    public DefaultProxy(MObjectProxy mObjectProxy, boolean bl) {
        this.setPreferredSize(new Dimension(200, 150));
        this.setOwningProxy(mObjectProxy);
        this.setDrawDecoration(bl);
    }

    public static DefaultProxy getInstance() {
        return sDefaultProxy;
    }

    void setDrawDecoration(boolean bl) {
        this.fDrawDecoration = bl;
        this.setOpaque(this.fDrawDecoration);
        if (this.fDrawDecoration) {
            this.setBorder(BorderFactory.createLineBorder(Color.black));
        } else {
            this.setBorder(BorderFactory.createEmptyBorder());
        }
    }

    void setOwningProxy(MObjectProxy mObjectProxy) {
        this.fOwningProxy = mObjectProxy;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.fDrawDecoration) {
            Dimension dimension = this.getSize();
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(Color.black);
            graphics.drawLine(0, 0, dimension.width, dimension.height);
            graphics.drawLine(0, dimension.height, dimension.width, 0);
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
            Font font = graphics.getFont();
            graphics.setFont(this.fOwningProxy.getFont());
            ArrayList<String> arrayList = this.fOwningProxy.getDisplayStrings();
            for (int i = 0; i < arrayList.size(); ++i) {
                graphics.drawString(arrayList.get(i), dimension.width * 1 / 2 - this.getFontMetrics(this.getFont()).stringWidth(arrayList.get(i)) / 2, dimension.height * 1 / 3 + i * (this.getFontMetrics(this.getFont()).getHeight() + 5));
            }
            graphics.setFont(font);
        }
    }
}

