/*
 * Decompiled with CFR 0.152.
 */
package net.jini.core.constraint;

import [Lnet.jini.core.constraint.InvocationConstraint;;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import net.jini.core.constraint.ArraySet;
import net.jini.core.constraint.Constraint;
import net.jini.core.constraint.InvocationConstraint;
import net.jini.core.constraint.RelativeTimeConstraint;

public final class ConstraintAlternatives
implements RelativeTimeConstraint,
Serializable {
    private static final long serialVersionUID = 7214615235302870613L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("constraints", InvocationConstraint;.class, true)};
    private final InvocationConstraint[] constraints;
    private transient boolean rel = false;

    public ConstraintAlternatives(InvocationConstraint[] invocationConstraintArray) {
        this.constraints = ConstraintAlternatives.reduce((InvocationConstraint[])invocationConstraintArray.clone());
        this.setRelative();
    }

    public ConstraintAlternatives(Collection collection) {
        try {
            this.constraints = ConstraintAlternatives.reduce(collection.toArray(new InvocationConstraint[collection.size()]));
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new IllegalArgumentException("element of collection is not an InvocationConstraint");
        }
        this.setRelative();
    }

    public static InvocationConstraint create(InvocationConstraint[] invocationConstraintArray) {
        return ConstraintAlternatives.reduce((InvocationConstraint[])invocationConstraintArray.clone(), false);
    }

    public static InvocationConstraint create(Collection collection) {
        try {
            return ConstraintAlternatives.reduce(collection.toArray(new InvocationConstraint[collection.size()]), false);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new IllegalArgumentException("element of collection is not an InvocationConstraint");
        }
    }

    private ConstraintAlternatives(InvocationConstraint[] invocationConstraintArray, boolean bl) {
        this.constraints = invocationConstraintArray;
        if (!bl) {
            this.setRelative();
        }
    }

    private void setRelative() {
        int n = this.constraints.length;
        while (--n >= 0) {
            if (!(this.constraints[n] instanceof RelativeTimeConstraint)) continue;
            this.rel = true;
            return;
        }
    }

    boolean relative() {
        return this.rel;
    }

    private static InvocationConstraint reduce(InvocationConstraint[] invocationConstraintArray, boolean bl) {
        ConstraintAlternatives.verify(invocationConstraintArray, 1);
        int n = ConstraintAlternatives.reduce0(invocationConstraintArray);
        if (n == 1) {
            return invocationConstraintArray[0];
        }
        return new ConstraintAlternatives((InvocationConstraint[])Constraint.trim(invocationConstraintArray, n), bl);
    }

    private static void verify(InvocationConstraint[] invocationConstraintArray, int n) {
        if (invocationConstraintArray.length < n) {
            throw new IllegalArgumentException("cannot create constraint with " + (n == 1 ? "no" : "less than " + n) + " elements");
        }
        int n2 = invocationConstraintArray.length;
        while (--n2 >= 0) {
            InvocationConstraint invocationConstraint = invocationConstraintArray[n2];
            if (invocationConstraint == null) {
                throw new NullPointerException("elements cannot be null");
            }
            if (!(invocationConstraint instanceof ConstraintAlternatives)) continue;
            throw new IllegalArgumentException("elements cannot be ConstraintAlternatives instances");
        }
    }

    private static InvocationConstraint[] reduce(InvocationConstraint[] invocationConstraintArray) {
        ConstraintAlternatives.verify(invocationConstraintArray, 2);
        int n = ConstraintAlternatives.reduce0(invocationConstraintArray);
        if (n == 1) {
            throw new IllegalArgumentException("reduced to less than 2 elements");
        }
        return (InvocationConstraint[])Constraint.trim(invocationConstraintArray, n);
    }

    private static int reduce0(InvocationConstraint[] invocationConstraintArray) {
        int n = 0;
        for (int i = 0; i < invocationConstraintArray.length; ++i) {
            InvocationConstraint invocationConstraint = invocationConstraintArray[i];
            if (Constraint.contains(invocationConstraintArray, n, invocationConstraint)) continue;
            invocationConstraintArray[n++] = invocationConstraint;
        }
        return n;
    }

    public Set elements() {
        return new ArraySet(this.constraints);
    }

    InvocationConstraint[] getConstraints() {
        return this.constraints;
    }

    public InvocationConstraint makeAbsolute(long l) {
        if (!this.rel) {
            return this;
        }
        InvocationConstraint[] invocationConstraintArray = new InvocationConstraint[this.constraints.length];
        int n = invocationConstraintArray.length;
        while (--n >= 0) {
            InvocationConstraint invocationConstraint = this.constraints[n];
            if (invocationConstraint instanceof RelativeTimeConstraint) {
                invocationConstraint = ((RelativeTimeConstraint)invocationConstraint).makeAbsolute(l);
            }
            invocationConstraintArray[n] = invocationConstraint;
        }
        return ConstraintAlternatives.reduce(invocationConstraintArray, true);
    }

    public int hashCode() {
        return Constraint.hash(this.constraints);
    }

    public boolean equals(Object object) {
        return object instanceof ConstraintAlternatives && Constraint.equal(this.constraints, ((ConstraintAlternatives)object).constraints);
    }

    public String toString() {
        return "ConstraintAlternatives" + Constraint.toString(this.constraints);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.constraints == null) {
            throw new InvalidObjectException("cannot create constraint with no elements");
        }
        try {
            ConstraintAlternatives.verify(this.constraints, 2);
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException instanceof NullPointerException || runtimeException instanceof IllegalArgumentException) {
                InvalidObjectException invalidObjectException = new InvalidObjectException(runtimeException.getMessage());
                invalidObjectException.initCause(runtimeException);
                throw invalidObjectException;
            }
            throw runtimeException;
        }
        int n = this.constraints.length;
        while (--n >= 0) {
            if (!Constraint.contains(this.constraints, n, this.constraints[n])) continue;
            throw new InvalidObjectException("cannot create constraint with duplicate elements");
        }
        this.setRelative();
    }
}

