/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter;

import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.toolbox.distcomp.admincenter.TestDataAccessor;
import com.mathworks.toolbox.distcomp.admincenter.TestDataViewer;
import com.mathworks.toolbox.distcomp.admincenter.guiutilities.ACHelpButtonFactory;
import com.mathworks.toolbox.distcomp.admincenter.resources.ResourceStatics;
import com.mathworks.toolbox.distcomp.admincenter.services.model.UpdateTimer;
import com.mathworks.toolbox.distcomp.admincenter.testing.model.ClusterData;
import com.mathworks.toolbox.distcomp.admincenter.testing.view.TestResultsView;
import com.mathworks.toolbox.distcomp.admincenter.testing.view.TestRunnerUI;
import com.mathworks.toolbox.distcomp.ui.panel.AbstractStyleGuidePanel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuidePanel;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;

public class TestResultsDialog
extends MJDialog {
    private static final String HELP = "AC_CONN_TESTING";
    private final TestDataAccessor fAccessor;
    private final TestRunnerUI fRunner;
    private final UpdateTimer fUpdateTimer;
    private boolean fDataHasChanged = true;
    private final Object fDataChangeLock = new Object();
    private AbstractStyleGuidePanel fResultsPanel;
    private MJLabel fNoTestResultsLabel;
    private static final int DEFAULT_WIDTH = 700;
    private static final int DEFAULT_HEIGHT = 600;

    public TestResultsDialog(MJFrame mJFrame, TestDataAccessor testDataAccessor, UpdateTimer updateTimer) {
        super((Frame)mJFrame, ResourceStatics.sRes.getString("results.dialog.title"), false);
        this.fUpdateTimer = updateTimer;
        this.fRunner = new TestRunnerUI((Frame)mJFrame);
        this.fAccessor = testDataAccessor;
        this.fNoTestResultsLabel = new MJLabel(ResourceStatics.sRes.getString("results.dialog.blank"));
        this.fNoTestResultsLabel.setFont(this.fNoTestResultsLabel.getFont().deriveFont(18.0f));
        this.fNoTestResultsLabel.setHorizontalAlignment(0);
        this.fResultsPanel = new StyleGuidePanel();
        this.fResultsPanel.addLine((JComponent)this.fNoTestResultsLabel, 8);
        this.setDefaultCloseOperation(1);
        this.fAccessor.setTestDataViewer(new TestDataViewer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void testDataChanged() {
                Object object = TestResultsDialog.this.fDataChangeLock;
                synchronized (object) {
                    TestResultsDialog.this.fDataHasChanged = true;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TestResultsDialog.this.showChanges();
                        }
                    });
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                TestResultsDialog.this.showChanges();
            }
        });
        JComponent jComponent = (JComponent)this.getGlassPane();
        jComponent.addMouseListener(new MouseAdapter(){});
        jComponent.setCursor(new Cursor(3));
        MJButton mJButton = new MJButton(ResourceStatics.sRes.getString("services.dialog.run"));
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestResultsDialog.this.getGlassPane().setVisible(true);
                TestResultsDialog.this.fUpdateTimer.scheduleTask(TestResultsDialog.this.createRunTask());
            }
        });
        this.getRootPane().setDefaultButton((JButton)mJButton);
        JButton jButton = ACHelpButtonFactory.createHelpButton(HELP, "ConnectivityTestingDialog.HelpButton");
        MJButton mJButton2 = new MJButton(ResourceStatics.sRes.getString("services.dialog.close"));
        mJButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestResultsDialog.this.hide();
            }
        });
        StyleGuidePanel styleGuidePanel = new StyleGuidePanel();
        styleGuidePanel.addLine((JComponent)((Object)this.fResultsPanel), 8);
        styleGuidePanel.addLine((JComponent[][])new JComponent[][]{{null, mJButton, mJButton2, jButton}}, 0, 0);
        this.setContentPane((Container)((Object)styleGuidePanel));
        this.setName("TestConnectivityDialog");
        mJButton2.setName("TestConnectivityDialog.CloseButton");
        mJButton.setName("TestConnectivityDialog.RunButton");
        this.setSize(700, 600);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showChanges() {
        Object object = this.fDataChangeLock;
        synchronized (object) {
            if (!this.fDataHasChanged || !this.isShowing()) {
                return;
            }
            ClusterData clusterData = this.fAccessor.getTestData();
            this.fResultsPanel.removeAll();
            Object object2 = clusterData == null || clusterData.getTestResultsContainer() == null ? this.fNoTestResultsLabel : new TestResultsView((JDialog)((Object)this), clusterData);
            this.fResultsPanel.addLine((JComponent)object2, 8);
            this.fResultsPanel.invalidate();
            this.fDataHasChanged = false;
        }
    }

    private Runnable createRunTask() {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            TestResultsDialog.this.getGlassPane().setVisible(false);
                            ClusterData clusterData = TestResultsDialog.this.fAccessor.getTestData();
                            if (TestResultsDialog.this.fRunner.doRun(clusterData)) {
                                TestResultsDialog.this.fAccessor.setTestData(clusterData);
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }
}

