/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.guiutilities;

import com.mathworks.html.PageChangedEvent;
import com.mathworks.html.PageChangedListener;
import com.mathworks.jmi.Matlab;
import com.mathworks.mlwidgets.help.HelpPanel;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mlwidgets.html.HTMLUtils;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.toolbox.distcomp.admincenter.guiutilities.PackageInfo;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.util.ResourceBundleUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FilenameUtils;

public class ACHelpBrowser {
    private static final String MAP_FILE = "mdce.map";
    private static ACHelpBrowser sReusableBrowser = new ACHelpBrowser();
    private static final String DEFAULT_TITLE = ResourceBundleUtilities.getInstance(ACHelpBrowser.class).getString("help.title.default", new Object[0]);
    private MJDialog fHelpDialog;
    private HelpPanel fHelpPanel;
    private Dimension fSize;
    private Point fLocation;
    private static final Dimension DEFAULT_SIZE = new Dimension(400, 400);
    private static final Point DEFAULT_LOCATION = new Point(20, 40);

    public static void browseToShortcut(Component component, String string) {
        sReusableBrowser.showHelpShortcut(component, string);
    }

    private void showHelpShortcut(Component component, String string) {
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "Browsing to the shortcut" + string);
        this.resetDialog(component);
        this.fHelpPanel.displayTopic(ACHelpBrowser.getMapPath(), string);
        this.fHelpDialog.setVisible(true);
    }

    public static boolean isBrowserOpen() {
        return ACHelpBrowser.sReusableBrowser.fHelpDialog != null && ACHelpBrowser.sReusableBrowser.fHelpDialog.isVisible();
    }

    private static String getMapPath() {
        return FilenameUtils.separatorsToSystem((String)(ACHelpBrowser.getDocroot() + "/mdce/" + MAP_FILE));
    }

    private static String getDocroot() {
        if (Matlab.isMatlabAvailable()) {
            return HelpPrefs.getDocRoot();
        }
        return System.getProperty("matlabroot") + "/help";
    }

    private void resetDialog(Component component) {
        if (!(component instanceof Dialog) && !(component instanceof Frame)) {
            component = SwingUtilities.windowForComponent(component);
        }
        if (this.fHelpDialog == null || !this.fHelpDialog.isVisible() || component != this.fHelpDialog.getOwner()) {
            if (this.fHelpDialog != null) {
                this.fHelpDialog.remove((Component)this.fHelpPanel);
                this.fHelpDialog.dispose();
                this.fHelpDialog = null;
            }
            this.fHelpDialog = component == null ? new HelpDialog() : (component instanceof Dialog ? new HelpDialog((Dialog)component) : new HelpDialog((Frame)component));
            this.fHelpDialog.addComponentListener((ComponentListener)new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    ACHelpBrowser.this.saveDialogInfo();
                }

                @Override
                public void componentMoved(ComponentEvent componentEvent) {
                    ACHelpBrowser.this.saveDialogInfo();
                }
            });
            if (this.fSize == null) {
                this.fSize = DEFAULT_SIZE;
            }
            if (this.fLocation == null && component == null) {
                this.fLocation = DEFAULT_LOCATION;
            }
            this.fHelpDialog.setLayout((LayoutManager)new BorderLayout());
            this.fHelpDialog.add((Component)this.getHelpPanel(), (Object)"Center");
            this.fHelpDialog.setTitle(DEFAULT_TITLE);
            this.fHelpDialog.setSize(this.fSize);
            if (this.fLocation == null) {
                this.fHelpDialog.setLocationRelativeTo(component);
                this.fLocation = this.fHelpDialog.getLocation();
            } else {
                this.fHelpDialog.setLocation(this.fLocation);
            }
            this.fHelpDialog.addWindowListener((WindowListener)new HelpDialogWindowListener());
            this.fHelpDialog.setName("acHelpDialog");
        }
    }

    private HelpPanel getHelpPanel() {
        if (this.fHelpPanel == null) {
            this.fHelpPanel = new HelpPanel();
            this.fHelpPanel.getHTMLRenderer().addPageChangedListener(new PageChangedListener(){

                public void pageChanged(PageChangedEvent pageChangedEvent) {
                    if (ACHelpBrowser.this.fHelpDialog != null) {
                        String string = pageChangedEvent.getTitle();
                        String string2 = pageChangedEvent.getFullUrl();
                        if (string == null || "".equals(string.trim()) || string2 != null && string2.equals(HTMLUtils.getFilenameFromURL((String)string))) {
                            string = DEFAULT_TITLE;
                        }
                        ACHelpBrowser.this.fHelpDialog.setTitle(string);
                    }
                }
            });
        }
        return this.fHelpPanel;
    }

    private void saveDialogInfo() {
        assert (this.fHelpDialog != null) : "Cannot save dialog rect: it is null.";
        this.fSize = this.fHelpDialog.getSize();
        this.fLocation = this.fHelpDialog.getLocation();
    }

    private static class HelpDialog
    extends MJDialog {
        private boolean fHiding = false;

        private HelpDialog() {
        }

        private HelpDialog(Frame frame) {
            super(frame);
        }

        private HelpDialog(Dialog dialog) {
            super(dialog);
        }

        public void show() {
            if (this.fHiding) {
                return;
            }
            super.show();
        }

        @Deprecated
        public void hide() {
            super.hide();
            this.fHiding = true;
        }

        public void dispose() {
            super.dispose();
            try {
                ((Object)((Object)this)).finalize();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private class HelpDialogWindowListener
    extends WindowAdapter {
        private HelpDialogWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            ACHelpBrowser.this.fHelpPanel.setCurrentLocation("about:blank");
        }
    }
}

