/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.services.action;

import com.mathworks.toolbox.distcomp.admincenter.services.action.SystemErrorHandler;
import com.mathworks.toolbox.distcomp.admincenter.services.model.ClientMonitor;
import com.mathworks.toolbox.distcomp.admincenter.services.model.ServiceRequestException;
import com.mathworks.toolbox.distcomp.control.servicerequest.ServiceRequest;
import java.util.Collection;

public class ActionRequest {
    private final Collection<ServiceRequest> fServiceRequests;
    private final boolean fIsCancelled;
    private final ClientMonitor fMonitor;
    private final SystemErrorHandler fErrorHandler;

    public ActionRequest(ClientMonitor clientMonitor, boolean bl, Collection<ServiceRequest> collection, SystemErrorHandler systemErrorHandler) {
        assert (clientMonitor != null) : "Monitor may not be null.";
        assert (systemErrorHandler != null) : "ErrorHandler may not be null.";
        this.fMonitor = clientMonitor;
        this.fIsCancelled = bl;
        this.fServiceRequests = collection;
        this.fErrorHandler = systemErrorHandler;
    }

    public final Collection<ServiceRequest> getServiceRequests() {
        return this.fServiceRequests;
    }

    public final boolean isUserCancelled() {
        return this.fIsCancelled;
    }

    public void startUpdate() {
        try {
            this.fMonitor.startUpdate(true);
        }
        catch (ServiceRequestException serviceRequestException) {
            this.getErrorHandler().handleError(serviceRequestException);
        }
    }

    public UpdateAction getUpdateAction() {
        return UpdateAction.UPDATE;
    }

    protected SystemErrorHandler getErrorHandler() {
        return this.fErrorHandler;
    }

    public static enum UpdateAction {
        UPDATE,
        ADD_HOSTS,
        REMOVE_HOSTS;

    }
}

