/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.services.action;

import com.mathworks.toolbox.distcomp.admincenter.services.action.TargetSource;
import com.mathworks.toolbox.distcomp.admincenter.services.action.TargetSourceListener;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceInfo;
import java.util.ArrayList;
import java.util.Collection;

public class AggregateTargetSource
extends TargetSource {
    private final TargetSource[] fTargetSources;

    public AggregateTargetSource(TargetSource ... targetSourceArray) {
        this.fTargetSources = targetSourceArray;
        TargetSourceListener targetSourceListener = new TargetSourceListener(){

            @Override
            public void targetUpdated(boolean bl) {
                AggregateTargetSource.this.fireTargetsChanges();
            }
        };
        for (TargetSource targetSource : targetSourceArray) {
            targetSource.addTargetSourceListener(targetSourceListener);
        }
    }

    @Override
    public Collection<ServiceInfo> getTargets() {
        ArrayList<ServiceInfo> arrayList = new ArrayList<ServiceInfo>();
        for (TargetSource targetSource : this.fTargetSources) {
            if (targetSource == null) continue;
            arrayList.addAll(targetSource.getTargets());
        }
        return arrayList;
    }

    @Override
    protected boolean areTargetsProper() {
        for (TargetSource targetSource : this.fTargetSources) {
            if (targetSource.areTargetsProper()) continue;
            return false;
        }
        return true;
    }
}

