/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.services.infra;

import com.mathworks.toolbox.distcomp.admincenter.TimeOutConstants;
import com.mathworks.toolbox.distcomp.admincenter.services.infra.JobRunner;
import com.mathworks.toolbox.distcomp.admincenter.services.infra.ServiceUpdate;
import com.mathworks.toolbox.distcomp.control.MDCSParameter;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.StatusRequest;
import com.mathworks.toolbox.distcomp.control.serviceinfo.StatusRequestResponse;
import com.mathworks.toolbox.distcomp.control.servicerequest.Host;
import com.mathworks.toolbox.distcomp.control.servicerequest.Request;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;

class Closure {
    private Map<String, String> fClosure = new HashMap<String, String>();
    private ExecutorService fExecutor;
    private int fRemoteCommandPort;

    Closure(ExecutorService executorService, int n) {
        this.fExecutor = executorService;
        this.fRemoteCommandPort = n;
    }

    ServiceUpdate compute(Set<Host> set) {
        ServiceUpdate serviceUpdate = new ServiceUpdate();
        LinkedList<Host> linkedList = new LinkedList<Host>(set);
        while (!linkedList.isEmpty()) {
            Object object;
            JobRunner<StatusRequestResponse> jobRunner = new JobRunner<StatusRequestResponse>(this.fExecutor);
            while (!linkedList.isEmpty()) {
                Host host = (Host)linkedList.remove(0);
                Object object2 = host.getHostname();
                if (!this.notInClosureYet((String)object2)) continue;
                this.fClosure.put((String)object2, null);
                object = new StatusRequest(host);
                ((Request)object).addParameterValue(MDCSParameter.REMOTE_COMMAND_PORT, this.fRemoteCommandPort);
                jobRunner.addNewTask((Callable<StatusRequestResponse>)object, ((StatusRequest)object).failedToExecute(null));
            }
            try {
                jobRunner.waitForCompletion(TimeOutConstants.CLOSURE_TASK_TIMEOUT_SECS);
            }
            catch (JobRunner.MDCSTimeoutException mDCSTimeoutException) {
                jobRunner.cancelAllTasks(mDCSTimeoutException);
            }
            for (Object object2 : jobRunner.getResults()) {
                boolean bl;
                object = new LinkedList<ServiceInfo>(((StatusRequestResponse)object2).getServiceInfos()).get(0);
                Host host = ((ServiceInfo)object).getHost();
                String string = host.getHostname();
                String string2 = host.getMDCSHostname();
                boolean bl2 = bl = string2 == null ? false : this.fClosure.containsValue(string2);
                if (bl) {
                    assert (this.fClosure.get(string) == null || this.fClosure.get(string).equals(string2)) : "Ambiguous MDCS hostnames (" + this.fClosure.get(string) + ", " + string2 + " for machine " + string;
                } else {
                    serviceUpdate.add(((StatusRequestResponse)object2).getServiceInfos());
                    for (String string3 : ((StatusRequestResponse)object2).getNodes()) {
                        if (!this.notInClosureYet(string3)) continue;
                        linkedList.add(new Host(string3));
                    }
                }
                this.fClosure.put(string, string2);
            }
        }
        return serviceUpdate;
    }

    private boolean notInClosureYet(String string) {
        return string != null && string.length() > 0 && !this.fClosure.containsKey(string) && !this.fClosure.containsValue(string);
    }
}

