/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.services.view;

import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.toolbox.distcomp.admincenter.resources.ResourceStatics;
import com.mathworks.toolbox.distcomp.admincenter.services.action.ActionRequest;
import com.mathworks.toolbox.distcomp.admincenter.services.action.ActionRequestCreator;
import com.mathworks.toolbox.distcomp.admincenter.services.action.ResponseHandler;
import com.mathworks.toolbox.distcomp.admincenter.services.action.ServiceAction;
import com.mathworks.toolbox.distcomp.admincenter.services.action.SystemErrorHandler;
import com.mathworks.toolbox.distcomp.admincenter.services.action.TargetSource;
import com.mathworks.toolbox.distcomp.admincenter.services.model.ClientMonitor;
import com.mathworks.toolbox.distcomp.admincenter.services.model.ServiceRequestException;
import com.mathworks.toolbox.distcomp.admincenter.services.model.StartMDCEWizardModel;
import com.mathworks.toolbox.distcomp.admincenter.services.model.SubmissionProgressListener;
import com.mathworks.toolbox.distcomp.admincenter.services.model.UpdateProgressListener;
import com.mathworks.toolbox.distcomp.admincenter.services.model.UpdateVetoer;
import com.mathworks.toolbox.distcomp.admincenter.services.view.AddHostsConfirmDialog;
import com.mathworks.toolbox.distcomp.admincenter.services.view.AddHostsDialog;
import com.mathworks.toolbox.distcomp.admincenter.services.view.wizard.StartMDCEWizardDialog;
import com.mathworks.toolbox.distcomp.control.serviceinfo.JobManagerServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.MDCSServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceStatus;
import com.mathworks.toolbox.distcomp.control.serviceinfo.WorkerServiceInfo;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

class AddHostsAction
extends ServiceAction {
    AddHostsAction(TargetSource targetSource, String string, ResponseHandler responseHandler, ClientMonitor clientMonitor, SubmissionProgressListener submissionProgressListener, SystemErrorHandler systemErrorHandler) {
        super(ResourceStatics.sRes.getString("module.hosts.action.add"), targetSource, string, new AddHostsRequestCreator(), responseHandler, clientMonitor, submissionProgressListener, systemErrorHandler);
    }

    private static class AddHostsRequestCreator
    implements ActionRequestCreator {
        private AddHostsRequestCreator() {
        }

        @Override
        public ActionRequest createActionServiceRequest(ActionEvent actionEvent, final ClientMonitor clientMonitor, TargetSource targetSource, final SystemErrorHandler systemErrorHandler) {
            final AddHostsDialog addHostsDialog = new AddHostsDialog(MJAbstractAction.getFrame((ActionEvent)actionEvent));
            addHostsDialog.pack();
            addHostsDialog.setLocationRelativeTo(addHostsDialog.getOwner());
            addHostsDialog.show();
            if (addHostsDialog.isCancelled()) {
                return new ActionRequest(clientMonitor, true, null, systemErrorHandler);
            }
            final String[] stringArray = (String[])addHostsDialog.getValue();
            return new ActionRequest(clientMonitor, false, null, systemErrorHandler){

                @Override
                public void startUpdate() {
                    try {
                        clientMonitor.addHosts(Arrays.asList(stringArray), new AddHostsVetoer(addHostsDialog, clientMonitor, stringArray));
                    }
                    catch (ServiceRequestException serviceRequestException) {
                        systemErrorHandler.handleError(serviceRequestException);
                    }
                }

                @Override
                public ActionRequest.UpdateAction getUpdateAction() {
                    return ActionRequest.UpdateAction.ADD_HOSTS;
                }
            };
        }

        private class AddHostsVetoer
        implements UpdateVetoer {
            private final AddHostsDialog fAddHostsDialog;
            private final ClientMonitor fMonitor;
            private final String[] fRequestedHosts;

            AddHostsVetoer(AddHostsDialog addHostsDialog, ClientMonitor clientMonitor, String[] stringArray) {
                this.fAddHostsDialog = addHostsDialog;
                this.fMonitor = clientMonitor;
                this.fRequestedHosts = stringArray;
            }

            @Override
            public boolean isUpdateOkay(Collection<ServiceInfo> collection) {
                List list = this.fMonitor.getHostTableModel().getInfoList();
                List list2 = this.fMonitor.getJobManagerTableModel().getInfoList();
                List list3 = this.fMonitor.getWorkerTableModel().getInfoList();
                final ArrayList<MDCSServiceInfo> arrayList = new ArrayList<MDCSServiceInfo>();
                ArrayList<JobManagerServiceInfo> arrayList2 = new ArrayList<JobManagerServiceInfo>();
                ArrayList<WorkerServiceInfo> arrayList3 = new ArrayList<WorkerServiceInfo>();
                for (ServiceInfo object : collection) {
                    if (object instanceof MDCSServiceInfo && !list.contains(object)) {
                        arrayList.add((MDCSServiceInfo)object);
                        continue;
                    }
                    if (object instanceof JobManagerServiceInfo && !list2.contains(object)) {
                        arrayList2.add((JobManagerServiceInfo)object);
                        continue;
                    }
                    if (!(object instanceof WorkerServiceInfo) || list3.contains(object)) continue;
                    arrayList3.add((WorkerServiceInfo)object);
                }
                if (this.fAddHostsDialog.shouldLaunchStartMdceServiceWizard()) {
                    this.fMonitor.addUpdateProgressListener(new UpdateProgressListener(){

                        @Override
                        public void updateStarted(boolean bl) {
                        }

                        @Override
                        public void updateFinished(boolean bl) {
                            AddHostsVetoer.this.fMonitor.removeUpdateProgressListener(this);
                            ArrayList<String> arrayList2 = new ArrayList<String>();
                            for (Object object : arrayList) {
                                if (!object.getStatus().equals((Object)ServiceStatus.UNKNOWN) || !object.isHostResolvable()) continue;
                                arrayList2.add(object.getHostName());
                            }
                            if (!arrayList2.isEmpty()) {
                                boolean bl2;
                                Object object;
                                StartMDCEWizardModel startMDCEWizardModel = new StartMDCEWizardModel(arrayList2, AddHostsVetoer.this.fMonitor.getBaseport());
                                object = new StartMDCEWizardDialog(startMDCEWizardModel);
                                object.setLocationRelativeTo(AddHostsVetoer.this.fAddHostsDialog.getParent());
                                object.setVisible(true);
                                boolean bl3 = bl2 = object.getDialogResult() == -1;
                                if (!bl2) {
                                    try {
                                        AddHostsVetoer.this.fMonitor.startUpdate(true);
                                    }
                                    catch (ServiceRequestException serviceRequestException) {
                                        // empty catch block
                                    }
                                }
                            }
                        }

                        @Override
                        public void updateFinishing() {
                        }
                    });
                }
                HashSet<String> hashSet = new HashSet<String>(Arrays.asList(this.fRequestedHosts));
                for (MDCSServiceInfo mDCSServiceInfo : arrayList) {
                    if (hashSet.contains(mDCSServiceInfo.getHostName())) continue;
                    return this.showConfirmDialog(arrayList, arrayList2, arrayList3);
                }
                return true;
            }

            private boolean showConfirmDialog(ArrayList<MDCSServiceInfo> arrayList, ArrayList<JobManagerServiceInfo> arrayList2, ArrayList<WorkerServiceInfo> arrayList3) {
                AddHostsConfirmDialog addHostsConfirmDialog = new AddHostsConfirmDialog((Frame)this.fAddHostsDialog.getOwner(), arrayList, arrayList2, arrayList3);
                addHostsConfirmDialog.pack();
                addHostsConfirmDialog.setLocationRelativeTo(this.fAddHostsDialog.getOwner());
                addHostsConfirmDialog.show();
                return !addHostsConfirmDialog.isCancelled();
            }
        }
    }
}

