/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.services.view;

import com.mathworks.mwswing.MJDialog;
import com.mathworks.toolbox.distcomp.admincenter.resources.ResourceStatics;
import com.mathworks.toolbox.distcomp.admincenter.services.action.AggregateTargetSource;
import com.mathworks.toolbox.distcomp.admincenter.services.action.ModuleAction;
import com.mathworks.toolbox.distcomp.admincenter.services.model.ClientMonitor;
import com.mathworks.toolbox.distcomp.admincenter.services.model.HostTableModel;
import com.mathworks.toolbox.distcomp.admincenter.services.model.Hostname;
import com.mathworks.toolbox.distcomp.admincenter.services.view.AddHostsAction;
import com.mathworks.toolbox.distcomp.admincenter.services.view.DelistHostsAction;
import com.mathworks.toolbox.distcomp.admincenter.services.view.HostnameRenderer;
import com.mathworks.toolbox.distcomp.admincenter.services.view.ModulePane;
import com.mathworks.toolbox.distcomp.admincenter.services.view.ServiceInfoTable;
import com.mathworks.toolbox.distcomp.admincenter.services.view.ServiceInfoTableTargetSource;
import com.mathworks.toolbox.distcomp.admincenter.services.view.ServiceStatusTargetSource;
import com.mathworks.toolbox.distcomp.admincenter.services.view.StartJMAction;
import com.mathworks.toolbox.distcomp.admincenter.services.view.StartMDCEAction;
import com.mathworks.toolbox.distcomp.admincenter.services.view.StartWorkersAction;
import com.mathworks.toolbox.distcomp.admincenter.services.view.StopActionEnum;
import com.mathworks.toolbox.distcomp.admincenter.services.view.StopMDCEAction;
import com.mathworks.toolbox.distcomp.admincenter.services.view.TableModelRowsTargetSource;
import com.mathworks.toolbox.distcomp.control.serviceinfo.JobManagerServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.MDCSServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceStatus;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.Action;

public class HostsModulePane
extends ModulePane<HostTableModel> {
    private static final String HELP = "AC_HOSTS_MODULE";
    private static final String COMP_NAME_ADD_HOSTS = "addHosts";
    private static final String COMP_NAME_TEST = "test";
    private static final String COMP_NAME_START_JM = "startJM";
    private static final String COMP_NAME_START_MDCE = "startMDCE";
    private static final String COMP_NAME_STOPMDCE = "stopMDCE";
    private static final String COMP_NAME_DESTROYMDCE = "destroyMDCE";
    private static final String COMP_NAME_START_WORKERS = "startWorkers";
    private static final String COMP_NAME_DELIST = "delist";
    private final MJDialog fTestResultsDialog;
    private Action fAddAction;

    public HostsModulePane(ClientMonitor clientMonitor, MJDialog mJDialog) {
        super(clientMonitor.getHostTableModel(), ResourceStatics.sRes.getString("module.hosts.name"), ResourceStatics.sRes.getString("module.hosts.name"), HELP, clientMonitor);
        this.fTestResultsDialog = mJDialog;
        this.init();
    }

    public Action getAddHostsAction() {
        return this.fAddAction;
    }

    @Override
    protected void initActions() {
        List<ModuleAction> list = this.getActionList(ModulePane.ActionPlacement.SHORTCUT);
        List<ModuleAction> list2 = this.getActionList(ModulePane.ActionPlacement.POPUP);
        List<ModuleAction> list3 = this.getActionList(ModulePane.ActionPlacement.MENUBAR);
        ServiceInfoTableTargetSource serviceInfoTableTargetSource = new ServiceInfoTableTargetSource(this.getMonitor(), this.getTable());
        ServiceStatusTargetSource serviceStatusTargetSource = new ServiceStatusTargetSource(this.getMonitor(), this.getTable(), ServiceStatus.RUNNING);
        ServiceStatusTargetSource serviceStatusTargetSource2 = new ServiceStatusTargetSource(this.getMonitor(), this.getTable(), ServiceStatus.RUNNING, ServiceInfoTableTargetSource.CountQuality.EXACTLY_ONE);
        TableModelRowsTargetSource<JobManagerServiceInfo> tableModelRowsTargetSource = new TableModelRowsTargetSource<JobManagerServiceInfo>(this.getMonitor().getJobManagerTableModel());
        TableModelRowsTargetSource<MDCSServiceInfo> tableModelRowsTargetSource2 = new TableModelRowsTargetSource<MDCSServiceInfo>(this.getMonitor().getHostTableModel(), false);
        AddHostsAction addHostsAction = new AddHostsAction(null, COMP_NAME_ADD_HOSTS, this.getResponseHandler(), this.getMonitor(), this.getProgressListener(), this.getErrorHandler());
        this.fAddAction = addHostsAction;
        AllReachableAndNotRunningMDCE allReachableAndNotRunningMDCE = new AllReachableAndNotRunningMDCE(this.getTable());
        StartMDCEAction startMDCEAction = new StartMDCEAction(ResourceStatics.sRes.getString("module.hosts.action.startmdce"), allReachableAndNotRunningMDCE, COMP_NAME_START_MDCE, this.getResponseHandler(), this.getMonitor(), this.getProgressListener(), this.getErrorHandler());
        AllRunningMDCE allRunningMDCE = new AllRunningMDCE(this.getTable());
        StopMDCEAction stopMDCEAction = new StopMDCEAction(StopActionEnum.STOP, allRunningMDCE, COMP_NAME_STOPMDCE, this.getResponseHandler(), this.getMonitor(), this.getProgressListener(), this.getErrorHandler());
        StopMDCEAction stopMDCEAction2 = new StopMDCEAction(StopActionEnum.DESTROY, allRunningMDCE, COMP_NAME_DESTROYMDCE, this.getResponseHandler(), this.getMonitor(), this.getProgressListener(), this.getErrorHandler());
        ModuleAction moduleAction = new ModuleAction(ResourceStatics.sRes.getString("module.hosts.action.testing"), tableModelRowsTargetSource2, COMP_NAME_TEST){

            public void actionPerformed(ActionEvent actionEvent) {
                HostsModulePane.this.fTestResultsDialog.setLocationRelativeTo((Component)HostsModulePane.this.fTestResultsDialog.getOwner());
                HostsModulePane.this.fTestResultsDialog.show();
            }
        };
        StartJMAction startJMAction = new StartJMAction(ResourceStatics.sRes.getString("module.hosts.action.startjm"), serviceStatusTargetSource2, COMP_NAME_START_JM, this.getResponseHandler(), this.getMonitor(), this.getProgressListener(), this.getErrorHandler());
        StartWorkersAction startWorkersAction = new StartWorkersAction(ResourceStatics.sRes.getString("module.hosts.action.startworkers"), new AggregateTargetSource(tableModelRowsTargetSource, serviceStatusTargetSource), COMP_NAME_START_WORKERS, this.getResponseHandler(), this.getMonitor(), this.getProgressListener(), this.getErrorHandler());
        DelistHostsAction delistHostsAction = new DelistHostsAction(serviceInfoTableTargetSource, COMP_NAME_DELIST, this.getResponseHandler(), this.getMonitor(), this.getProgressListener(), this.getErrorHandler());
        list.add(addHostsAction);
        list.add(startMDCEAction);
        list.add(stopMDCEAction);
        list.add(moduleAction);
        list2.add(addHostsAction);
        list2.add(delistHostsAction);
        list2.add(null);
        list2.add(startMDCEAction);
        list2.add(stopMDCEAction);
        list2.add(stopMDCEAction2);
        list2.add(null);
        list2.add(startJMAction);
        list2.add(startWorkersAction);
        list2.add(null);
        list2.add(moduleAction);
        list3.add(addHostsAction);
        list3.add(delistHostsAction);
        list3.add(null);
        list3.add(startMDCEAction);
        list3.add(stopMDCEAction);
        list3.add(stopMDCEAction2);
        list3.add(null);
        list3.add(startJMAction);
        list3.add(startWorkersAction);
        list3.add(null);
        list3.add(moduleAction);
    }

    @Override
    protected ServiceInfoTable<HostTableModel> createTable() {
        ServiceInfoTable<HostTableModel> serviceInfoTable = new ServiceInfoTable<HostTableModel>((HostTableModel)this.getTableModel());
        serviceInfoTable.setOverrideCellRenderer(Hostname.class, new HostnameRenderer(true));
        return serviceInfoTable;
    }

    private class AllRunningMDCE
    extends ServiceInfoTableTargetSource {
        private AllRunningMDCE(ServiceInfoTable<?> serviceInfoTable) {
            super(HostsModulePane.this.getMonitor(), serviceInfoTable);
        }

        @Override
        protected boolean areTargetsProper() {
            if (!super.areTargetsProper()) {
                return false;
            }
            for (ServiceInfo serviceInfo : this.getTargets()) {
                if (serviceInfo.getStatus().equals((Object)ServiceStatus.RUNNING)) continue;
                return false;
            }
            return true;
        }
    }

    private class AllReachableAndNotRunningMDCE
    extends ServiceInfoTableTargetSource {
        private AllReachableAndNotRunningMDCE(ServiceInfoTable<?> serviceInfoTable) {
            super(HostsModulePane.this.getMonitor(), serviceInfoTable);
        }

        @Override
        protected boolean areTargetsProper() {
            if (!super.areTargetsProper()) {
                return false;
            }
            for (ServiceInfo serviceInfo : this.getTargets()) {
                if (((MDCSServiceInfo)serviceInfo).isHostResolvable() && !serviceInfo.getStatus().equals((Object)ServiceStatus.RUNNING) && !serviceInfo.getStatus().equals((Object)ServiceStatus.UNSUPPORTED_VERSION)) continue;
                return false;
            }
            return true;
        }
    }
}

