/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.services.view;

import com.jidesoft.pane.CollapsiblePane;
import com.jidesoft.swing.JideButton;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolbox.distcomp.admincenter.guiutilities.ACHelpButtonFactory;
import com.mathworks.toolbox.distcomp.admincenter.resources.ResourceStatics;
import com.mathworks.toolbox.distcomp.admincenter.services.action.DefaultSystemErrorHandler;
import com.mathworks.toolbox.distcomp.admincenter.services.action.ModuleAction;
import com.mathworks.toolbox.distcomp.admincenter.services.action.ResponseHandler;
import com.mathworks.toolbox.distcomp.admincenter.services.action.SystemErrorHandler;
import com.mathworks.toolbox.distcomp.admincenter.services.model.ClientMonitor;
import com.mathworks.toolbox.distcomp.admincenter.services.model.ServiceTableModel;
import com.mathworks.toolbox.distcomp.admincenter.services.model.SubmissionProgressListener;
import com.mathworks.toolbox.distcomp.admincenter.services.view.DefaultResponseHandler;
import com.mathworks.toolbox.distcomp.admincenter.services.view.ModuleGroup;
import com.mathworks.toolbox.distcomp.admincenter.services.view.ProgressHandler;
import com.mathworks.toolbox.distcomp.admincenter.services.view.ServiceDetailDisplay;
import com.mathworks.toolbox.distcomp.admincenter.services.view.ServiceInfoTable;
import com.mathworks.toolbox.distcomp.admincenter.services.view.ServiceInfoTableTargetSource;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuideEmptyPanel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuideRelatedPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;

public abstract class ModulePane<M extends ServiceTableModel<?, ?>>
extends CollapsiblePane {
    private final M fTableModel;
    private final ClientMonitor fMonitor;
    private ServiceInfoTable<M> fTable;
    private final Map<ActionPlacement, List<ModuleAction>> fActions;
    private MJPopupMenu fPopup;
    private ModuleGroup fGroup;
    private MJPanel fShortcutPanel;
    private final SubmissionProgressListener fProgressListener;
    private final ResponseHandler fResponseHandler;
    private final SystemErrorHandler fErrorHandler;
    private static final String COMP_NAME_PROPERTIES = "properties";
    private final String fActionName;

    public ModulePane(M m, String string, String string2, String string3, ClientMonitor clientMonitor) {
        super(MJUtilities.exciseMnemonic((String)string));
        this.fTableModel = m;
        this.fMonitor = clientMonitor;
        this.fActionName = string2;
        JButton jButton = ACHelpButtonFactory.createIconOnlyHelpButton(string3, "ModulePane.HelpButton");
        MJPanel mJPanel = new MJPanel();
        mJPanel.add((Component)jButton);
        mJPanel.setOpaque(false);
        this.setTitleComponent((Component)mJPanel);
        this.setShowExpandButton(false);
        this.setCollapsible(false);
        this.fActions = new EnumMap<ActionPlacement, List<ModuleAction>>(ActionPlacement.class);
        this.fActions.put(ActionPlacement.SHORTCUT, new ArrayList());
        this.fActions.put(ActionPlacement.POPUP, new ArrayList());
        this.fActions.put(ActionPlacement.MENUBAR, new ArrayList());
        this.fProgressListener = new ProgressHandler();
        this.fResponseHandler = new DefaultResponseHandler();
        this.fErrorHandler = new DefaultSystemErrorHandler();
        this.setName(((Object)((Object)this)).getClass().getSimpleName());
    }

    public List<JComponent> getMenubarComponents() {
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        for (ModuleAction moduleAction : this.fActions.get((Object)ActionPlacement.MENUBAR)) {
            if (ModulePane.menuActionImpliesSeparator(moduleAction)) {
                arrayList.add(new JPopupMenu.Separator());
                continue;
            }
            arrayList.add((JComponent)new MJMenuItem((Action)((Object)moduleAction)));
        }
        return arrayList;
    }

    public Dimension getMaximumSize() {
        Dimension dimension = super.getMaximumSize();
        if (!this.isExpanded()) {
            dimension.height = this.getMinimumSize().height;
        }
        return dimension;
    }

    int getPreferredShortcutWidth() {
        return this.fShortcutPanel.getLayout().preferredLayoutSize((Container)this.fShortcutPanel).width;
    }

    protected void init() {
        this.setEmphasized(true);
        this.setInitDelay(100);
        this.setOpaque(false);
        this.fTable = this.createTable();
        this.fTable.sortColumn(0);
        this.initActions();
        this.addMenubarSeparator();
        this.fActions.get((Object)ActionPlacement.MENUBAR).add(new ShowPropertiesAction());
        this.fPopup = this.createPopup();
        this.fTable.addMouseListener(new PopupHandler());
        this.fShortcutPanel = this.createShortcutPanel();
        MJScrollPane mJScrollPane = new MJScrollPane(this.fTable);
        mJScrollPane.getViewport().setBackground(Color.WHITE);
        mJScrollPane.getViewport().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                ModulePane.this.fTable.clearSelection();
            }
        });
        Dimension dimension = new Dimension();
        dimension.height = this.fTable.getTableHeader().getPreferredSize().height;
        dimension.width = this.fTable.getTableHeader().getMinimumSize().width;
        Dimension dimension2 = mJScrollPane.getVerticalScrollBar().getPreferredSize();
        dimension.width += dimension2.width;
        dimension.height += dimension2.height;
        mJScrollPane.setMinimumSize(dimension);
        StyleGuideEmptyPanel styleGuideEmptyPanel = new StyleGuideEmptyPanel();
        styleGuideEmptyPanel.addLine((JComponent[][])new JComponent[][]{{this.fShortcutPanel, mJScrollPane}}, 8, 1);
        this.setContentPane((JComponent)((Object)styleGuideEmptyPanel));
        this.initComponentNames();
    }

    protected List<ModuleAction> getActionList(ActionPlacement actionPlacement) {
        return this.fActions.get((Object)actionPlacement);
    }

    protected abstract void initActions();

    protected abstract ServiceInfoTable<M> createTable();

    protected M getTableModel() {
        return this.fTableModel;
    }

    private static boolean menuActionImpliesSeparator(ModuleAction moduleAction) {
        return moduleAction == null;
    }

    private void addMenubarSeparator() {
        this.fActions.get((Object)ActionPlacement.MENUBAR).add(null);
    }

    protected ServiceInfoTable<M> getTable() {
        return this.fTable;
    }

    private void initComponentNames() {
        this.getTable().setName(((Object)((Object)this)).getClass().getSimpleName() + "Table");
    }

    private MJPopupMenu createPopup() {
        MJPopupMenu mJPopupMenu = new MJPopupMenu();
        ShowPropertiesAction showPropertiesAction = new ShowPropertiesAction();
        MJMenuItem mJMenuItem = new MJMenuItem((Action)((Object)showPropertiesAction));
        for (ModuleAction moduleAction : this.fActions.get((Object)ActionPlacement.POPUP)) {
            if (ModulePane.menuActionImpliesSeparator(moduleAction)) {
                mJPopupMenu.addSeparator();
                continue;
            }
            mJPopupMenu.add((Action)((Object)moduleAction));
        }
        mJPopupMenu.addSeparator();
        mJPopupMenu.add((JMenuItem)mJMenuItem);
        return mJPopupMenu;
    }

    private MJPanel createShortcutPanel() {
        StyleGuideRelatedPanel styleGuideRelatedPanel = new StyleGuideRelatedPanel(){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                if (ModulePane.this.fGroup != null) {
                    dimension.width = ModulePane.this.fGroup.getPreferredShortcutPanelWidth();
                }
                return dimension;
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        for (ModuleAction moduleAction : this.fActions.get((Object)ActionPlacement.SHORTCUT)) {
            JideButton jideButton = new JideButton((Action)((Object)moduleAction));
            jideButton.setMnemonic('\u0000');
            jideButton.setButtonStyle(3);
            jideButton.setName(moduleAction.getComponentName() + "Button");
            styleGuideRelatedPanel.addLine((JComponent[][])new JComponent[][]{{jideButton, null}}, 0, 1);
        }
        styleGuideRelatedPanel.addLine((JComponent)((Object)new StyleGuideEmptyPanel()), 8);
        return styleGuideRelatedPanel;
    }

    protected ClientMonitor getMonitor() {
        return this.fMonitor;
    }

    public void setGroup(ModuleGroup moduleGroup) {
        this.fGroup = moduleGroup;
    }

    protected SubmissionProgressListener getProgressListener() {
        return this.fProgressListener;
    }

    protected ResponseHandler getResponseHandler() {
        return this.fResponseHandler;
    }

    protected SystemErrorHandler getErrorHandler() {
        return this.fErrorHandler;
    }

    public String getActionName() {
        return this.fActionName;
    }

    private class ShowPropertiesAction
    extends ModuleAction {
        ShowPropertiesAction() {
            super(ResourceStatics.sRes.getString("services.dialog.properties"), new ServiceInfoTableTargetSource(ModulePane.this.getMonitor(), ModulePane.this.getTable()), ModulePane.COMP_NAME_PROPERTIES);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ServiceDetailDisplay.showServiceDetails(this.getTargetSource().getTargets(), actionEvent);
        }
    }

    protected static enum ActionPlacement {
        SHORTCUT,
        POPUP,
        MENUBAR;

    }

    private class PopupHandler
    extends MouseAdapter {
        private PopupHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.maybePopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybePopup(mouseEvent);
        }

        private void maybePopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                int n;
                JTable jTable;
                if (mouseEvent.getComponent() instanceof JTable && !(jTable = (JTable)mouseEvent.getComponent()).isRowSelected(n = jTable.rowAtPoint(mouseEvent.getPoint()))) {
                    jTable.getSelectionModel().setSelectionInterval(n, n);
                }
                ModulePane.this.fPopup.show((Component)((Object)ModulePane.this.fTable), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

