/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.services.view;

import com.mathworks.common.icons.DialogIcon;
import com.mathworks.mwswing.DefaultSortableTable;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJSpinner;
import com.mathworks.toolbox.distcomp.admincenter.services.action.TargetSource;
import com.mathworks.toolbox.distcomp.admincenter.services.model.ClientMonitor;
import com.mathworks.toolbox.distcomp.admincenter.services.view.HostnameRenderer;
import com.mathworks.toolbox.distcomp.admincenter.services.view.ServiceDialog;
import com.mathworks.toolbox.distcomp.admincenter.services.view.TableTooltipUtil;
import com.mathworks.toolbox.distcomp.control.serviceinfo.JobManagerServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.MDCSServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceStatus;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuideEmptyPanel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuidePanel;
import com.mathworks.toolbox.distcomp.util.ResourceBundleUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.DefaultFormatter;

public class StartWorkersDialog
extends ServiceDialog<StartWorkersInfo> {
    private static final ResourceBundleUtilities sRes = ResourceBundleUtilities.getInstance(StartWorkersDialog.class);
    private static final String HELP = "AC_START_WORKERS";
    private static final ImageIcon VALID_ICON = DialogIcon.INFO_32x32.getIcon();
    private static final ImageIcon WARNING_ICON = DialogIcon.WARNING_32x32.getIcon();

    protected StartWorkersDialog(Frame frame, ClientMonitor clientMonitor, TargetSource targetSource) {
        super(frame, sRes.getString("services.dialog.startworkers", new Object[0]), sRes.getString("services.dialog.okay", new Object[0]), HELP, new StartWorkersContent(clientMonitor, targetSource));
    }

    private static class HostSelectCellRenderer
    extends MJCheckBox
    implements TableCellRenderer {
        private HostSelectCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            HostModelData hostModelData = (HostModelData)object;
            this.setSelected(hostModelData != null && hostModelData.isSelected());
            this.setText(hostModelData != null ? hostModelData.getHostname() : "");
            return this;
        }
    }

    private static class HostSelectCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private final HostSelectCellRenderer fRenderer = new HostSelectCellRenderer();

        private HostSelectCellEditor() {
            this.fRenderer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HostSelectCellEditor.this.stopCellEditing();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.fRenderer.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
            return this.fRenderer;
        }

        @Override
        public Object getCellEditorValue() {
            return this.fRenderer.isSelected();
        }
    }

    private static class SortableHostsTable
    extends DefaultSortableTable {
        private final HostModel fHostModel;

        private SortableHostsTable(HostModel hostModel) {
            super((TableModel)hostModel);
            this.fHostModel = hostModel;
            this.setDefaultEditor(HostColumn.MAIN.getType(), new HostSelectCellEditor());
            this.setDefaultRenderer(HostColumn.MAIN.getType(), new HostSelectCellRenderer());
            ((JLabel)((Object)this.getDefaultRenderer(Number.class))).setHorizontalAlignment(2);
        }

        public List<MDCSServiceInfo> getSelectedHostInfo() {
            return this.fHostModel.getSelectedHostInfo();
        }

        public void setSelectedHostInfo(Collection<MDCSServiceInfo> collection) {
            this.fHostModel.setSelectedHostInfo(collection);
        }

        public void selectAllHosts() {
            this.fHostModel.selectAll();
        }

        public void clearHostSelection() {
            this.fHostModel.clearSelection();
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            return TableTooltipUtil.getTooltip((JTable)((Object)this), mouseEvent);
        }
    }

    private static class HostModel
    extends AbstractTableModel {
        private final List<HostModelData> fData = new ArrayList<HostModelData>();

        private HostModel(List<MDCSServiceInfo> list) {
            for (MDCSServiceInfo mDCSServiceInfo : list) {
                this.fData.add(new HostModelData(mDCSServiceInfo));
            }
        }

        @Override
        public int getRowCount() {
            return this.fData.size();
        }

        @Override
        public int getColumnCount() {
            return HostColumn.values().length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            HostColumn hostColumn = HostColumn.values()[n2];
            HostModelData hostModelData = this.fData.get(n);
            switch (hostColumn) {
                case CORES: {
                    return hostModelData.getCores();
                }
                case WORKERS: {
                    return hostModelData.getNumberRunningWorkers();
                }
                case MAIN: {
                    return hostModelData;
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return HostColumn.values()[n].getType();
        }

        @Override
        public String getColumnName(int n) {
            return HostColumn.values()[n].getColumnName();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return HostColumn.values()[n2].isEditable();
        }

        public List<MDCSServiceInfo> getSelectedHostInfo() {
            ArrayList<MDCSServiceInfo> arrayList = new ArrayList<MDCSServiceInfo>();
            for (HostModelData hostModelData : this.fData) {
                if (!hostModelData.isSelected()) continue;
                arrayList.add(hostModelData.getHostInfo());
            }
            return arrayList;
        }

        public void setSelectedHostInfo(Collection<MDCSServiceInfo> collection) {
            for (HostModelData hostModelData : this.fData) {
                if (!collection.contains(hostModelData.getHostInfo())) continue;
                hostModelData.setSelected(true);
            }
            this.fireTableChanged(new TableModelEvent(this, 0, this.fData.size() - 1, HostColumn.MAIN.ordinal()));
        }

        public void selectAll() {
            for (HostModelData hostModelData : this.fData) {
                hostModelData.setSelected(true);
            }
            this.fireTableChanged(new TableModelEvent(this, 0, this.fData.size() - 1, HostColumn.MAIN.ordinal()));
        }

        public void clearSelection() {
            for (HostModelData hostModelData : this.fData) {
                hostModelData.setSelected(false);
            }
            this.fireTableChanged(new TableModelEvent(this, 0, this.fData.size() - 1, HostColumn.MAIN.ordinal()));
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 != HostColumn.MAIN.ordinal()) {
                return;
            }
            this.fData.get(n).setSelected((Boolean)object);
            this.fireTableCellUpdated(n, n2);
        }
    }

    private static enum HostColumn {
        MAIN(HostModelData.class, true, null),
        CORES(Integer.class, false, 50),
        WORKERS(Integer.class, false, 100);

        private final Class<?> fType;
        private final boolean fEditable;
        private final Integer fPrefWidth;

        private HostColumn(Class<?> clazz, boolean bl, Integer n2) {
            this.fType = clazz;
            this.fEditable = bl;
            this.fPrefWidth = n2;
        }

        public Class<?> getType() {
            return this.fType;
        }

        public String getColumnName() {
            return sRes.getString("services.dialog.startworkers.hostcolumn." + (Object)((Object)this), new Object[0]);
        }

        public boolean isEditable() {
            return this.fEditable;
        }

        public Integer getPrefWidth() {
            return this.fPrefWidth;
        }
    }

    private static class HostModelData
    implements Comparable<HostModelData> {
        private boolean fSelected = false;
        private final MDCSServiceInfo fHost;

        private HostModelData(MDCSServiceInfo mDCSServiceInfo) {
            this.fHost = mDCSServiceInfo;
        }

        public String getHostname() {
            return HostnameRenderer.getDisplayHostname(this.fHost, true);
        }

        public Integer getCores() {
            return this.fHost != null ? this.fHost.getNumCores() : null;
        }

        public Integer getNumberRunningWorkers() {
            return this.fHost != null ? Integer.valueOf(this.fHost.getWorkerNames().size()) : null;
        }

        public boolean isSelected() {
            return this.fSelected;
        }

        public void setSelected(boolean bl) {
            this.fSelected = bl;
        }

        public MDCSServiceInfo getHostInfo() {
            return this.fHost;
        }

        @Override
        public int compareTo(HostModelData hostModelData) {
            if (hostModelData == null) {
                return 1;
            }
            return this.getHostname().compareTo(hostModelData.getHostname());
        }

        public String toString() {
            return this.getHostname();
        }
    }

    private static class StartWorkersContent
    extends StyleGuidePanel
    implements ServiceDialog.ServiceDialogContent<StartWorkersInfo> {
        private final ClientMonitor fMonitor;
        private MJButton fOkayButton;
        private final SortableHostsTable fHostTable;
        private final MJSpinner fNumSpinner;
        private final MJComboBox fJmCombo;
        private final MJLabel fStatusLabel;
        private final MJButton fSelectAllButton;
        private final MJButton fClearAllButton;
        private static final int MIN_WORKERS_PER_HOST = 1;
        private static final int MAX_WORKERS_PER_HOST = 64;
        private static final int DEFAULT_WORKERS_PER_HOST = 1;

        private StartWorkersContent(ClientMonitor clientMonitor, TargetSource targetSource) {
            Object object;
            Serializable serializable;
            this.fMonitor = clientMonitor;
            this.fNumSpinner = new MJSpinner((SpinnerModel)new SpinnerNumberModel(1, 1, 64, 1));
            JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)this.fNumSpinner.getEditor()).getTextField();
            ((DefaultFormatter)jFormattedTextField.getFormatter()).setAllowsInvalid(false);
            jFormattedTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    StartWorkersContent.this.checkValidity();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                }
            });
            List list = clientMonitor.getHostTableModel().getInfoList();
            ArrayList<MDCSServiceInfo> arrayList = new ArrayList<MDCSServiceInfo>();
            for (MDCSServiceInfo mDCSServiceInfo : list) {
                if (mDCSServiceInfo.getStatus() != ServiceStatus.RUNNING) continue;
                arrayList.add(mDCSServiceInfo);
            }
            this.fHostTable = new SortableHostsTable(new HostModel(arrayList));
            this.fHostTable.setRowSelectionAllowed(false);
            this.fHostTable.sortByColumn(HostColumn.MAIN.ordinal(), 0);
            for (HostColumn object22 : HostColumn.values()) {
                serializable = object22.getPrefWidth();
                if (serializable != null) {
                    this.fHostTable.getColumnModel().getColumn(object22.ordinal()).setPreferredWidth((int)serializable);
                    this.fHostTable.getColumnModel().getColumn(object22.ordinal()).setMinWidth((int)serializable);
                    continue;
                }
                this.fHostTable.getColumnModel().getColumn(object22.ordinal()).setPreferredWidth(Short.MAX_VALUE);
            }
            this.fHostTable.setPreferredScrollableViewportSize(new Dimension(325, 100));
            if (targetSource != null) {
                object = targetSource.getTargets();
                ArrayList<MDCSServiceInfo> arrayList2 = new ArrayList<MDCSServiceInfo>();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    ServiceInfo serviceInfo = (ServiceInfo)iterator.next();
                    if (!(serviceInfo instanceof MDCSServiceInfo)) continue;
                    arrayList2.add((MDCSServiceInfo)serviceInfo);
                }
                this.fHostTable.setSelectedHostInfo(arrayList2);
            }
            this.fSelectAllButton = new MJButton(sRes.getString("services.dialog.startworkers.selectall", new Object[0]));
            this.fSelectAllButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StartWorkersContent.this.fHostTable.selectAllHosts();
                }
            });
            this.fClearAllButton = new MJButton(sRes.getString("services.dialog.startworkers.clearall", new Object[0]));
            this.fClearAllButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StartWorkersContent.this.fHostTable.clearHostSelection();
                    StartWorkersContent.this.fHostTable.clearHostSelection();
                }
            });
            object = new ArrayList();
            for (JobManagerServiceInfo jobManagerServiceInfo : clientMonitor.getJobManagerTableModel().getInfoList()) {
                if (jobManagerServiceInfo.getStatus() != ServiceStatus.RUNNING) continue;
                object.add(jobManagerServiceInfo);
            }
            this.fJmCombo = new MJComboBox(object.toArray());
            final ListCellRenderer listCellRenderer = this.fJmCombo.getRenderer();
            this.fJmCombo.setRenderer(new ListCellRenderer(){

                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    JobManagerServiceInfo jobManagerServiceInfo = (JobManagerServiceInfo)object;
                    String string = jobManagerServiceInfo.getServiceName() + "@" + HostnameRenderer.getDisplayHostname(jobManagerServiceInfo);
                    return listCellRenderer.getListCellRendererComponent(jList, string, n, bl, bl2);
                }
            });
            if (targetSource != null) {
                for (ServiceInfo serviceInfo : targetSource.getTargets()) {
                    if (!(serviceInfo instanceof JobManagerServiceInfo)) continue;
                    this.fJmCombo.setSelectedItem((Object)serviceInfo);
                }
            }
            this.fHostTable.getModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent tableModelEvent) {
                    StartWorkersContent.this.checkValidity();
                }
            });
            this.fStatusLabel = new MJLabel();
            JComponent jComponent = this.createHostsSection();
            JComponent jComponent2 = this.createJobManagerSection();
            serializable = this.createWorkersSection();
            this.addLine(jComponent, 8);
            this.addLine(jComponent2);
            this.addLine((JComponent)serializable);
            this.addLine((JComponent)this.fStatusLabel);
            this.fNumSpinner.setName("StartWorkersDialog.NumWorkersSpinner");
            this.fHostTable.setName("StartWorkersDialog.HostsTable");
            this.fJmCombo.setName("StartWorkersDialog.JobManagerCombobox");
            this.fStatusLabel.setName("StartWorkersDialog.StatusLabel");
            this.fClearAllButton.setName("StartWorkersDialog.ClearAllButton");
            this.fSelectAllButton.setName("StartWorkersDialog.SelectAllButton");
        }

        private JComponent createWorkersSection() {
            StyleGuidePanel styleGuidePanel = new StyleGuidePanel();
            styleGuidePanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(), sRes.getString("services.dialog.startworkers.workers.title", new Object[0])));
            MJLabel mJLabel = new MJLabel(sRes.getString("services.dialog.startworkers.workers.blurb", new Object[0]));
            MJLabel mJLabel2 = new MJLabel(sRes.getString("services.dialog.startworkers.workernum.pre", new Object[0]));
            MJLabel mJLabel3 = new MJLabel(sRes.getString("services.dialog.startworkers.workernum.post", new Object[0]));
            styleGuidePanel.addLine((JComponent[][])new JComponent[][]{{mJLabel, null, mJLabel2, this.fNumSpinner, mJLabel3}}, 0, 1);
            return styleGuidePanel;
        }

        private JComponent createJobManagerSection() {
            StyleGuidePanel styleGuidePanel = new StyleGuidePanel();
            styleGuidePanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(), sRes.getString("services.dialog.startworkers.jobmanager.title", new Object[0])));
            MJLabel mJLabel = new MJLabel(sRes.getString("services.dialog.startworkers.jobmanager.blurb", new Object[0]));
            styleGuidePanel.addLine((JComponent[][])new JComponent[][]{{mJLabel, this.fJmCombo}}, 0, 1);
            return styleGuidePanel;
        }

        private JComponent createHostsSection() {
            StyleGuidePanel styleGuidePanel = new StyleGuidePanel();
            styleGuidePanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(), sRes.getString("services.dialog.startworkers.hosts.title", new Object[0])));
            MJLabel mJLabel = new MJLabel(sRes.getString("services.dialog.startworkers.hosts.blurb", new Object[0]));
            StyleGuidePanel styleGuidePanel2 = new StyleGuidePanel(){

                @Override
                protected int getLeftInset() {
                    return 0;
                }

                @Override
                protected int getTopInset() {
                    return 0;
                }

                @Override
                protected int getBottomInset() {
                    return 0;
                }
            };
            styleGuidePanel2.addLine((JComponent)mJLabel);
            styleGuidePanel2.addLine((JComponent)((Object)new StyleGuideEmptyPanel()), 8);
            styleGuidePanel2.addLine((JComponent[][])new JComponent[][]{{null, this.fSelectAllButton}, {null, this.fClearAllButton}}, 0, 0);
            MJScrollPane mJScrollPane = new MJScrollPane((Component)((Object)this.fHostTable));
            mJScrollPane.getViewport().setBackground(Color.WHITE);
            styleGuidePanel.addLine((JComponent[][])new JComponent[][]{{styleGuidePanel2, mJScrollPane}}, 8, 1);
            return styleGuidePanel;
        }

        @Override
        public JComponent getComponent() {
            return this;
        }

        @Override
        public StartWorkersInfo getValue() {
            return new StartWorkersInfo(){

                @Override
                public int getWorkersPerNode() {
                    return (Integer)StartWorkersContent.this.fNumSpinner.getValue();
                }

                @Override
                public List<MDCSServiceInfo> getHosts() {
                    return StartWorkersContent.this.fHostTable.getSelectedHostInfo();
                }

                @Override
                public JobManagerServiceInfo getJobManager() {
                    return (JobManagerServiceInfo)StartWorkersContent.this.fJmCombo.getSelectedItem();
                }
            };
        }

        @Override
        public void registerOkayButton(MJButton mJButton) {
            this.fOkayButton = mJButton;
            this.checkValidity();
        }

        private void checkValidity() {
            String string;
            JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)this.fNumSpinner.getEditor()).getTextField();
            int n = Integer.parseInt(jFormattedTextField.getText()) * this.fHostTable.getSelectedHostInfo().size();
            if (this.fOkayButton == null) {
                return;
            }
            boolean bl = n > 0;
            this.fOkayButton.setEnabled(bl);
            if (bl) {
                String string2 = n > 1 ? sRes.getString("services.dialog.startworkers.total.workers", new Object[0]) : sRes.getString("services.dialog.startworkers.total.worker", new Object[0]);
                string = sRes.getString("services.dialog.startworkers.total", n, string2, n + this.fMonitor.getWorkerTableModel().getRunningWorkers());
            } else {
                string = sRes.getString("services.dialog.startworkers.invalid", new Object[0]);
            }
            this.fStatusLabel.setText(string);
            this.fStatusLabel.setIcon((Icon)(bl ? VALID_ICON : WARNING_ICON));
        }
    }

    public static interface StartWorkersInfo {
        public int getWorkersPerNode();

        public List<MDCSServiceInfo> getHosts();

        public JobManagerServiceInfo getJobManager();
    }
}

